/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.Track;
import com.jme3.effect.ParticleEmitter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.util.TempVars;
import java.io.IOException;

public class EffectTrack
implements Track {
    private ParticleEmitter emitter;
    private float startOffset = 0.0f;
    private float particlesPerSeconds = 0.0f;
    private float length = 0.0f;
    private boolean emitted = false;
    private boolean initialized = false;

    public EffectTrack() {
    }

    public EffectTrack(ParticleEmitter emitter, float length) {
        this.emitter = emitter;
        this.particlesPerSeconds = emitter.getParticlesPerSec();
        this.emitter.setParticlesPerSec(0.0f);
        this.length = length;
    }

    public EffectTrack(ParticleEmitter emitter, float length, float startOffset) {
        this(emitter, length);
        this.startOffset = startOffset;
    }

    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        if (!this.initialized) {
            control.addListener(new OnEndListener());
            this.initialized = true;
        }
        if (!this.emitted && time >= this.startOffset) {
            this.emitted = true;
            if (this.particlesPerSeconds == 0.0f) {
                this.emitter.emitAllParticles();
            } else {
                this.emitter.setParticlesPerSec(this.particlesPerSeconds);
            }
        }
    }

    private void stop() {
        this.emitter.setParticlesPerSec(0.0f);
        this.emitted = false;
    }

    public float getLength() {
        return this.length;
    }

    public Track clone() {
        return new EffectTrack(this.emitter, this.length, this.startOffset);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.emitter, "emitter", null);
        out.write(this.length, "length", 0.0f);
        out.write(this.startOffset, "startOffset", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.emitter = (ParticleEmitter)in.readSavable("emitter", null);
        this.particlesPerSeconds = this.emitter.getParticlesPerSec();
        this.emitter.setParticlesPerSec(0.0f);
        this.length = in.readFloat("length", this.length);
        this.startOffset = in.readFloat("startOffset", 0.0f);
    }

    private class OnEndListener
    implements AnimEventListener {
        private OnEndListener() {
        }

        public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
            EffectTrack.this.stop();
        }

        public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
            EffectTrack.this.stop();
        }
    }
}

