/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.JmeSystem;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScreenshotAppState
extends AbstractAppState
implements ActionListener,
SceneProcessor {
    private static final Logger logger = Logger.getLogger(ScreenshotAppState.class.getName());
    private String filePath = null;
    private boolean capture = false;
    private Renderer renderer;
    private ByteBuffer outBuf;
    private String appName;
    private int shotIndex = 0;
    private int width;
    private int height;

    public ScreenshotAppState() {
        this(null);
    }

    public ScreenshotAppState(String filePath) {
        this.filePath = filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        if (!super.isInitialized()) {
            InputManager inputManager = app.getInputManager();
            inputManager.addMapping("ScreenShot", new KeyTrigger(183));
            inputManager.addListener(this, "ScreenShot");
            List<ViewPort> vps = app.getRenderManager().getPostViews();
            ViewPort last = vps.get(vps.size() - 1);
            last.addProcessor(this);
            this.appName = app.getClass().getSimpleName();
        }
        super.initialize(stateManager, app);
    }

    public void onAction(String name, boolean value, float tpf) {
        if (value) {
            this.capture = true;
        }
    }

    public void takeScreenshot() {
        this.capture = true;
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderer = rm.getRenderer();
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.renderer != null;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.outBuf = BufferUtils.createByteBuffer(w * h * 4);
        this.width = w;
        this.height = h;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFrame(FrameBuffer out) {
        if (this.capture) {
            this.capture = false;
            ++this.shotIndex;
            this.renderer.setViewPort(0, 0, this.width, this.height);
            this.renderer.readFrameBuffer(out, this.outBuf);
            File file = this.filePath == null ? new File(JmeSystem.getStorageFolder() + File.separator + this.appName + this.shotIndex + ".png").getAbsoluteFile() : new File(this.filePath + this.appName + this.shotIndex + ".png").getAbsoluteFile();
            logger.log(Level.INFO, "Saving ScreenShot to: {0}", file.getAbsolutePath());
            FileOutputStream outStream = null;
            try {
                outStream = new FileOutputStream(file);
                JmeSystem.writeImageFile(outStream, "png", this.outBuf, this.width, this.height);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error while saving screenshot", ex);
            }
            finally {
                if (outStream != null) {
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Error while saving screenshot", ex);
                    }
                }
            }
        }
    }
}

