/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio;

import com.jme3.audio.AudioData;
import com.jme3.audio.AudioRenderer;
import com.jme3.util.NativeObject;
import java.nio.ByteBuffer;

public class AudioBuffer
extends AudioData {
    protected ByteBuffer audioData;

    public AudioBuffer() {
    }

    protected AudioBuffer(int id) {
        super(id);
    }

    public AudioData.DataType getDataType() {
        return AudioData.DataType.Buffer;
    }

    public float getDuration() {
        int bytesPerSec = this.bitsPerSample / 8 * this.channels * this.sampleRate;
        if (this.audioData != null) {
            return (float)this.audioData.limit() / (float)bytesPerSec;
        }
        return Float.NaN;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", ch=" + this.channels + ", bits=" + this.bitsPerSample + ", rate=" + this.sampleRate + ", duration=" + this.getDuration() + "]";
    }

    public void updateData(ByteBuffer data) {
        this.audioData = data;
        this.updateNeeded = true;
    }

    public ByteBuffer getData() {
        return this.audioData;
    }

    public void resetObject() {
        this.id = -1;
        this.setUpdateNeeded();
    }

    public void deleteObject(AudioRenderer ar) {
    }

    public void deleteObject(Object rendererObject) {
        ((AudioRenderer)rendererObject).deleteAudioData(this);
    }

    public NativeObject createDestructableClone() {
        return new AudioBuffer(this.id);
    }
}

