/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.renderer.Renderer;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Attribute;
import com.jme3.shader.Uniform;
import com.jme3.util.IntMap;
import com.jme3.util.ListMap;
import com.jme3.util.NativeObject;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Shader
extends NativeObject {
    @Deprecated
    private String language;
    private ArrayList<ShaderSource> shaderSourceList;
    private ListMap<String, Uniform> uniforms;
    private IntMap<Attribute> attribs;

    @Deprecated
    public Shader(String language) {
        super(Shader.class);
        this.language = language;
        this.initialize();
    }

    public void initialize() {
        this.shaderSourceList = new ArrayList();
        this.uniforms = new ListMap();
        this.attribs = new IntMap();
    }

    public Shader() {
        super(Shader.class);
    }

    protected Shader(Shader s) {
        super(Shader.class, s.id);
        this.shaderSourceList = new ArrayList();
        for (ShaderSource source : s.shaderSourceList) {
            this.shaderSourceList.add((ShaderSource)source.createDestructableClone());
        }
    }

    @Deprecated
    public void addSource(ShaderType type, String name, String source, String defines) {
        this.addSource(type, name, source, defines, this.language);
    }

    @Deprecated
    public void addSource(ShaderType type, String source, String defines) {
        this.addSource(type, null, source, defines);
    }

    @Deprecated
    public void addSource(ShaderType type, String source) {
        this.addSource(type, source, null);
    }

    @Deprecated
    private void addSource(ShaderSource source) {
        this.shaderSourceList.add(source);
        this.setUpdateNeeded();
    }

    public void addSource(ShaderType type, String name, String source, String defines, String language) {
        ShaderSource shaderSource = new ShaderSource(type);
        shaderSource.setSource(source);
        shaderSource.setName(name);
        shaderSource.setLanguage(language);
        if (defines != null) {
            shaderSource.setDefines(defines);
        }
        this.shaderSourceList.add(shaderSource);
        this.setUpdateNeeded();
    }

    public Uniform getUniform(String name) {
        Uniform uniform = this.uniforms.get(name);
        if (uniform == null) {
            uniform = new Uniform();
            uniform.name = name;
            this.uniforms.put(name, uniform);
        }
        return uniform;
    }

    public void removeUniform(String name) {
        this.uniforms.remove(name);
    }

    public Attribute getAttribute(VertexBuffer.Type attribType) {
        int ordinal = attribType.ordinal();
        Attribute attrib = this.attribs.get(ordinal);
        if (attrib == null) {
            attrib = new Attribute();
            attrib.name = attribType.name();
            this.attribs.put(ordinal, attrib);
        }
        return attrib;
    }

    public ListMap<String, Uniform> getUniformMap() {
        return this.uniforms;
    }

    public Collection<ShaderSource> getSources() {
        return this.shaderSourceList;
    }

    @Deprecated
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[numSources=" + this.shaderSourceList.size() + ", numUniforms=" + this.uniforms.size() + ", shaderSources=" + this.getSources() + "]";
    }

    @Deprecated
    public void resetSources() {
        this.shaderSourceList.clear();
    }

    @Deprecated
    public boolean isUsable() {
        return true;
    }

    @Deprecated
    public void setUsable(boolean usable) {
    }

    public void resetLocations() {
        if (this.uniforms != null) {
            for (Uniform uniform : this.uniforms.values()) {
                uniform.reset();
            }
        }
        if (this.attribs != null) {
            for (IntMap.Entry entry : this.attribs) {
                ((Attribute)entry.getValue()).location = -2;
            }
        }
    }

    @Override
    public void setUpdateNeeded() {
        super.setUpdateNeeded();
        this.resetLocations();
    }

    @Override
    public void resetObject() {
        this.id = -1;
        for (ShaderSource source : this.shaderSourceList) {
            source.resetObject();
        }
        this.setUpdateNeeded();
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((Renderer)rendererObject).deleteShader(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new Shader(this);
    }

    public static class ShaderSource
    extends NativeObject {
        ShaderType sourceType;
        String language;
        String name;
        String source;
        String defines;

        public ShaderSource(ShaderType type) {
            super(ShaderSource.class);
            this.sourceType = type;
            if (type == null) {
                throw new NullPointerException("The shader type must be specified");
            }
        }

        protected ShaderSource(ShaderSource ss) {
            super(ShaderSource.class, ss.id);
        }

        public ShaderSource() {
            super(ShaderSource.class);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ShaderType getType() {
            return this.sourceType;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            if (language == null) {
                throw new NullPointerException("Shader language cannot be null");
            }
            this.language = language;
            this.setUpdateNeeded();
        }

        public void setSource(String source) {
            if (source == null) {
                throw new NullPointerException("Shader source cannot be null");
            }
            this.source = source;
            this.setUpdateNeeded();
        }

        public void setDefines(String defines) {
            if (defines == null) {
                throw new NullPointerException("Shader defines cannot be null");
            }
            this.defines = defines;
            this.setUpdateNeeded();
        }

        public String getSource() {
            return this.source;
        }

        public String getDefines() {
            return this.defines;
        }

        public String toString() {
            String nameTxt = "";
            if (this.name != null) {
                nameTxt = "name=" + this.name + ", ";
            }
            if (this.defines != null) {
                nameTxt = nameTxt + "defines, ";
            }
            return this.getClass().getSimpleName() + "[" + nameTxt + "type=" + this.sourceType.name() + ", language=" + this.language + "]";
        }

        public void resetObject() {
            this.id = -1;
            this.setUpdateNeeded();
        }

        public void deleteObject(Object rendererObject) {
            ((Renderer)rendererObject).deleteShaderSource(this);
        }

        public NativeObject createDestructableClone() {
            return new ShaderSource(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShaderType {
        Fragment,
        Vertex,
        Geometry;

    }
}

