/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system;

import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.input.SoftTextDialogInput;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public abstract class JmeSystemDelegate {
    protected final Logger logger = Logger.getLogger(JmeSystem.class.getName());
    protected boolean initialized = false;
    protected boolean lowPermissions = false;
    protected File storageFolder = null;
    protected SoftTextDialogInput softTextDialogInput = null;

    public synchronized File getStorageFolder() {
        if (this.lowPermissions) {
            throw new UnsupportedOperationException("File system access restricted");
        }
        if (this.storageFolder == null) {
            this.storageFolder = new File(System.getProperty("user.home"), ".jme3");
            if (!this.storageFolder.exists()) {
                this.storageFolder.mkdir();
            }
        }
        return this.storageFolder;
    }

    public String getFullName() {
        return "jMonkeyEngine 3.0.0 Beta";
    }

    public InputStream getResourceAsStream(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    public URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    public boolean trackDirectMemory() {
        return false;
    }

    public void setLowPermissions(boolean lowPerm) {
        this.lowPermissions = lowPerm;
    }

    public boolean isLowPermissions() {
        return this.lowPermissions;
    }

    public void setSoftTextDialogInput(SoftTextDialogInput input) {
        this.softTextDialogInput = input;
    }

    public SoftTextDialogInput getSoftTextDialogInput() {
        return this.softTextDialogInput;
    }

    public abstract void writeImageFile(OutputStream var1, String var2, ByteBuffer var3, int var4, int var5) throws IOException;

    public abstract AssetManager newAssetManager(URL var1);

    public abstract AssetManager newAssetManager();

    public abstract void showErrorDialog(String var1);

    public abstract boolean showSettingsDialog(AppSettings var1, boolean var2);

    private boolean is64Bit(String arch) {
        if (arch.equals("x86")) {
            return false;
        }
        if (arch.equals("amd64")) {
            return true;
        }
        if (arch.equals("x86_64")) {
            return true;
        }
        if (arch.equals("ppc") || arch.equals("PowerPC")) {
            return false;
        }
        if (arch.equals("ppc64")) {
            return true;
        }
        if (arch.equals("i386") || arch.equals("i686")) {
            return false;
        }
        if (arch.equals("universal")) {
            return false;
        }
        throw new UnsupportedOperationException("Unsupported architecture: " + arch);
    }

    public Platform getPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean is64 = this.is64Bit(arch);
        if (os.contains("windows")) {
            return is64 ? Platform.Windows64 : Platform.Windows32;
        }
        if (os.contains("linux") || os.contains("freebsd") || os.contains("sunos")) {
            return is64 ? Platform.Linux64 : Platform.Linux32;
        }
        if (os.contains("mac os x") || os.contains("darwin")) {
            if (arch.startsWith("ppc")) {
                return is64 ? Platform.MacOSX_PPC64 : Platform.MacOSX_PPC32;
            }
            return is64 ? Platform.MacOSX64 : Platform.MacOSX32;
        }
        throw new UnsupportedOperationException("The specified platform: " + os + " is not supported.");
    }

    public abstract JmeContext newContext(AppSettings var1, JmeContext.Type var2);

    public abstract AudioRenderer newAudioRenderer(AppSettings var1);

    public abstract void initialize(AppSettings var1);
}

