/*
 * Decompiled with CFR 0.152.
 */
package ga.view;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.view.appstate.SceneState;
import ga.view.appstate.menu.IMenuListenerParent;
import ga.view.appstate.menu.MenuListener;
import ga.view.appstate.menu.MenuState;
import ga.view.config.GASettings;
import ga.view.config.ViewSettings;
import ga.view.interfaces.IPreEvaluationState;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.input.Mouse;

public class MTIEvaluator
extends SimpleApplication
implements MenuListener {
    private static final Logger LOGGER = Logger.getLogger(MTIEvaluator.class.getSimpleName());
    private boolean showStatistics;
    private MenuState menu;
    private final String viewSettingsFileName;
    private final File viewSettingsFile;
    private ViewSettings viewSettings;
    private GASettings actSettings;
    private AppState actState;

    public MTIEvaluator(String viewSettingsFileName) {
        this.viewSettingsFile = null;
        this.viewSettingsFileName = viewSettingsFileName;
    }

    public MTIEvaluator(File viewSettingsFile) {
        this.viewSettingsFile = viewSettingsFile;
        this.viewSettingsFileName = null;
    }

    public void simpleInitApp() {
        this.viewSettings = this.viewSettingsFile != null ? ViewSettings.buildFromXml(this.viewSettingsFile) : ViewSettings.buildFromXml(this.viewSettingsFileName);
        this.inputManager.setCursorVisible(!this.settings.getBoolean("ShowCursor"));
        Mouse.setGrabbed((!this.settings.getBoolean("ShowCursor") ? 1 : 0) != 0);
        this.setShowStatistics(this.settings.getBoolean("ShowStatistics"));
        this.inputManager.addMapping("showStats", new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addListener((InputListener)new StatisticsListener(), new String[]{"showStats"});
        this.inputManager.deleteMapping("SIMPLEAPP_Exit");
        this.inputManager.addMapping("exit", new Trigger[]{new KeyTrigger(1)});
        this.inputManager.addListener((InputListener)new EscapeListener(), new String[]{"exit"});
        this.flyCam.setEnabled(false);
        this.menu = new MenuState(this, this.viewSettings);
        this.setAndActivate((AppState)this.menu);
    }

    @Override
    public void modelSelected(String name) {
        this.menu.setEnabled(false);
        this.actSettings = this.viewSettings.get(name);
        if (this.actSettings.hasRun()) {
            this.actSettings.reset();
        }
        this.actSettings.setHasRun(true);
        AppState newState = null;
        newState = (AppState)this.actSettings.get("preEvaluationState");
        if (newState == null) {
            newState = (AppState)this.actSettings.get("evaluator");
        }
        this.setAndActivate(newState);
    }

    @Override
    public void nextState() {
        LOGGER.info(this.actState.getClass().getSimpleName() + " invoking next state");
        this.actState.setEnabled(false);
        Object newState = null;
        if (this.actState instanceof IPreEvaluationState) {
            newState = (AppState)this.actSettings.get("evaluator");
        } else if (this.actState instanceof IInteractiveFitnessEvaluator) {
            newState = (AppState)this.actSettings.get("postEvaluationState");
        }
        if (newState == null) {
            newState = this.menu;
        }
        this.setAndActivate((AppState)newState);
    }

    private void setAndActivate(AppState newState) {
        this.actState = newState;
        if (this.actState instanceof IMenuListenerParent) {
            ((IMenuListenerParent)this.actState).setMenuListener(this);
        }
        this.stateManager.attach(this.actState);
        this.actState.setEnabled(true);
    }

    @Override
    public void backToMenu() {
        LOGGER.info(this.actState.getClass().getSimpleName() + " exiting to main menu");
        if (this.actState != this.menu) {
            this.actState.setEnabled(false);
            this.setAndActivate((AppState)this.menu);
        } else {
            LOGGER.info("Exiting application");
            for (GASettings settings : this.viewSettings) {
                SceneState state = (SceneState)((Object)settings.get("evaluator"));
                if (state == null) continue;
                state.finalCleanUp();
            }
            this.stop();
        }
    }

    public void simpleUpdate(float tpf) {
    }

    public void setShowStatistics(boolean showStatistics) {
        this.showStatistics = showStatistics;
        LOGGER.log(Level.INFO, "show statistics - " + showStatistics);
        if (showStatistics) {
            this.guiViewPort.attachScene((Spatial)this.guiNode);
        } else {
            this.guiViewPort.detachScene((Spatial)this.guiNode);
        }
    }

    public static void main(String[] args) {
        MTIEvaluator app = new MTIEvaluator("ga/view/example/SimpleObjectGA.xml");
        AppSettings settings = new AppSettings(true);
        settings.setResolution(1280, 1024);
        try {
            FileInputStream fis = new FileInputStream("settings.properties");
            settings.load((InputStream)fis);
            fis.close();
            app.setShowSettings(false);
        }
        catch (Exception e) {
            settings.setResolution(1024, 768);
            settings.put((Object)"ShowCursor", (Object)Boolean.TRUE);
        }
        app.setSettings(settings);
        app.start();
    }

    private class EscapeListener
    implements ActionListener {
        private EscapeListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                MTIEvaluator.this.backToMenu();
            }
        }
    }

    private class StatisticsListener
    implements ActionListener {
        private StatisticsListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                MTIEvaluator.this.setShowStatistics(!MTIEvaluator.this.showStatistics);
            }
        }
    }
}

