/*
 * Decompiled with CFR 0.152.
 */
package ga.view.aerial;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import ga.core.algorithm.interactive.ISIGA;
import ga.core.evaluation.EvaluationListener;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IDebugInfo;
import ga.core.individual.IIndividual;
import ga.view.aerial.AerialUIState;
import ga.view.appstate.SceneState;
import ga.view.appstate.menu.IMenuListenerParent;
import ga.view.appstate.menu.MenuListener;
import ga.view.factory.EffectsFactory;
import ga.view.input.CamDragListener;
import ga.view.interfaces.IPhenotypeGenerator;
import ga.view.streaming.showroom.CameraSettings;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomFactory;
import ga.view.streaming.showroom.ShowRoomSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AerialEvaluationState<T extends IIndividual<T>>
extends SceneState
implements IInteractiveFitnessEvaluator<T>,
IMenuListenerParent {
    private static final Logger LOGGER = Logger.getLogger(AerialEvaluationState.class.getName());
    private final IPhenotypeGenerator<T, ? extends Spatial> phenotypeGenerator;
    private ShowRoomFactory showRoomFactory;
    private AerialUIState<T> uiState;
    private final List<EvaluationListener<T>> listeners = new ArrayList<EvaluationListener<T>>();
    private CameraSettings camSettings;
    private MenuListener menuListener;
    private AppSettings settings;
    private CamDragListener dragListener;
    private ISIGA<T> algorithm;
    private T individual;
    private Application app;

    public AerialEvaluationState(IPhenotypeGenerator<T, ? extends Spatial> phenotypeGenerator) {
        this.phenotypeGenerator = phenotypeGenerator;
    }

    @Override
    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        ShowRoomSettings srSettings;
        super.initialize(stateManager, app);
        this.app = app;
        this.phenotypeGenerator.setAssetManager(this.assetManager);
        this.settings = app.getContext().getSettings();
        Object o = this.algorithm.getContext().get((Object)"ValidationSpace");
        if (o != null && o instanceof ShowRoom) {
            srSettings = ((ShowRoom)o).getShowRoomSettings();
        } else {
            srSettings = new ShowRoomSettings();
            srSettings.put("type", (Object)ShowRoomSettings.ShowRoomType.BOX);
            srSettings.put("width", Float.valueOf(6.0f));
            srSettings.put("length", Float.valueOf(4.0f));
            srSettings.put("height", Float.valueOf(2.6f));
        }
        this.showRoomFactory = new ShowRoomFactory(this.assetManager, this.settings, srSettings);
        ShowRoom showRoom = this.showRoomFactory.createShowRoom();
        this.camSettings = CameraSettings.getOrthographicSettings(showRoom, this.settings);
        this.initCam();
        this.algorithm.getContext().put("ValidationSpace", (Object)showRoom);
        this.algorithm.getContext().put("GenomeMinLength", (Object)2);
        this.algorithm.getContext().put("GenomeMaxLength", (Object)10);
        this.algorithm.getContext().put("EvaluatedIndividualsMinCount", (Object)10);
        this.algorithm.getContext().put("IntervalFitnessMaxWidth", (Object)Float.valueOf(100.0f));
        this.algorithm.init();
        this.dragListener = new CamDragListener(this.cam, this.inputManager, this.camSettings);
        this.uiState = new AerialUIState(this, this.menuListener);
        stateManager.attach(this.uiState);
        this.inputManager.addMapping("switch view", new Trigger[]{new KeyTrigger(47)});
        this.inputManager.addListener((InputListener)new ViewSwitchListener(), new String[]{"switch view"});
        EffectsFactory.addShadowProcessor(this.assetManager, this.settings, this.viewPort, new Vector3f(3.0f, 2.1f, 3.0f));
        EffectsFactory.addLightScatteringProcessor(this.assetManager, this.inputManager, this.settings, this.viewPort, new Vector3f(3.0f, 1.9f, 3.0f));
        EffectsFactory.addSSAOProcessor(this.assetManager, this.inputManager, this.settings, this.viewPort);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.algorithm != null) {
            this.algorithm.exit();
        }
        this.stateManager.detach(this.uiState);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dragListener != null) {
            this.dragListener.setEnabled(enabled);
        }
        if (this.uiState != null) {
            this.uiState.setEnabled(enabled);
        }
    }

    private void initCam() {
        this.camSettings.configureCamera(this.cam);
    }

    public void setAlgorithm(ISIGA<T> algorithm) {
        this.algorithm = algorithm;
    }

    public ISIGA<T> getAlgorithm() {
        return this.algorithm;
    }

    public void evaluate(T individual) {
        if (individual instanceof IDebugInfo) {
            LOGGER.log(Level.WARNING, ((IDebugInfo)individual).getGenotypeString());
        } else {
            LOGGER.log(Level.WARNING, individual.toString());
        }
        this.individual = individual;
        this.rootNode.detachAllChildren();
        Spatial phenotype = this.phenotypeGenerator.createPhenotype(individual);
        ShowRoom showRoom = this.showRoomFactory.createShowRoom();
        showRoom.setPhenotype(phenotype);
        this.rootNode.attachChild((Spatial)showRoom);
        this.uiState.setIndividual(individual);
    }

    public void fireNewIndividualRequested() {
        for (EvaluationListener<T> l : this.listeners) {
            l.newIndividualRequested();
        }
    }

    public void fireIndividualEvaluated(T individual) {
        for (EvaluationListener<T> l : this.listeners) {
            l.individualEvaluated(individual);
        }
    }

    public void addEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.remove(listener);
    }

    public CamDragListener getDragListener() {
        return this.dragListener;
    }

    private class ViewSwitchListener
    implements ActionListener {
        private int i = 1;

        private ViewSwitchListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                int length = CameraSettings.Type.values().length;
                CameraSettings.Type type = CameraSettings.Type.values()[++this.i % length];
                AerialEvaluationState.this.camSettings = CameraSettings.getSettings(type, AerialEvaluationState.this.showRoomFactory.createShowRoom(), AerialEvaluationState.this.settings);
                AerialEvaluationState.this.camSettings.configureCamera(AerialEvaluationState.this.cam);
                AerialEvaluationState.this.dragListener.init(AerialEvaluationState.this.camSettings);
                LOGGER.info("Camera is now " + (Object)((Object)type));
            }
        }
    }
}

