/*
 * Decompiled with CFR 0.152.
 */
package ga.view.aerial;

import de.lessvoid.nifty.screen.DefaultScreenController;
import ga.core.individual.ICostInfo;
import ga.core.individual.IIndividual;
import ga.view.aerial.AerialEvaluationState;
import ga.view.appstate.menu.IMenuListenerParent;
import ga.view.appstate.menu.MenuListener;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AerialUIController<T extends IIndividual<T>>
extends DefaultScreenController
implements IMenuListenerParent {
    private static final Logger LOGGER = Logger.getLogger(AerialUIController.class.getName());
    private final AerialEvaluationState<T> evaluator;
    private T individual;
    private MenuListener menuListener;

    public AerialUIController(AerialEvaluationState<T> evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    public void setIndividual(T individual) {
        this.individual = individual;
    }

    public void onFitnessChange(String s) {
        double newFitness = Double.valueOf(s);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Fitness: " + newFitness);
        }
        if (this.individual != null) {
            this.individual.setFitness(newFitness);
            this.evaluator.fireIndividualEvaluated(this.individual);
            this.evaluator.fireNewIndividualRequested();
        }
    }

    public void onTerminate() {
        this.onEndScreen();
        if (this.menuListener != null) {
            this.menuListener.nextState();
        }
    }

    public String getId() {
        return this.individual != null ? String.valueOf(this.individual.getId()) : "";
    }

    public String getCosts() {
        if (this.individual != null && this.individual instanceof ICostInfo) {
            return ((ICostInfo)this.individual).getCostString();
        }
        return "";
    }

    public String getGeneration() {
        return String.valueOf(this.evaluator.getAlgorithm().getGeneration());
    }

    public void rotateLeft() {
        this.evaluator.getDragListener().rotateCamera(-0.2617994f);
    }

    public void rotateRight() {
        this.evaluator.getDragListener().rotateCamera(0.2617994f);
    }

    public void rotateUp() {
        this.evaluator.getDragListener().vRotateCamera(-0.08726646f);
    }

    public void rotateDown() {
        this.evaluator.getDragListener().vRotateCamera(0.08726646f);
    }
}

