/*
 * Decompiled with CFR 0.152.
 */
package ga.view.aerial;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppStateManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import ga.core.individual.IIndividual;
import ga.view.aerial.AerialEvaluationState;
import ga.view.aerial.AerialUIController;
import ga.view.appstate.GUIState;
import ga.view.appstate.menu.MenuListener;

public class AerialUIState<T extends IIndividual<T>>
extends GUIState {
    private AerialUIController<T> controller;
    private NiftyJmeDisplay niftyDisplay;
    private Nifty nifty;
    private AudioRenderer audioRenderer;
    private final AerialEvaluationState<T> evaluator;
    private final MenuListener menuListener;

    public AerialUIState(AerialEvaluationState<T> evaluator, MenuListener menuListener) {
        this.evaluator = evaluator;
        this.menuListener = menuListener;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.audioRenderer = app.getAudioRenderer();
        this.controller = new AerialUIController<T>(this.evaluator);
        this.controller.setMenuListener(this.menuListener);
        this.setEnabled(true);
        this.evaluator.fireNewIndividualRequested();
    }

    public void setIndividual(T individual) {
        this.controller.setIndividual(individual);
        Screen start = this.nifty.getScreen("start");
        Element element = start.findElementByName("CostsTextField");
        TextRenderer textRenderer = (TextRenderer)element.getRenderer(TextRenderer.class);
        textRenderer.setText(this.controller.getCosts());
        element = start.findElementByName("IdTextField");
        textRenderer = (TextRenderer)element.getRenderer(TextRenderer.class);
        textRenderer.setText(this.controller.getId());
        element = start.findElementByName("GenerationTextField");
        textRenderer = (TextRenderer)element.getRenderer(TextRenderer.class);
        textRenderer.setText(this.controller.getGeneration());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.niftyDisplay = new NiftyJmeDisplay(this.assetManager, this.inputManager, this.audioRenderer, this.viewPort);
            this.nifty = this.niftyDisplay.getNifty();
            this.nifty.fromXml("ga/view/ui/aerialUI.xml", "start", new ScreenController[]{this.controller});
            this.viewPort.addProcessor((SceneProcessor)this.niftyDisplay);
        } else {
            try {
                if (this.nifty != null) {
                    this.viewPort.removeProcessor((SceneProcessor)this.niftyDisplay);
                    this.nifty.exit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        try {
            if (this.nifty != null) {
                this.viewPort.removeProcessor((SceneProcessor)this.niftyDisplay);
                this.nifty.exit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanup();
    }

    public static void main(String[] args) {
        new SimpleApplication(){

            public void simpleInitApp() {
                this.flyCam.setDragToRotate(true);
                Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
                mat.setFloat("Shininess", 5.0f);
                mat.setBoolean("UseMaterialColors", true);
                mat.setBoolean("UseAlpha", true);
                mat.setColor("Ambient", ColorRGBA.White.mult(0.8f));
                mat.setColor("Diffuse", new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
                mat.setColor("Specular", ColorRGBA.White);
                mat.setBoolean("HighQuality", true);
                mat.setReceivesShadows(true);
                mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
                Box m = new Box(Vector3f.ZERO, 2.0f, 2.0f, 2.0f);
                Geometry geo = new Geometry("Object", (Mesh)m);
                geo.setMaterial(mat);
                this.rootNode.attachChild((Spatial)geo);
                this.rootNode.addLight((Light)new AmbientLight());
                this.inputManager.setCursorVisible(true);
                this.stateManager.attach(new AerialUIState(null, null));
            }
        }.start();
    }
}

