/*
 * Decompiled with CFR 0.152.
 */
package ga.view.appstate;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.input.InputManager;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.system.Timer;

public class GUIState
extends AbstractAppState {
    protected Camera cam;
    protected ViewPort viewPort;
    protected InputManager inputManager;
    protected AssetManager assetManager;
    protected AppStateManager stateManager;
    protected RenderManager renderManager;
    protected Timer timer;

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.viewPort != null) {
            if (enabled) {
                if (!this.renderManager.getPostViews().contains(this.viewPort)) {
                    this.viewPort = this.renderManager.createPostView("Gui", this.cam);
                    this.viewPort.setClearFlags(false, false, false);
                }
            } else {
                while (this.viewPort.getProcessors().size() > 0) {
                    SceneProcessor proc = (SceneProcessor)this.viewPort.getProcessors().get(0);
                    this.viewPort.removeProcessor(proc);
                }
                this.renderManager.removeMainView(this.viewPort);
            }
        }
    }

    public void finalCleanUp() {
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.inputManager = app.getInputManager();
        this.assetManager = app.getAssetManager();
        this.stateManager = stateManager;
        this.timer = app.getContext().getTimer();
        this.renderManager = app.getRenderManager();
        this.cam = new Camera(app.getContext().getSettings().getWidth(), app.getContext().getSettings().getHeight());
        this.cam.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 0.1f, 20.0f);
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 10.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        this.viewPort = this.renderManager.createPostView("Gui", this.cam);
        this.viewPort.setClearFlags(false, false, false);
    }

    public Camera getCamera() {
        return this.cam;
    }
}

