/*
 * Decompiled with CFR 0.152.
 */
package ga.view.appstate.menu;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.font.Rectangle;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import ga.view.appstate.SceneState;
import ga.view.appstate.menu.MenuListener;
import ga.view.config.GASettings;
import ga.view.config.ViewSettings;
import ga.view.interfaces.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class MenuState
extends SceneState {
    private static final Logger LOGGER = Logger.getLogger(MenuState.class.getName());
    private MenuMouseListener doubleClickListener;
    private final MenuListener listener;
    private final List<MenuNode> menuNodes = new ArrayList<MenuNode>();
    private final ViewSettings viewSettings;

    public MenuState(MenuListener listener, ViewSettings viewSettings) {
        this.listener = listener;
        this.viewSettings = viewSettings;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.cam.setLocation(new Vector3f(0.0f, 4.5f, 0.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        float frustumSize = 2.0f;
        float aspect = (float)this.cam.getWidth() / (float)this.cam.getHeight();
        this.inputManager.addMapping("choose", new Trigger[]{new MouseButtonTrigger(0)});
        this.doubleClickListener = new MenuMouseListener();
        this.inputManager.addListener((InputListener)this.doubleClickListener, new String[]{"choose"});
        float x = 2.0f;
        float z = 1.0f;
        for (GASettings gaSetting : this.viewSettings) {
            MenuNode node = new MenuNode(gaSetting);
            node.setOrgLocation(new Vector3f(x, 0.0f, z));
            this.menuNodes.add(node);
            this.rootNode.attachChild((Spatial)node);
            if (!((x -= 2.0f) < -2.0f)) continue;
            x = 2.0f;
            z = -1.0f;
        }
    }

    private CollisionResults findPick(Node node) {
        Vector3f origin = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        node.collideWith((Collidable)ray, results);
        return results;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.doubleClickListener != null) {
            this.doubleClickListener.setEnabled(enabled);
        }
    }

    private class MenuMouseListener
    extends MouseListener {
        private MenuMouseListener() {
        }

        @Override
        public void onAction(String name, boolean keyPressed, boolean isDoubleClick, float tpf) {
            if (!keyPressed) {
                CollisionResults results = MenuState.this.findPick(MenuState.this.rootNode);
                MenuNode selectedNode = null;
                CollisionResult r = results.getClosestCollision();
                if (r != null && r.getGeometry() != null && r.getGeometry().getParent() != null && r.getGeometry().getParent() instanceof MenuNode) {
                    selectedNode = (MenuNode)r.getGeometry().getParent();
                }
                Iterator i$ = MenuState.this.menuNodes.iterator();
                while (i$.hasNext()) {
                    MenuNode node;
                    node.setSelected((node = (MenuNode)((Object)i$.next())) == selectedNode);
                }
            }
        }
    }

    private class MenuNode
    extends Node {
        private Vector3f targetLocation;
        private Vector3f orgLocation;
        private boolean selected;
        private final GASettings gaSetting;
        private final String name;
        private final BitmapText text;

        public MenuNode(GASettings gaSetting) {
            this.gaSetting = gaSetting;
            this.name = gaSetting.get("name", "name");
            this.setName(this.name + " node");
            Material whitemat = new Material(MenuState.this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            whitemat.setColor("Color", ColorRGBA.White);
            float boxSizeX = 0.8f;
            float boxSizeY = 0.6f;
            float borderSize = 0.05f;
            Material mat = new Material(MenuState.this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setTexture("ColorMap", MenuState.this.assetManager.loadTexture(gaSetting.get("iconImage", "")));
            Geometry geo = new Geometry("Menu node", (Mesh)new Box(0.6f, 0.01f, 0.8f));
            geo.setMaterial(mat);
            geo.setShadowMode(RenderQueue.ShadowMode.Off);
            Box box = new Box(0.65000004f, 0.0f, 0.85f);
            Geometry outterBox = new Geometry(this.name + " outter box", (Mesh)box);
            outterBox.setMaterial(whitemat);
            this.attachChild((Spatial)outterBox);
            this.attachChild((Spatial)geo);
            BitmapFont font = MenuState.this.assetManager.loadFont("Interface/Fonts/Default.fnt");
            this.text = new BitmapText(font, false);
            this.text.setName(this.name + " text");
            this.text.setSize(0.1f);
            this.text.setText(this.name);
            this.text.setCullHint(Spatial.CullHint.Never);
            this.text.setBox(new Rectangle(-1.0f, 0.0f, 2.0f, this.text.getLineHeight()));
            this.text.setAlignment(BitmapFont.Align.Center);
            this.text.setLocalTranslation(0.65000004f, 0.0f, 0.0f);
            this.rotate(0.0f, 1.5707964f, 0.0f);
            this.attachChild((Spatial)this.text);
            this.text.rotate(4.712389f, 1.5707964f, 0.0f);
        }

        public void setOrgLocation(Vector3f orgLocation) {
            this.orgLocation = orgLocation;
            this.setLocalTranslation(orgLocation);
        }

        public void updateLogicalState(float tpf) {
            Vector3f loc;
            float distance;
            super.updateLogicalState(tpf);
            if (this.targetLocation != null && (distance = this.targetLocation.distance(loc = this.getLocalTranslation())) > 0.05f) {
                float maxMoveStep = Math.min(distance, tpf * 3.0f);
                Vector3f dir = this.targetLocation.subtract(loc).normalize().mult(maxMoveStep);
                this.setLocalTranslation(loc.add(dir));
            }
        }

        public void setSelected(boolean select) {
            if (select != this.selected) {
                this.selected = select;
                LOGGER.info((Object)((Object)this) + " is selected: " + select);
                this.targetLocation = select ? this.orgLocation.mult(0.9f).add(0.0f, 0.5f, 0.0f) : this.orgLocation;
            } else if (this.selected) {
                MenuState.this.doubleClickListener.setEnabled(false);
                MenuState.this.listener.modelSelected(this.name);
                this.targetLocation = this.orgLocation;
                this.selected = false;
            }
        }
    }
}

