/*
 * Decompiled with CFR 0.152.
 */
package ga.view.appstate.roomplanner;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import ga.view.appstate.SceneState;
import ga.view.config.ViewSettings;
import ga.view.interfaces.MouseListener;
import java.util.logging.Logger;
import org.lwjgl.input.Mouse;

@Deprecated
public class RoomPlanner
extends SceneState {
    private static final Logger LOGGER = Logger.getLogger(RoomPlanner.class.getName());
    private final ViewSettings viewSettings;
    private MenuMouseListener doubleClickListener;
    private Node testNode;
    private Node plane;

    @Deprecated
    public RoomPlanner(ViewSettings viewSettings) {
        this.viewSettings = viewSettings;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.inputManager.setCursorVisible(false);
        Mouse.setGrabbed((boolean)false);
        this.viewPort.setBackgroundColor(ColorRGBA.White);
        this.cam.setLocation(new Vector3f(0.0f, 4.5f, 0.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        this.cam.setParallelProjection(true);
        this.inputManager.addMapping("mousemove", new Trigger[]{new MouseButtonTrigger(0)});
        this.doubleClickListener = new MenuMouseListener();
        this.inputManager.addListener((InputListener)this.doubleClickListener, new String[]{"mousemove"});
        this.testNode = new Node("TestNode");
        Geometry geo = new Geometry("TEST", (Mesh)new Box(0.1f, 0.1f, 0.1f));
        Material lineMaterial = this.assetManager.loadMaterial("Common/Materials/RedColor.j3m");
        geo.setMaterial(lineMaterial);
        this.testNode.attachChild((Spatial)geo);
        this.rootNode.attachChild((Spatial)this.testNode);
        this.plane = new Node("PlaneNode");
        geo = new Geometry("PLANE", (Mesh)new Box(100.0f, 0.0f, 100.0f));
        Material planeMaterial = this.assetManager.loadMaterial("Common/Materials/WhiteColor.j3m");
        geo.setMaterial(planeMaterial);
        this.plane.attachChild((Spatial)geo);
        this.rootNode.attachChild((Spatial)this.plane);
    }

    private CollisionResults findPick(Node node) {
        Vector3f origin = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        node.collideWith((Collidable)ray, results);
        return results;
    }

    public void stateDetached(AppStateManager stateManager) {
        super.stateDetached(stateManager);
        this.doubleClickListener.setEnabled(false);
    }

    public void stateAttached(AppStateManager stateManager) {
        super.stateAttached(stateManager);
        if (this.doubleClickListener != null) {
            this.doubleClickListener.setEnabled(true);
        }
    }

    @Override
    public void update(float tpf) {
        this.doubleClickListener.update(tpf);
        super.update(tpf);
    }

    private class MenuMouseListener
    extends MouseListener {
        private Vector3f lastLoc;

        private MenuMouseListener() {
        }

        @Override
        public void onAction(String name, boolean keyPressed, boolean isDoubleClick, float tpf) {
            if (!keyPressed) {
                CollisionResults results = RoomPlanner.this.findPick(RoomPlanner.this.rootNode);
                float x = ((RoomPlanner)RoomPlanner.this).inputManager.getCursorPosition().x;
                float y = ((RoomPlanner)RoomPlanner.this).inputManager.getCursorPosition().y;
                Vector3f origin = RoomPlanner.this.cam.getWorldCoordinates(RoomPlanner.this.inputManager.getCursorPosition(), 0.0f);
                System.err.println("mouse (" + x + "," + y + ")");
                System.err.println(origin);
            }
        }

        public void update(float tpf) {
            CollisionResults results = RoomPlanner.this.findPick(RoomPlanner.this.plane);
            CollisionResult r = results.getClosestCollision();
            Vector3f origin = r.getContactPoint();
            if (!origin.equals((Object)this.lastLoc)) {
                this.lastLoc = origin;
                System.err.println(origin);
                RoomPlanner.this.testNode.setLocalTranslation(this.lastLoc);
            }
        }
    }
}

