/*
 * Decompiled with CFR 0.152.
 */
package ga.view.billard;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import ga.core.algorithm.interactive.ISIGA;
import ga.core.algorithm.util.RandomSingleton;
import ga.core.evaluation.EvaluationListener;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IAgeIndividual;
import ga.core.individual.IIndividual;
import ga.core.individual.IIndividualFactory;
import ga.view.appstate.SceneState;
import ga.view.appstate.menu.IMenuListenerParent;
import ga.view.appstate.menu.MenuListener;
import ga.view.billard.nodes.BillardObjectNode;
import ga.view.factory.EffectsFactory;
import ga.view.interfaces.IPhenotypeGenerator;
import ga.view.interfaces.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BillardEvaluationState<T extends IAgeIndividual<T>>
extends SceneState
implements IInteractiveFitnessEvaluator<T>,
IMenuListenerParent {
    private static final Logger LOGGER = Logger.getLogger(BillardEvaluationState.class.getSimpleName());
    private Node objectsNode;
    private final BulletAppState bulletAppState;
    private ClickListener dragListener;
    private final float scale = 1.5f;
    private final float sceneHeight = 7.5f;
    private float sceneWidth;
    private final float wallHeight = 3.0f;
    private final float wallThickness = 0.1f;
    private ISIGA<T> algorithm;
    private final IPhenotypeGenerator<T, Geometry> phenotypeGenerator;
    private final IIndividualFactory<T> factory;
    private MenuListener menuListener;
    private final List<EvaluationListener<T>> listeners = new ArrayList<EvaluationListener<T>>();
    private final Map<T, BillardObjectNode<T>> nodeMap = new HashMap<T, BillardObjectNode<T>>();
    private boolean paused;
    private boolean useCentering;
    private boolean debug;

    public BillardEvaluationState(IIndividualFactory<T> factory, IPhenotypeGenerator<T, Geometry> phenotypeGenerator) {
        this.factory = factory;
        this.phenotypeGenerator = phenotypeGenerator;
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.phenotypeGenerator.setAssetManager(this.assetManager);
        AppSettings settings = app.getContext().getSettings();
        float aspectRatio = (float)settings.getWidth() / (float)settings.getHeight();
        this.sceneWidth = 7.5f * aspectRatio;
        stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().setAccuracy(0.003f);
        this.objectsNode = new Node("Panels");
        this.rootNode.attachChild((Spatial)this.objectsNode);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(0.0f, -1.0f, 0.0f));
        this.rootNode.addLight((Light)dl);
        this.rootNode.addLight((Light)new AmbientLight());
        this.initCam();
        this.initTable();
        this.initObjects();
        this.dragListener = new ClickListener();
        this.inputManager.addMapping("drag", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.dragListener, new String[]{"drag"});
        this.inputManager.addMapping("paused", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)new PausedListener(), new String[]{"paused"});
        this.inputManager.addMapping("debug", new Trigger[]{new KeyTrigger(32)});
        this.inputManager.addListener((InputListener)new DebugListener(), new String[]{"debug"});
        this.inputManager.addMapping("centering", new Trigger[]{new KeyTrigger(46)});
        this.inputManager.addListener((InputListener)new CenteringListener(), new String[]{"centering"});
        EffectsFactory.addShadowProcessor(this.assetManager, settings, this.viewPort, new Vector3f(0.0f, 1.0f, 0.1f));
        EffectsFactory.addLightScatteringProcessor(this.assetManager, this.inputManager, settings, this.viewPort, Vector3f.ZERO);
        EffectsFactory.addSSAOProcessor(this.assetManager, this.inputManager, settings, this.viewPort);
    }

    @Override
    public void cleanup() {
        this.stateManager.detach((AppState)this.bulletAppState);
        super.cleanup();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.bulletAppState.setEnabled(enabled);
        if (this.dragListener != null) {
            this.dragListener.setEnabled(enabled);
        }
        if (this.viewPort != null) {
            if (enabled) {
                if (!this.renderManager.getMainViews().contains(this.viewPort)) {
                    this.viewPort = this.renderManager.createMainView("Scene", this.cam);
                    this.viewPort.setClearFlags(true, true, true);
                    this.viewPort.attachScene((Spatial)this.rootNode);
                }
            } else {
                this.renderManager.removeMainView(this.viewPort);
            }
        }
    }

    @Override
    public void update(float tpf) {
        Iterator it = this.objectsNode.getChildren().iterator();
        while (it.hasNext()) {
            Spatial s = (Spatial)it.next();
            if (!(s instanceof BillardObjectNode) || !((BillardObjectNode)s).mustRemove()) continue;
            it.remove();
        }
        super.update(this.paused ? 0.0f : tpf);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        this.bulletAppState.setEnabled(!paused);
    }

    public void setAlgorithm(ISIGA<T> siga) {
        this.algorithm = siga;
    }

    public ISIGA<T> getAlgorithm() {
        return this.algorithm;
    }

    private void initCam() {
        this.cam.setLocation(new Vector3f(0.0f, 19.5f, 0.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Z.negate());
        this.cam.setFrustumFar(100.0f);
    }

    private void initTable() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 0.1f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setBoolean("UseAlpha", false);
        mat.setColor("Ambient", ColorRGBA.Black);
        mat.setColor("Diffuse", ColorRGBA.LightGray);
        mat.setColor("Specular", ColorRGBA.Black);
        Material planeMat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        planeMat.setFloat("Shininess", 0.0f);
        planeMat.setBoolean("UseMaterialColors", true);
        planeMat.setBoolean("UseAlpha", false);
        planeMat.setColor("Ambient", ColorRGBA.Black);
        planeMat.setColor("Diffuse", ColorRGBA.LightGray);
        planeMat.setColor("Specular", ColorRGBA.Black);
        Vector3f halfExtends = new Vector3f(this.sceneWidth, 3.0f, 0.1f);
        Geometry geo = new Geometry("upperbox", (Mesh)new Box(halfExtends.x, halfExtends.y, halfExtends.z));
        geo.setMaterial(mat);
        geo.setLocalTranslation(0.0f, 0.0f, -7.5f);
        RigidBodyControl control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(halfExtends.clone()), 0.0f);
        geo.addControl((Control)control);
        this.rootNode.attachChild((Spatial)geo);
        this.getPhysicsSpace().add((Object)control);
        geo = new Geometry("lowerbox", (Mesh)new Box(halfExtends.x, halfExtends.y, halfExtends.z));
        geo.setLocalTranslation(0.0f, 0.0f, 7.5f);
        geo.setMaterial(mat);
        control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(halfExtends), 0.0f);
        geo.addControl((Control)control);
        this.rootNode.attachChild((Spatial)geo);
        this.getPhysicsSpace().add((Object)control);
        halfExtends = new Vector3f(0.1f, 3.0f, 7.5f);
        geo = new Geometry("leftbox", (Mesh)new Box(halfExtends.x, halfExtends.y, halfExtends.z));
        geo.setLocalTranslation(this.sceneWidth, 0.0f, 0.0f);
        geo.setMaterial(mat);
        control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(halfExtends), 0.0f);
        geo.addControl((Control)control);
        this.rootNode.attachChild((Spatial)geo);
        this.getPhysicsSpace().add((Object)control);
        geo = new Geometry("rightbox", (Mesh)new Box(halfExtends.x, halfExtends.y, halfExtends.z));
        geo.setLocalTranslation(-this.sceneWidth, 0.0f, 0.0f);
        geo.setMaterial(mat);
        control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(halfExtends), 0.0f);
        geo.addControl((Control)control);
        this.rootNode.attachChild((Spatial)geo);
        this.getPhysicsSpace().add((Object)control);
        halfExtends = new Vector3f(this.sceneWidth, 0.1f, 7.5f);
        geo = new Geometry("plane", (Mesh)new Box(halfExtends.x, halfExtends.y, halfExtends.z));
        geo.setMaterial(planeMat);
        control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(halfExtends), 0.0f);
        geo.addControl((Control)control);
        geo.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)geo);
        this.getPhysicsSpace().add((Object)control);
        Node n = new Node("upper plane node");
        n.setLocalTranslation(0.0f, 2.6999998f, 0.0f);
        control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(halfExtends), 0.0f);
        n.addControl((Control)control);
        this.rootNode.attachChild((Spatial)n);
        this.getPhysicsSpace().add((Object)control);
    }

    private void initObjects() {
        int count = 0;
        for (float x = -this.sceneWidth * 0.7f; x < this.sceneWidth - 1.0f; x += 3.75f) {
            for (float y = -5.25f; y < 7.5f; y += 3.75f) {
                ++count;
                this.addRandomObject(x, y);
            }
        }
        for (IAgeIndividual soi : this.algorithm.getPopulation()) {
            soi.setMaxAge(count);
        }
    }

    private void addRandomObject(float x, float z) {
        IAgeIndividual newInd = (IAgeIndividual)this.factory.newIndividual(null);
        Geometry geo = this.phenotypeGenerator.createPhenotype(newInd);
        BillardObjectNode<IAgeIndividual> newNode = new BillardObjectNode<IAgeIndividual>(this.assetManager, geo, newInd);
        newNode.setLocalTranslation(x, 2.0f, z);
        this.algorithm.getPopulation().addIndividual((IIndividual)newInd);
        this.objectsNode.attachChild(newNode);
        this.getPhysicsSpace().add(newNode);
        this.nodeMap.put(newInd, newNode);
    }

    private CollisionResults findPick(Node node) {
        node.updateGeometricState();
        Vector3f origin = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        node.collideWith((Collidable)ray, results);
        return results;
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void fireNewIndividualRequested() {
        for (EvaluationListener<T> l : this.listeners) {
            l.newIndividualRequested();
        }
    }

    public void fireIndividualEvaluated(T individual) {
        for (EvaluationListener<T> l : this.listeners) {
            l.individualEvaluated(individual);
        }
    }

    public void addEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void evaluate(T individual) {
    }

    @Override
    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    private class CenteringListener
    implements ActionListener {
        private CenteringListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                BillardEvaluationState.this.useCentering = !BillardEvaluationState.this.useCentering;
                LOGGER.log(Level.INFO, "use centering: " + BillardEvaluationState.this.useCentering);
            }
        }
    }

    private class PausedListener
    implements ActionListener {
        private PausedListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                BillardEvaluationState.this.setPaused(!BillardEvaluationState.this.paused);
                LOGGER.log(Level.INFO, "paused: " + BillardEvaluationState.this.paused);
            }
        }
    }

    private class DebugListener
    implements ActionListener {
        private DebugListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                BillardEvaluationState.this.debug = !BillardEvaluationState.this.debug;
                LOGGER.log(Level.INFO, "debug enabled: " + BillardEvaluationState.this.debug);
            }
        }
    }

    private class ClickListener
    extends MouseListener {
        private ClickListener() {
        }

        @Override
        public void onAction(String name, boolean keyPressed, boolean isDoubleClick, float tpf) {
            if (keyPressed) {
                if (BillardEvaluationState.this.paused) {
                    BillardEvaluationState.this.setPaused(false);
                } else {
                    CollisionResult closest;
                    Node n;
                    CollisionResults results = BillardEvaluationState.this.findPick(BillardEvaluationState.this.objectsNode);
                    if (results.size() > 0 && (n = (closest = results.getClosestCollision()).getGeometry().getParent()) instanceof BillardObjectNode) {
                        int i;
                        BillardObjectNode node2;
                        BillardObjectNode node1 = (BillardObjectNode)n;
                        LOGGER.info("Objects count: " + BillardEvaluationState.this.objectsNode.getChildren().size());
                        do {
                            i = RandomSingleton.getRandom().nextInt(BillardEvaluationState.this.objectsNode.getChildren().size());
                        } while ((node2 = (BillardObjectNode)BillardEvaluationState.this.objectsNode.getChild(i)) == n);
                        Object ind1 = node1.getIndividual();
                        Object ind2 = node2.getIndividual();
                        IAgeIndividual newInd = (IAgeIndividual)BillardEvaluationState.this.algorithm.getCrossoverOp().crossover(ind1, ind2, BillardEvaluationState.this.algorithm.getContext()).get(RandomSingleton.getRandom().nextInt(2));
                        newInd = (IAgeIndividual)BillardEvaluationState.this.algorithm.getMutationOp().mutate((IIndividual)newInd, BillardEvaluationState.this.algorithm.getContext());
                        Geometry geo = (Geometry)BillardEvaluationState.this.phenotypeGenerator.createPhenotype(newInd);
                        BillardObjectNode<IAgeIndividual> newNode = new BillardObjectNode<IAgeIndividual>(BillardEvaluationState.this.assetManager, geo, newInd);
                        Vector3f loc = BillardEvaluationState.this.useCentering ? node1.getLocalTranslation().add(node2.getLocalTranslation()).mult(0.5f) : node1.getLocalTranslation().add(node1.getLocalTranslation().negate().normalize());
                        newNode.setLocalTranslation(loc);
                        node1.doSelect();
                        node2.doSelect();
                        BillardEvaluationState.this.getPhysicsSpace().add(newNode);
                        BillardEvaluationState.this.objectsNode.attachChild(newNode);
                        BillardEvaluationState.this.algorithm.getPopulation().addIndividual((IIndividual)newInd);
                        BillardEvaluationState.this.nodeMap.put(newInd, newNode);
                        newNode.doFadeIn();
                        int maxAge = BillardEvaluationState.this.algorithm.getPopulation().size();
                        Iterator it = BillardEvaluationState.this.algorithm.getPopulation().iterator();
                        while (it.hasNext()) {
                            IAgeIndividual soi = (IAgeIndividual)it.next();
                            soi.setMaxAge(maxAge);
                            soi.incAge();
                            BillardObjectNode son = (BillardObjectNode)((Object)BillardEvaluationState.this.nodeMap.get(soi));
                            son.updateSizeByAge();
                            if (!soi.isOld()) continue;
                            it.remove();
                            BillardEvaluationState.this.nodeMap.remove(soi);
                            BillardEvaluationState.this.getPhysicsSpace().remove((Object)son);
                            son.doFadeOut();
                        }
                        if (BillardEvaluationState.this.debug) {
                            BillardEvaluationState.this.setPaused(true);
                        }
                    }
                }
            }
        }
    }
}

