/*
 * Decompiled with CFR 0.152.
 */
package ga.view.billard.nodes;

import com.jme3.asset.AssetManager;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import ga.core.individual.IAgeIndividual;
import ga.view.factory.SceneFactory;

public class BillardObjectNode<T extends IAgeIndividual<T>>
extends Node {
    private final T individual;
    private final Geometry geometry;
    private float colorVal;
    private float relSize = 1.0f;
    private float alpha = 1.0f;
    private boolean fadeOut;
    private boolean fadeIn;
    private final RigidBodyControl control;

    public BillardObjectNode(AssetManager assetManager, Geometry s, T individual) {
        this.geometry = s;
        this.individual = individual;
        this.setShadowMode(RenderQueue.ShadowMode.Cast);
        Vector3f translation = this.geometry.getLocalTranslation();
        this.geometry.setLocalTranslation(Vector3f.ZERO);
        this.attachChild((Spatial)this.geometry);
        this.setLocalTranslation(translation);
        this.control = new RigidBodyControl(SceneFactory.getCollisionShape(this.geometry), 10.0f);
        this.addControl((Control)this.control);
        this.control.setDamping(0.5f, 0.5f);
        this.control.setFriction(0.1f);
        this.control.setSleepingThresholds(3.0f, 3.0f);
        this.control.setRestitution(0.001f);
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.colorVal > 0.0f) {
            this.colorVal -= tpf * 1.0f;
            this.colorVal = Math.min(1.0f, this.colorVal);
            this.geometry.getMaterial().setColor("Ambient", new ColorRGBA(this.colorVal, this.colorVal, this.colorVal, 1.0f));
        }
        if (this.fadeOut && this.relSize > 0.0f) {
            ColorRGBA col = (ColorRGBA)this.geometry.getMaterial().getParam("Diffuse").getValue();
            this.geometry.getMaterial().setColor("Diffuse", col.set(col.r, col.b, col.b, this.alpha));
            this.alpha -= tpf * 2.0f;
            this.alpha = Math.max(0.0f, this.alpha);
            this.geometry.setLocalScale(this.geometry.getLocalScale().mult(this.relSize));
            this.relSize -= tpf * 0.2f;
        } else if (this.fadeIn && this.alpha < 1.0f) {
            this.alpha += tpf * 2.0f;
            this.alpha = Math.min(1.0f, this.alpha);
            ColorRGBA col = (ColorRGBA)this.geometry.getMaterial().getParam("Diffuse").getValue();
            this.geometry.getMaterial().setColor("Diffuse", col.set(col.r, col.b, col.b, this.alpha));
        }
    }

    protected void setParent(Node parent) {
        super.setParent(parent);
        this.control.setPhysicsLocation(this.getLocalTranslation());
    }

    public void doSelect() {
        this.colorVal = 1.0f;
    }

    public void doFadeOut() {
        this.fadeOut = true;
    }

    public void doFadeIn() {
        this.fadeIn = true;
        this.alpha = 0.1f;
    }

    public void updateSizeByAge() {
        float newScale = 1.0f - 0.5f * this.individual.getAgeNormalized();
        this.geometry.setLocalScale(newScale);
        this.control.getCollisionShape().setScale(this.geometry.getWorldTransform().getScale());
    }

    public boolean mustRemove() {
        return this.relSize < 0.0f;
    }

    public T getIndividual() {
        return this.individual;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.individual.toString();
    }
}

