/*
 * Decompiled with CFR 0.152.
 */
package ga.view.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSettings {
    private final Map<String, Object> values = new HashMap<String, Object>();

    public Object put(String id, Object o) {
        return this.values.put(id, o);
    }

    public int getInt(String id, int dfault) {
        try {
            return (Integer)this.values.get(id);
        }
        catch (Exception e) {
            return dfault;
        }
    }

    protected void clear() {
        this.values.clear();
    }

    public Float getFloat(String id, float dfault) {
        try {
            return (Float)this.values.get(id);
        }
        catch (Exception e) {
            return Float.valueOf(dfault);
        }
    }

    public String getString(String id, String dfault) {
        try {
            return (String)this.values.get(id);
        }
        catch (Exception e) {
            return dfault;
        }
    }

    public Boolean getBoolean(String id, Boolean dfault) {
        try {
            return (Boolean)this.values.get(id);
        }
        catch (Exception e) {
            return dfault;
        }
    }

    public <T> T get(String id, T dfault) {
        try {
            return (T)this.values.get(id);
        }
        catch (Exception e) {
            return dfault;
        }
    }

    public <T> T get(String id) {
        return this.get(id, null);
    }

    protected Object createSimple(String type, String value) {
        Object o = null;
        if ("string".equals(type)) {
            o = value;
        } else if ("int".equals(type)) {
            o = Integer.valueOf(value);
        } else if ("long".equals(type)) {
            o = Long.valueOf(value);
        } else if ("float".equals(type)) {
            o = Float.valueOf(value);
        } else if ("double".equals(type)) {
            o = Double.valueOf(value);
        } else if ("boolean".equals(type)) {
            o = Boolean.valueOf(value);
        }
        if (o == null) {
            throw new RuntimeException("Datatype unknown: " + type);
        }
        return o;
    }

    protected Object createObject(Class<?> clss, Class<?>[] parameterClasses, Object[] parameters) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> c = this.getConstructor(clss, parameterClasses);
        return c.newInstance(parameters);
    }

    protected Constructor<?> getConstructor(Class<?> clss, Class<?>[] parameterClasses) throws NoSuchMethodException {
        if (parameterClasses.length == 0) {
            return clss.getConstructor(new Class[0]);
        }
        for (Constructor<?> c : clss.getConstructors()) {
            Class<?> type;
            Class<?>[] parameterClasses2 = c.getParameterTypes();
            if (parameterClasses.length != parameterClasses2.length) continue;
            for (int i = 0; i < c.getParameterTypes().length && parameterClasses2[i].isAssignableFrom(type = parameterClasses2[i]); ++i) {
            }
            return c;
        }
        return null;
    }

    protected Object createObject(String className, Class<?>[] parameterClasses, Object ... parameters) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clss = Class.forName(className);
        Object o = this.createObject(clss, parameterClasses, parameters);
        if (o == null) {
            throw new RuntimeException("Class unknown: " + className);
        }
        return o;
    }

    protected void putUnique(String id, Object o) {
        Object old = this.values.put(id, o);
        if (old != null) {
            throw new RuntimeException("Value " + id + " was already set to " + old + " overriding with " + o);
        }
    }

    public String toString() {
        return this.values.toString();
    }
}

