/*
 * Decompiled with CFR 0.152.
 */
package ga.view.config;

import ga.core.validation.IValidationRule;
import ga.core.validation.IValidator;
import ga.core.validation.RuleValidator;
import ga.view.config.AbstractSettings;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class GASettings
extends AbstractSettings {
    public static final String PRE_EVALUATION_STATE = "preEvaluationState";
    public static final String POST_EVALUATION_STATE = "postEvaluationState";
    public static final String EVALUATOR = "evaluator";
    private static final Logger LOGGER = Logger.getLogger(GASettings.class.getName());
    private Element element;
    private boolean hasRun;

    public GASettings(Element element) {
        this.parse(element);
    }

    public void setHasRun(boolean hasRun) {
        this.hasRun = hasRun;
    }

    public boolean hasRun() {
        return this.hasRun;
    }

    public void reset() {
        this.clear();
        this.parse(this.element);
        this.hasRun = false;
    }

    public void parse(Element element) {
        IValidator v;
        Element e;
        this.element = element;
        Element valuesE = element.getChild("values", element.getNamespace());
        if (valuesE != null) {
            for (Element sValue : valuesE.getChildren("simpleValue", element.getNamespace())) {
                this.parseSimple(sValue);
            }
            for (Element oValue : valuesE.getChildren("objectValue", element.getNamespace())) {
                this.parseObject(oValue);
            }
        }
        if ((e = element.getChild("phenotypeGenerator", element.getNamespace())) != null) {
            this.parseObject(e, "phenotypeGenerator");
        }
        if ((e = element.getChild("individualFactory", element.getNamespace())) != null) {
            this.parseObject(e, "individualFactory");
        }
        if ((e = element.getChild(EVALUATOR, element.getNamespace())) != null) {
            this.parseObject(e, EVALUATOR);
        }
        if ((e = element.getChild("population", element.getNamespace())) != null) {
            this.parseObject(e, "population");
        }
        if ((e = element.getChild("selector", element.getNamespace())) != null) {
            this.parseObject(e, "selector");
        }
        if ((e = element.getChild("validator", element.getNamespace())) != null && (v = (IValidator)this.parseObject(e, "validator")) != null && v instanceof RuleValidator) {
            Iterator it = e.getChildren("rule", element.getNamespace()).iterator();
            int i = 1;
            while (it.hasNext()) {
                Element sValue = (Element)it.next();
                IValidationRule r = (IValidationRule)this.parseObject(sValue, "rule" + i);
                if (r == null) continue;
                ((RuleValidator)v).addRule(r);
                ++i;
            }
        }
        if ((e = element.getChild("mutationOp", element.getNamespace())) != null) {
            this.parseObject(e, "mutationOp");
        }
        if ((e = element.getChild("crossoverOp", element.getNamespace())) != null) {
            this.parseObject(e, "crossoverOp");
        }
        if ((e = element.getChild("ga", element.getNamespace())) != null) {
            this.parseObject(e, "ga");
        }
        if ((e = element.getChild(PRE_EVALUATION_STATE, element.getNamespace())) != null) {
            this.parseObject(e, PRE_EVALUATION_STATE);
        }
        if ((e = element.getChild(POST_EVALUATION_STATE, element.getNamespace())) != null) {
            this.parseObject(e, POST_EVALUATION_STATE);
        }
    }

    private void parseSimple(Element sValue) {
        String id = sValue.getAttributeValue("id");
        String type = sValue.getAttributeValue("type");
        String value = sValue.getAttributeValue("value");
        Object o = this.createSimple(type, value);
        this.putUnique(id, o);
    }

    private Object parseObject(Element cValue) {
        String id = cValue.getAttributeValue("id");
        return this.parseObject(cValue, id);
    }

    private Object parseObject(Element cValue, String id) {
        Object o;
        String id2;
        int index;
        int numParameters = cValue.getChildren("simpleParameter", cValue.getNamespace()).size() + cValue.getChildren("objectParameter", cValue.getNamespace()).size();
        Object[] parameters = new Object[numParameters];
        Class[] parameterClasses = new Class[numParameters];
        for (Element sValue : cValue.getChildren("simpleParameter", cValue.getNamespace())) {
            index = Integer.valueOf(sValue.getAttributeValue("index"));
            id2 = sValue.getAttributeValue("id");
            o = this.get(id2);
            parameters[index] = o;
            parameterClasses[index] = o.getClass();
        }
        for (Element sValue : cValue.getChildren("objectParameter", cValue.getNamespace())) {
            index = Integer.valueOf(sValue.getAttributeValue("index"));
            id2 = sValue.getAttributeValue("id");
            o = this.get(id2);
            parameters[index] = o;
            parameterClasses[index] = o.getClass();
        }
        String clss = cValue.getAttributeValue("class");
        try {
            Object o2 = this.createObject(clss, parameterClasses, parameters);
            this.putUnique(id, o2);
            return o2;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to parse object of class " + clss, e);
            return null;
        }
    }
}

