/*
 * Decompiled with CFR 0.152.
 */
package ga.view.config;

import com.jme3.system.AppSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public final class SettingsDialog2
extends JDialog {
    public static final int NO_SELECTION = 0;
    public static final int APPROVE_SELECTION = 1;
    public static final int CANCEL_SELECTION = 2;
    private static final Logger LOGGER = Logger.getLogger(SettingsDialog2.class.getName());
    private static final long serialVersionUID = 1L;
    private final AppSettings source;
    private final URL imageFile;
    private final DisplayMode[] modes;
    private final String[] windowedResolutions = new String[]{"320 x 240", "640 x 480", "800 x 600", "1024 x 768", "1152 x 864", "1280 x 720"};
    private JCheckBox vsyncBox;
    private JCheckBox fullscreenBox;
    private JCheckBox shadowsBox;
    private JCheckBox ssaoBox;
    private JCheckBox lightScatteringBox;
    private JCheckBox hqMaterialBox;
    private JCheckBox showStatisticsBox;
    private JCheckBox showCursorBox;
    private JComboBox displayResCombo;
    private JComboBox colorDepthCombo;
    private JComboBox displayFreqCombo;
    private JComboBox antialiasCombo;
    private JLabel icon;
    private int selection;
    private SelectionListener selectionListener;
    private String fileToSave;

    public SettingsDialog2(AppSettings source, String imageFile, boolean loadSettings) {
        this(source, SettingsDialog2.getURL(imageFile), loadSettings);
    }

    public void setFileToSave(String fileToSave) {
        this.fileToSave = fileToSave;
    }

    public SettingsDialog2(AppSettings source, URL imageFile, boolean loadSettings) {
        if (source == null) {
            throw new NullPointerException("Settings source cannot be null");
        }
        this.source = source;
        this.imageFile = imageFile;
        this.setModal(true);
        AppSettings registrySettings = new AppSettings(true);
        String appTitle = source.getTitle() != null ? source.getTitle() : registrySettings.getTitle();
        try {
            registrySettings.load(appTitle);
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.WARNING, "Failed to load settings", ex);
        }
        if (loadSettings) {
            source.copyFrom(registrySettings);
        } else if (!registrySettings.isEmpty()) {
            source.mergeFrom(registrySettings);
        }
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.modes = device.getDisplayModes();
        Arrays.sort(this.modes, new DisplayModeSorter());
        this.createUI();
    }

    public void setSelectionListener(SelectionListener sl) {
        this.selectionListener = sl;
    }

    public int getUserSelection() {
        return this.selection;
    }

    private void setUserSelection(int selection) {
        this.selection = selection;
        this.selectionListener.onSelection(selection);
    }

    public void setImage(String image) {
        try {
            URL file = new URL("file:" + image);
            this.setImage(file);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setImage(URL image) {
        this.icon.setIcon(new ImageIcon(image));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void showDialog() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.toFront();
    }

    private void createUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LOGGER.warning("Could not set native look and feel.");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SettingsDialog2.this.setUserSelection(2);
                SettingsDialog2.this.dispose();
            }
        });
        if (this.source.getIcons() != null) {
            this.safeSetIconImages(Arrays.asList((BufferedImage[])this.source.getIcons()));
        }
        this.setTitle("Select Display Settings");
        JPanel mainPanel = new JPanel();
        JPanel centerPanel = new JPanel();
        JPanel optionsPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        this.icon = new JLabel(this.imageFile != null ? new ImageIcon(this.imageFile) : null);
        mainPanel.setLayout(new BorderLayout());
        centerPanel.setLayout(new BorderLayout());
        KeyAdapter aListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (SettingsDialog2.this.verifyAndSaveCurrentSelection()) {
                        SettingsDialog2.this.setUserSelection(1);
                        SettingsDialog2.this.dispose();
                    }
                } else if (e.getKeyCode() == 27) {
                    SettingsDialog2.this.setUserSelection(2);
                    SettingsDialog2.this.dispose();
                }
            }
        };
        this.displayResCombo = this.setUpResolutionChooser();
        this.displayResCombo.addKeyListener(aListener);
        this.colorDepthCombo = new JComboBox();
        this.colorDepthCombo.addKeyListener(aListener);
        this.displayFreqCombo = new JComboBox();
        this.displayFreqCombo.addKeyListener(aListener);
        this.antialiasCombo = new JComboBox();
        this.antialiasCombo.addKeyListener(aListener);
        this.fullscreenBox = new JCheckBox("Use Fullscreen");
        this.fullscreenBox.setSelected(this.source.isFullscreen());
        this.fullscreenBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog2.this.updateResolutionChoices();
            }
        });
        this.vsyncBox = new JCheckBox("Use VSync");
        this.vsyncBox.setSelected(this.source.isVSync());
        this.shadowsBox = new JCheckBox("Use Shadows");
        this.shadowsBox.setSelected(this.source.getBoolean("UseShadows"));
        this.ssaoBox = new JCheckBox("Use SSAO (Experimental)");
        this.ssaoBox.setSelected(this.source.getBoolean("UseSSAO"));
        this.lightScatteringBox = new JCheckBox("Use Light Scattering (Experimental)");
        this.lightScatteringBox.setSelected(this.source.getBoolean("UseLightScattering"));
        this.hqMaterialBox = new JCheckBox("Use HQ Material (Experimental)");
        this.hqMaterialBox.setSelected(this.source.getBoolean("UseHQMaterial"));
        this.showStatisticsBox = new JCheckBox("Show Graphics Statistics");
        this.showStatisticsBox.setSelected(this.source.getBoolean("ShowStatistics"));
        this.showCursorBox = new JCheckBox("Show Cursor (Can Be Disabled For Touchscreens)");
        this.showCursorBox.setSelected(this.source.getBoolean("ShowCursor"));
        this.updateResolutionChoices();
        this.updateAntialiasChoices();
        this.displayResCombo.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        this.colorDepthCombo.setSelectedItem(this.source.getBitsPerPixel() + " bpp");
        optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 0, 5);
        constraints.anchor = 17;
        optionsPanel.add((Component)this.displayResCombo, constraints);
        ++constraints.gridx;
        optionsPanel.add((Component)this.colorDepthCombo, constraints);
        ++constraints.gridx;
        optionsPanel.add((Component)this.displayFreqCombo, constraints);
        ++constraints.gridx;
        optionsPanel.add((Component)this.antialiasCombo, constraints);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        ++constraints.gridy;
        optionsPanel.add((Component)this.fullscreenBox, constraints);
        constraints.gridx += 2;
        optionsPanel.add((Component)this.vsyncBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        optionsPanel.add((Component)this.shadowsBox, constraints);
        constraints.gridx += 2;
        optionsPanel.add((Component)this.ssaoBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        optionsPanel.add((Component)this.lightScatteringBox, constraints);
        constraints.gridx += 2;
        optionsPanel.add((Component)this.hqMaterialBox, constraints);
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        ++constraints.gridy;
        optionsPanel.add((Component)this.showStatisticsBox, constraints);
        constraints.gridx += 2;
        optionsPanel.add((Component)this.showCursorBox, constraints);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsDialog2.this.verifyAndSaveCurrentSelection()) {
                    SettingsDialog2.this.setUserSelection(1);
                    SettingsDialog2.this.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog2.this.setUserSelection(2);
                SettingsDialog2.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        if (this.icon != null) {
            centerPanel.add((Component)this.icon, "North");
        }
        centerPanel.add((Component)optionsPanel, "South");
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    private void safeSetIconImages(List<? extends Image> icons) {
        try {
            Window owner = this.getOwner();
            if (owner != null) {
                Method setIconImages = owner.getClass().getMethod("setIconImages", List.class);
                setIconImages.invoke((Object)owner, icons);
                return;
            }
            Method setIconImages = this.getClass().getMethod("setIconImages", List.class);
            setIconImages.invoke((Object)this, icons);
        }
        catch (Exception e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyAndSaveCurrentSelection() {
        String display = (String)this.displayResCombo.getSelectedItem();
        boolean fullscreen = this.fullscreenBox.isSelected();
        boolean vsync = this.vsyncBox.isSelected();
        int width = Integer.parseInt(display.substring(0, display.indexOf(" x ")));
        display = display.substring(display.indexOf(" x ") + 3);
        int height = Integer.parseInt(display);
        String depthString = (String)this.colorDepthCombo.getSelectedItem();
        int depth = -1;
        depth = depthString.equals("???") ? 0 : Integer.parseInt(depthString.substring(0, depthString.indexOf(32)));
        String freqString = (String)this.displayFreqCombo.getSelectedItem();
        int freq = -1;
        if (fullscreen) {
            freq = freqString.equals("???") ? 0 : Integer.parseInt(freqString.substring(0, freqString.indexOf(32)));
        }
        String aaString = (String)this.antialiasCombo.getSelectedItem();
        int multisample = -1;
        multisample = aaString.equals("Disabled") ? 0 : Integer.parseInt(aaString.substring(0, aaString.indexOf(120)));
        String renderer = "LWJGL-OpenGL2";
        boolean valid = false;
        if (!fullscreen) {
            valid = true;
        } else {
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            valid = device.isFullScreenSupported();
        }
        if (valid) {
            this.source.setWidth(width);
            this.source.setHeight(height);
            this.source.setBitsPerPixel(depth);
            this.source.setFrequency(freq);
            this.source.setFullscreen(fullscreen);
            this.source.setVSync(vsync);
            this.source.setSamples(multisample);
            this.source.putBoolean("UseShadows", this.shadowsBox.isSelected());
            this.source.putBoolean("UseSSAO", this.ssaoBox.isSelected());
            this.source.putBoolean("UseLightScattering", this.lightScatteringBox.isSelected());
            this.source.putBoolean("UseHQMaterial", this.hqMaterialBox.isSelected());
            this.source.putBoolean("ShowStatistics", this.showStatisticsBox.isSelected());
            this.source.putBoolean("ShowCursor", this.showCursorBox.isSelected());
            if (this.fileToSave != null) {
                OutputStream os = null;
                try {
                    File path = new File(".");
                    System.out.println(path.getCanonicalPath());
                    File f = new File(path, this.fileToSave);
                    System.out.println(f.getCanonicalPath());
                    f.getParentFile().mkdirs();
                    os = new FileOutputStream(f);
                    this.source.save(os);
                    LOGGER.log(Level.INFO, f.getCanonicalPath() + " saved");
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to save setting changes", ex);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            SettingsDialog2.showError(this, "Your monitor claims to not support the display mode you've selected.\nThe combination of bit depth and refresh rate is not supported.");
        }
        return valid;
    }

    private JComboBox setUpResolutionChooser() {
        String[] res = SettingsDialog2.getResolutions(this.modes);
        JComboBox<String> resolutionBox = new JComboBox<String>(res);
        resolutionBox.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        resolutionBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog2.this.updateDisplayChoices();
            }
        });
        return resolutionBox;
    }

    private JComboBox setUpRendererChooser() {
        String[] modes = new String[]{"NULL", "JOGL-OpenGL1", "LWJGL-OpenGL2", "LWJGL-OpenGL3", "LWJGL-OpenGL3.1"};
        JComboBox<String> nameBox = new JComboBox<String>(modes);
        nameBox.setSelectedItem(this.source.getRenderer());
        return nameBox;
    }

    private void updateDisplayChoices() {
        String displayFreq;
        if (!this.fullscreenBox.isSelected()) {
            return;
        }
        String resolution = (String)this.displayResCombo.getSelectedItem();
        String colorDepth = (String)this.colorDepthCombo.getSelectedItem();
        if (colorDepth == null) {
            colorDepth = this.source.getBitsPerPixel() + " bpp";
        }
        if ((displayFreq = (String)this.displayFreqCombo.getSelectedItem()) == null) {
            displayFreq = this.source.getFrequency() + " Hz";
        }
        String[] depths = SettingsDialog2.getDepths(resolution, this.modes);
        this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(depths));
        this.colorDepthCombo.setSelectedItem(colorDepth);
        String[] freqs = SettingsDialog2.getFrequencies(resolution, this.modes);
        this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(freqs));
        this.displayFreqCombo.setSelectedItem(displayFreq);
    }

    private void updateResolutionChoices() {
        if (!this.fullscreenBox.isSelected()) {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(this.windowedResolutions));
            this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"24 bpp", "16 bpp"}));
            this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"n/a"}));
            this.displayFreqCombo.setEnabled(false);
        } else {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(SettingsDialog2.getResolutions(this.modes)));
            this.displayFreqCombo.setEnabled(true);
            this.updateDisplayChoices();
        }
    }

    private void updateAntialiasChoices() {
        String[] choices = new String[]{"Disabled", "2x", "4x", "6x", "8x", "16x"};
        this.antialiasCombo.setModel(new DefaultComboBoxModel<String>(choices));
        this.antialiasCombo.setSelectedItem(choices[Math.min(this.source.getSamples() / 2, 5)]);
    }

    private static URL getURL(String file) {
        URL url = null;
        try {
            url = new URL("file:" + file);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    private static void showError(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Error", 0);
    }

    private static String[] getResolutions(DisplayMode[] modes) {
        ArrayList<String> resolutions = new ArrayList<String>(modes.length);
        for (int i = 0; i < modes.length; ++i) {
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            if (resolutions.contains(res)) continue;
            resolutions.add(res);
        }
        String[] res = new String[resolutions.size()];
        resolutions.toArray(res);
        return res;
    }

    private static String[] getDepths(String resolution, DisplayMode[] modes) {
        ArrayList<String> depths = new ArrayList<String>(4);
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getBitDepth() < 16 && modes[i].getBitDepth() > 0) continue;
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            String depth = modes[i].getBitDepth() + " bpp";
            if (!res.equals(resolution) || depths.contains(depth)) continue;
            depths.add(depth);
        }
        if (depths.size() == 1 && depths.contains("-1 bpp")) {
            depths.clear();
            depths.add("24 bpp");
        }
        String[] res = new String[depths.size()];
        depths.toArray(res);
        return res;
    }

    private static String[] getFrequencies(String resolution, DisplayMode[] modes) {
        ArrayList<String> freqs = new ArrayList<String>(4);
        for (int i = 0; i < modes.length; ++i) {
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            String freq = modes[i].getRefreshRate() == 0 ? "???" : modes[i].getRefreshRate() + " Hz";
            if (!res.equals(resolution) || freqs.contains(freq)) continue;
            freqs.add(freq);
        }
        String[] res = new String[freqs.size()];
        freqs.toArray(res);
        return res;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final AppSettings settings = new AppSettings(true);
                final SettingsDialog2 sd = new SettingsDialog2(settings, (URL)null, false);
                sd.setFileToSave("config/test.properties");
                SelectionListener sl = new SelectionListener(){

                    @Override
                    public void onSelection(int selection) {
                        sd.dispose();
                        if (selection == 1) {
                            SettingsDialog2 sd2 = new SettingsDialog2(settings, (URL)null, false);
                            sd2.setSelectionListener(this);
                            sd2.showDialog();
                        }
                    }
                };
                sd.setSelectionListener(sl);
                sd.showDialog();
            }
        });
    }

    private class DisplayModeSorter
    implements Comparator<DisplayMode> {
        private DisplayModeSorter() {
        }

        @Override
        public int compare(DisplayMode a, DisplayMode b) {
            if (a.getWidth() != b.getWidth()) {
                return a.getWidth() > b.getWidth() ? 1 : -1;
            }
            if (a.getHeight() != b.getHeight()) {
                return a.getHeight() > b.getHeight() ? 1 : -1;
            }
            if (a.getBitDepth() != b.getBitDepth()) {
                return a.getBitDepth() > b.getBitDepth() ? 1 : -1;
            }
            if (a.getRefreshRate() != b.getRefreshRate()) {
                return a.getRefreshRate() > b.getRefreshRate() ? 1 : -1;
            }
            return 0;
        }
    }

    public static interface SelectionListener {
        public void onSelection(int var1);
    }
}

