/*
 * Decompiled with CFR 0.152.
 */
package ga.view.config;

import ga.view.config.GASettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ViewSettings
extends ArrayList<GASettings> {
    private static final Logger LOGGER = Logger.getLogger(ViewSettings.class.getName());

    public ViewSettings() {
    }

    public ViewSettings(Element e) {
        this.parse(e);
    }

    public static ViewSettings buildFromXml(String filename) {
        return ViewSettings.buildFromXml(ViewSettings.class.getClassLoader().getResourceAsStream(filename));
    }

    public static ViewSettings buildFromXml(File file) {
        try {
            return ViewSettings.buildFromXml(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewSettings buildFromXml(InputStream is) {
        SAXBuilder builder = new SAXBuilder(false);
        try {
            Element e = builder.build(is).getRootElement();
            if (e == null) {
                throw new RuntimeException("Error parsing settings, application will not work");
            }
            ViewSettings viewSettings = new ViewSettings(e);
            return viewSettings;
        }
        catch (JDOMException e) {
            LOGGER.log(Level.SEVERE, "Failed to parse file", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to load file", e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    private void parse(Element e) {
        for (Element iga : e.getChildren("setting", e.getNamespace())) {
            this.add(new GASettings(iga));
        }
    }

    public GASettings get(String name) {
        for (GASettings setting : this) {
            if (!setting.get("name").equals(name)) continue;
            return setting;
        }
        return null;
    }

    public static void main(String[] args) {
        ViewSettings vs = ViewSettings.buildFromXml("example/SimpleObjectGA.xml");
        LOGGER.info(vs.toString());
    }
}

