/*
 * Decompiled with CFR 0.152.
 */
package ga.view.examples.simple;

import ga.core.algorithm.util.RandomSingleton;
import ga.core.individual.IAgeIndividual;
import ga.core.individual.IFitness;
import ga.core.validation.GAContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public final class SimpleObjectIndividual
implements IAgeIndividual<SimpleObjectIndividual>,
IFitness {
    public static final int TYPE_COUNT = 4;
    public static final int PARAMETERS_COLOR = 3;
    public static final int PARAMETER_TYPE = 3;
    public static final int NUM_PARAMETERS = 4;
    private static final Random RND = RandomSingleton.getRandom();
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private final long id;
    private int maxAge;
    private final List<Number> genotype = new ArrayList<Number>();
    private int age;
    private double fitness = Double.MIN_VALUE;

    public SimpleObjectIndividual() {
        this.id = ID_GENERATOR.incrementAndGet();
        this.initRandomly();
    }

    public long getId() {
        return this.id;
    }

    public void setContext(GAContext context) {
    }

    public GAContext getContext() {
        return null;
    }

    public void initRandomly() {
        this.fitness = Double.MIN_VALUE;
        this.genotype.clear();
        for (int i = 0; i < 3; ++i) {
            this.genotype.add(Float.valueOf(RND.nextFloat()));
        }
        this.genotype.add(RND.nextInt(4));
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public double getFitness() {
        return this.fitness;
    }

    public List<Number> getGenotype() {
        return this.genotype;
    }

    public String toString() {
        String s = "ColorRGBA(" + this.genotype.get(0) + "," + this.genotype.get(1) + "," + this.genotype.get(2) + " Type: " + this.genotype.get(3);
        s = this.isEvaluated() ? s + " Fitness: " + this.fitness : s + " unevaluated";
        return s;
    }

    public int getAge() {
        return this.age;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public float getAgeNormalized() {
        return (float)this.age / (float)this.maxAge;
    }

    public boolean isOld() {
        return this.age > this.maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void incAge() {
        ++this.age;
    }

    public boolean isEvaluated() {
        return this.fitness != Double.MIN_VALUE;
    }

    public SimpleObjectIndividual clone() {
        SimpleObjectIndividual ind = new SimpleObjectIndividual();
        ind.genotype.addAll(this.genotype);
        ind.setMaxAge(this.maxAge);
        return ind;
    }
}

