/*
 * Decompiled with CFR 0.152.
 */
package ga.view.examples.simple;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Sphere;
import com.jme3.scene.shape.Torus;
import ga.view.examples.simple.SimpleObjectIndividual;
import ga.view.interfaces.IPhenotypeGenerator;

public class SimpleObjectPhenotypeGenerator
implements IPhenotypeGenerator<SimpleObjectIndividual, Geometry> {
    private AssetManager assetManager;

    @Override
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Override
    public Geometry createPhenotype(SimpleObjectIndividual individual) {
        Sphere m;
        float r = ((Float)individual.getGenotype().get(0)).floatValue();
        float g = ((Float)individual.getGenotype().get(1)).floatValue();
        float b = ((Float)individual.getGenotype().get(2)).floatValue();
        int type = (Integer)individual.getGenotype().get(3);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 1.5f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setBoolean("UseAlpha", true);
        mat.setColor("Ambient", ColorRGBA.White.mult(0.1f));
        mat.setColor("Diffuse", new ColorRGBA(r, g, b, 1.0f));
        mat.setColor("Specular", ColorRGBA.Gray);
        mat.setBoolean("HighQuality", true);
        mat.setReceivesShadows(true);
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        switch (type) {
            case 0: {
                m = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                m = new Sphere(20, 20, 1.0f);
                break;
            }
            case 2: {
                m = new Cylinder(20, 20, 1.0f, 2.0f, true);
                break;
            }
            case 3: {
                m = new Torus(20, 20, 0.3f, 0.7f);
                break;
            }
            default: {
                m = null;
            }
        }
        Geometry geo = new Geometry("Object", (Mesh)m);
        geo.setMaterial(mat);
        geo.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        geo.setQueueBucket(RenderQueue.Bucket.Transparent);
        geo.setLocalTranslation(new Vector3f(0.0f, 1.0f, 0.0f));
        return geo;
    }
}

