/*
 * Decompiled with CFR 0.152.
 */
package ga.view.factory;

import com.jme3.asset.AssetManager;
import com.jme3.input.InputManager;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.LightScatteringFilter;
import com.jme3.post.ssao.SSAOFilter;
import com.jme3.renderer.ViewPort;
import com.jme3.shadow.PssmShadowRenderer;
import com.jme3.system.AppSettings;

public final class EffectsFactory {
    private EffectsFactory() {
    }

    public static void addShadowProcessor(AssetManager assetManager, AppSettings settings, ViewPort viewPort, Vector3f lightLoc) {
        boolean shadowsEnabled = settings.getBoolean("UseShadows");
        if (shadowsEnabled) {
            Vector3f shadowDir = lightLoc.negate().normalizeLocal();
            PssmShadowRenderer pssmRenderer = new PssmShadowRenderer(assetManager, 1024, 6);
            pssmRenderer.setDirection(shadowDir);
            pssmRenderer.setLambda(0.1f);
            pssmRenderer.setShadowIntensity(0.3f);
            pssmRenderer.setCompareMode(PssmShadowRenderer.CompareMode.Hardware);
            pssmRenderer.setFilterMode(PssmShadowRenderer.FilterMode.PCF8);
            viewPort.addProcessor((SceneProcessor)pssmRenderer);
        }
    }

    public static void addSSAOProcessor(AssetManager assetManager, InputManager inputManager, AppSettings settings, ViewPort viewPort) {
        boolean ssaoEnabled = settings.getBoolean("UseSSAO");
        if (ssaoEnabled) {
            FilterPostProcessor fpp = new FilterPostProcessor(assetManager);
            SSAOFilter ssaoFilter = new SSAOFilter(1.1f, 3.4f, 3.9f, 0.4f);
            fpp.addFilter((Filter)ssaoFilter);
            viewPort.addProcessor((SceneProcessor)fpp);
        }
    }

    public static void addLightScatteringProcessor(AssetManager assetManager, InputManager inputManager, AppSettings settings, ViewPort viewPort, Vector3f lightLoc) {
        boolean lightScatteringEnabled = settings.getBoolean("UseLightScattering");
        if (lightScatteringEnabled) {
            FilterPostProcessor fpp = new FilterPostProcessor(assetManager);
            LightScatteringFilter filter = new LightScatteringFilter(lightLoc);
            fpp.addFilter((Filter)filter);
            viewPort.addProcessor((SceneProcessor)fpp);
        }
    }
}

