/*
 * Decompiled with CFR 0.152.
 */
package ga.view.factory;

import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.CylinderCollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Sphere;
import com.jme3.scene.shape.Torus;

public final class SceneFactory {
    private SceneFactory() {
    }

    public static CollisionShape getCollisionShape(Geometry geometry) {
        SphereCollisionShape shape = null;
        if (geometry.getMesh() instanceof Box) {
            shape = new BoxCollisionShape(new Vector3f(((Box)geometry.getMesh()).xExtent, ((Box)geometry.getMesh()).yExtent, ((Box)geometry.getMesh()).zExtent));
        } else if (geometry.getMesh() instanceof Sphere) {
            shape = new SphereCollisionShape(((Sphere)geometry.getMesh()).radius);
        } else if (geometry.getMesh() instanceof Cylinder) {
            shape = new CylinderCollisionShape(new Vector3f(((Cylinder)geometry.getMesh()).getRadius(), ((Cylinder)geometry.getMesh()).getRadius(), ((Cylinder)geometry.getMesh()).getHeight() / 2.0f));
        } else if (geometry.getMesh() instanceof Torus) {
            CompoundCollisionShape comp = new CompoundCollisionShape();
            shape = new CylinderCollisionShape(new Vector3f(((Torus)geometry.getMesh()).getOuterRadius(), ((Torus)geometry.getMesh()).getOuterRadius(), ((Torus)geometry.getMesh()).getInnerRadius()));
            comp.addChildShape((CollisionShape)shape, Vector3f.ZERO);
            shape = new CylinderCollisionShape(new Vector3f(((Torus)geometry.getMesh()).getInnerRadius(), ((Torus)geometry.getMesh()).getOuterRadius() + ((Torus)geometry.getMesh()).getInnerRadius(), ((Torus)geometry.getMesh()).getInnerRadius() / 4.0f));
            comp.addChildShape((CollisionShape)shape, Vector3f.ZERO);
            shape = comp;
        }
        return shape;
    }
}

