/*
 * Decompiled with CFR 0.152.
 */
package ga.view.input;

import com.jme3.input.InputManager;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import ga.view.interfaces.MouseListener;
import ga.view.streaming.showroom.CameraSettings;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CamDragListener
extends MouseListener
implements AnalogListener {
    private static final Logger LOGGER = Logger.getLogger(CamDragListener.class.getName());
    private boolean canRotate;
    private final float zoomSpeed = 0.6f;
    private final float rotationSpeed = 0.8f;
    private float minVRotation = 0.2f;
    private float maxVRotation = 0.3f;
    private float minDistance = 1.0f;
    private float maxDistance;
    private Vector3f lookAt;
    private float distance;
    private float rotation;
    private float vRotation;
    private final Camera cam;
    private final InputManager inputManager;

    public CamDragListener(Camera cam, InputManager inputManager, CameraSettings camSettings) {
        this.cam = cam;
        this.inputManager = inputManager;
        this.init(camSettings);
        String[] inputs = new String[]{"toggleRotate", "Down", "Up", "mouseLeft", "mouseRight", "ZoomIn", "ZoomOut"};
        inputManager.addMapping("Down", new Trigger[]{new MouseAxisTrigger(1, true)});
        inputManager.addMapping("Up", new Trigger[]{new MouseAxisTrigger(1, false)});
        inputManager.addMapping("ZoomIn", new Trigger[]{new MouseAxisTrigger(2, true)});
        inputManager.addMapping("ZoomOut", new Trigger[]{new MouseAxisTrigger(2, false)});
        inputManager.addMapping("mouseLeft", new Trigger[]{new MouseAxisTrigger(0, true)});
        inputManager.addMapping("mouseRight", new Trigger[]{new MouseAxisTrigger(0, false)});
        inputManager.addMapping("toggleRotate", new Trigger[]{new MouseButtonTrigger(0)});
        inputManager.addMapping("doubleClick", new Trigger[]{new MouseButtonTrigger(0)});
        inputManager.addListener((InputListener)this, inputs);
    }

    public void init(CameraSettings camSettings) {
        this.minVRotation = camSettings.getMinVRotation();
        this.maxVRotation = camSettings.getMaxVRotation();
        this.minDistance = camSettings.getMinDistance();
        this.maxDistance = camSettings.getMaxDistance();
        this.lookAt = camSettings.getLookAtPoint();
        this.init();
    }

    public void init() {
        this.distance = this.cam.getLocation().distance(this.lookAt);
        this.vRotation = FastMath.asin((float)(this.cam.getLocation().y / this.distance));
        float hDistance = this.distance * FastMath.sin((float)(1.5707964f - this.vRotation));
        this.rotation = this.cam.getLocation().z >= 0.0f ? FastMath.acos((float)(this.cam.getLocation().x / hDistance)) : -FastMath.acos((float)(this.cam.getLocation().x / hDistance));
        this.updateCamera();
    }

    public void rotateCamera(float value) {
        this.rotation += value * 0.8f;
        this.updateCamera();
    }

    private void zoomCamera(float value) {
        this.distance += value * 0.6f;
        if (this.distance > this.maxDistance) {
            this.distance = this.maxDistance;
        }
        if (this.distance < this.minDistance) {
            this.distance = this.minDistance;
        }
        if (this.vRotation < this.minVRotation && this.distance > this.minDistance + 1.0f) {
            this.vRotation = this.minVRotation;
        }
        this.updateCamera();
    }

    public void vRotateCamera(float value) {
        this.vRotation += value * 0.8f;
        if (this.vRotation > this.maxVRotation) {
            this.vRotation = this.maxVRotation;
        }
        if (this.vRotation < this.minVRotation && this.distance > this.minDistance + 1.0f) {
            this.vRotation = this.minVRotation;
        }
        this.updateCamera();
    }

    protected void updateCamera() {
        float hDistance = this.distance * FastMath.sin((float)(1.5707964f - this.vRotation));
        Vector3f pos = new Vector3f(hDistance * FastMath.cos((float)this.rotation), this.distance * FastMath.sin((float)this.vRotation), hDistance * FastMath.sin((float)this.rotation));
        pos = pos.add(this.lookAt);
        this.cam.setLocation(pos);
        this.cam.lookAt(this.lookAt, Vector3f.UNIT_Y);
    }

    @Override
    public void onAction(String name, boolean keyPressed, boolean isDoubleClick, float tpf) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(name + " " + keyPressed + " " + isDoubleClick);
        }
        if (this.isEnabled() && "toggleRotate".equals(name)) {
            this.canRotate = keyPressed;
        }
    }

    public void onAnalog(String name, float value, float tpf) {
        if (this.isEnabled()) {
            if (this.canRotate) {
                if ("mouseLeft".equals(name)) {
                    this.rotateCamera(-value);
                } else if ("mouseRight".equals(name)) {
                    this.rotateCamera(value);
                } else if ("Up".equals(name)) {
                    this.vRotateCamera(value);
                } else if ("Down".equals(name)) {
                    this.vRotateCamera(-value);
                }
            }
            if ("ZoomIn".equals(name)) {
                this.zoomCamera(value);
            } else if ("ZoomOut".equals(name)) {
                this.zoomCamera(-value);
            }
        }
    }
}

