/*
 * Decompiled with CFR 0.152.
 */
package ga.view.processor;

import com.jme3.asset.AssetManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import ga.view.factory.EffectsFactory;
import java.util.logging.Logger;

public class OffscreenProcessor
implements SceneProcessor {
    private static final Logger LOGGER = Logger.getLogger(OffscreenProcessor.class.getName());
    private int renderWidth = 512;
    private int renderHeight = 512;
    private FrameBuffer offscreenBuffer;
    private Camera offscreenCam;
    private final Node offscreenScene;
    private ViewPort offscreenView;
    private final AssetManager assetManager;
    private RenderManager rm;
    private final AppSettings settings;
    private ViewPort guiViewPort;
    private Node guiNode;
    private BitmapText fpsText;
    private BitmapFont guiFont;
    private String text = "";
    private ColorRGBA backgroundColor = ColorRGBA.White;
    private Texture2D texture;
    private final Material material;
    private final String textureKey;

    public OffscreenProcessor(AssetManager assetManager, AppSettings settings, Node scene, Material material, String textureKey) {
        this.assetManager = assetManager;
        this.settings = settings;
        this.offscreenScene = scene;
        this.material = material;
        this.textureKey = textureKey;
        this.init();
    }

    private void init() {
        this.texture = new Texture2D(this.renderWidth, this.renderHeight, Image.Format.RGBA8);
        this.offscreenCam = new Camera(this.renderWidth, this.renderHeight);
    }

    public void setTextureSize(int width, int height) {
        this.renderWidth = width;
        this.renderHeight = height;
        this.init();
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.rm = rm;
        this.offscreenView = rm.createPreView("Offscreen View", this.offscreenCam);
        this.offscreenView.setClearFlags(true, true, true);
        this.offscreenView.setBackgroundColor(this.backgroundColor);
        this.offscreenBuffer = new FrameBuffer(this.renderWidth, this.renderHeight, 1);
        this.offscreenBuffer.setDepthBuffer(Image.Format.Depth);
        this.offscreenBuffer.setColorTexture(this.texture);
        this.offscreenView.setOutputFrameBuffer(this.offscreenBuffer);
        this.offscreenView.attachScene((Spatial)this.offscreenScene);
        this.material.setTexture(this.textureKey, (Texture)this.texture);
        this.material.setColor("Diffuse", this.backgroundColor);
        float aspect = (float)this.settings.getHeight() / (float)this.settings.getWidth();
        this.guiViewPort = rm.createPreView("Gui Offscreen", this.offscreenCam);
        this.guiViewPort.setClearFlags(false, false, false);
        this.guiNode = new Node("Gui Node");
        this.guiViewPort.attachScene((Spatial)this.guiNode);
        this.guiNode.setQueueBucket(RenderQueue.Bucket.Gui);
        this.guiNode.setCullHint(Spatial.CullHint.Never);
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        this.fpsText = new BitmapText(this.guiFont, false);
        this.fpsText.setSize(64.0f);
        this.fpsText.setLocalTranslation(2.0f, this.fpsText.getLineHeight() * 1.5f, 0.0f);
        this.fpsText.setLocalScale(aspect, 1.0f, 1.0f);
        this.fpsText.setText(this.text);
        this.fpsText.setColor(ColorRGBA.Red);
        this.guiNode.attachChild((Spatial)this.fpsText);
        this.guiViewPort.setOutputFrameBuffer(this.offscreenBuffer);
        this.material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        EffectsFactory.addShadowProcessor(this.assetManager, this.settings, this.offscreenView, new Vector3f(300.0f, 210.0f, 300.0f));
        EffectsFactory.addLightScatteringProcessor(this.assetManager, null, this.settings, this.offscreenView, new Vector3f(300.0f, 190.0f, 300.0f));
        EffectsFactory.addSSAOProcessor(this.assetManager, null, this.settings, this.offscreenView);
        this.offscreenScene.updateGeometricState();
    }

    public void setText(String text) {
        this.text = text;
        if (this.fpsText != null) {
            this.fpsText.setText(text);
        }
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public boolean isInitialized() {
        return this.rm != null;
    }

    public void preFrame(float tpf) {
        this.guiNode.updateLogicalState(tpf);
        this.guiNode.updateGeometricState();
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
    }

    public void cleanup() {
        try {
            this.rm.removePreView(this.offscreenView);
            this.rm.removePreView(this.guiViewPort);
        }
        catch (Throwable t) {
            LOGGER.warning(t.toString());
        }
    }

    public Camera getCamera() {
        return this.offscreenCam;
    }

    public Material getMaterial() {
        return this.material;
    }

    public ColorRGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(ColorRGBA backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (this.isInitialized()) {
            this.offscreenView.setBackgroundColor(backgroundColor);
            this.material.setColor("Diffuse", backgroundColor);
        }
    }
}

