/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.controls.InputListener;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.system.AppSettings;
import ga.core.individual.IIndividual;
import ga.view.appstate.SceneState;
import ga.view.factory.EffectsFactory;
import ga.view.input.CamDragListener;
import ga.view.interfaces.MouseListener;
import ga.view.streaming.nodes.PanelNode;
import ga.view.streaming.showroom.CameraSettings;

public class ShowRoomState<T extends IIndividual<T>>
extends SceneState {
    private final AppState stateToPause;
    private CamDragListener dragListener;
    private DoubleClickListener doubleClickListener;
    private PanelNode<T> panelNode;
    private AppSettings settings;
    private CameraSettings camSettings;

    public ShowRoomState(AppState stateToPause, CameraSettings camSettings) {
        this.stateToPause = stateToPause;
        this.camSettings = camSettings;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.settings = app.getContext().getSettings();
        this.viewPort.setBackgroundColor(ColorRGBA.White);
        this.dragListener = new CamDragListener(this.cam, this.inputManager, this.camSettings);
        this.dragListener.setEnabled(false);
        this.doubleClickListener = new DoubleClickListener();
        this.doubleClickListener.setEnabled(false);
        this.inputManager.addListener((InputListener)this.doubleClickListener, new String[]{"doubleClick"});
        this.camSettings.configureCamera(this.cam);
    }

    public void setCamSettings(CameraSettings camSettings) {
        this.camSettings = camSettings;
        camSettings.configureCamera(this.cam);
        this.dragListener.init(camSettings);
    }

    public void setPanelNode(PanelNode<T> panelNode) {
        this.panelNode = panelNode;
        Camera procCam = panelNode.getProcessor().getCamera();
        this.cam.setLocation(procCam.getLocation());
        this.cam.lookAt(this.camSettings.getLookAtPoint(), Vector3f.UNIT_Y);
        this.dragListener.init();
        this.setRootNode(panelNode.getShowRoom());
    }

    public void setRootNode(Node node) {
        this.rootNode = node;
        this.rootNode.setName("ShowRoom state RootNode");
        this.rootNode.updateGeometricState();
        this.setEnabled(true);
        EffectsFactory.addShadowProcessor(this.assetManager, this.settings, this.viewPort, new Vector3f(3.0f, 2.1f, 3.0f));
        EffectsFactory.addLightScatteringProcessor(this.assetManager, this.inputManager, this.settings, this.viewPort, new Vector3f(3.0f, 1.9f, 3.0f));
        EffectsFactory.addSSAOProcessor(this.assetManager, this.inputManager, this.settings, this.viewPort);
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dragListener != null) {
            this.dragListener.setEnabled(enabled);
        }
        if (this.doubleClickListener != null) {
            this.doubleClickListener.setEnabled(enabled);
        }
        if (this.viewPort != null) {
            this.viewPort.setEnabled(enabled);
            if (!enabled) {
                this.viewPort.clearScenes();
            }
        }
    }

    public void stateAttached(AppStateManager stateManager) {
        if (this.viewPort != null) {
            this.viewPort.setEnabled(true);
        }
    }

    public void stateDetached(AppStateManager stateManager) {
        this.dragListener.setEnabled(false);
        this.doubleClickListener.setEnabled(false);
        if (this.viewPort != null) {
            this.viewPort.clearScenes();
            this.viewPort.setEnabled(false);
        }
    }

    private class DoubleClickListener
    extends MouseListener {
        private DoubleClickListener() {
        }

        @Override
        public void onAction(String name, boolean keyPressed, boolean isDoubleClick, float tpf) {
            if (isDoubleClick && ShowRoomState.this.stateToPause != null) {
                ShowRoomState.this.setEnabled(false);
                ShowRoomState.this.stateToPause.setEnabled(true);
                Camera procCam = ShowRoomState.this.panelNode.getProcessor().getCamera();
                procCam.setLocation(ShowRoomState.this.cam.getLocation());
                procCam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
            }
        }
    }
}

