/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.Point2PointJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import ga.core.algorithm.interactive.ISIGA;
import ga.core.evaluation.EvaluationListener;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IIndividual;
import ga.view.appstate.SceneState;
import ga.view.appstate.menu.IMenuListenerParent;
import ga.view.appstate.menu.MenuListener;
import ga.view.interfaces.IPhenotypeGenerator;
import ga.view.interfaces.MouseListener;
import ga.view.streaming.ShowRoomState;
import ga.view.streaming.nodes.AnchorNode;
import ga.view.streaming.nodes.EvaluationNode;
import ga.view.streaming.nodes.PanelNode;
import ga.view.streaming.nodes.PanelNodeListener;
import ga.view.streaming.showroom.CameraSettings;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomFactory;
import ga.view.streaming.showroom.ShowRoomSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamingEvaluationState<T extends IIndividual<T>>
extends SceneState
implements IInteractiveFitnessEvaluator<T>,
IMenuListenerParent {
    public static final float SCENE_WIDTH = 9.0f;
    private static final float PANEL_SPACING = 4.0f;
    private static final Logger LOGGER = Logger.getLogger(StreamingEvaluationState.class.getName());
    private Geometry pointer;
    private boolean mouseDown;
    private RigidBodyControl pointerControl;
    private Node panelsNode;
    private final IPhenotypeGenerator<T, ? extends Spatial> phenotypeGenerator;
    private ShowRoomFactory showRoomFactory;
    private final ShowRoomSettings srSettings;
    private final BulletAppState bulletAppState;
    private ShowRoomState<T> showRoomState;
    private EvaluationNode lowerBox;
    private EvaluationNode upperBox;
    private final List<AnchorNode<T>> anchorNodes = new ArrayList<AnchorNode<T>>();
    private final List<EvaluationListener<T>> listeners = new ArrayList<EvaluationListener<T>>();
    private final DragListener dragListener = new DragListener();
    private CameraSettings camSettings;
    private MenuListener menuListener;
    private AppSettings settings;
    private float speed = 1.0f;
    private boolean enabled = true;
    private ISIGA<T> algorithm;
    private Application app;

    public StreamingEvaluationState(IPhenotypeGenerator<T, ? extends Spatial> phenotypeGenerator) {
        this.phenotypeGenerator = phenotypeGenerator;
        this.srSettings = new ShowRoomSettings();
        this.srSettings.put("type", (Object)ShowRoomSettings.ShowRoomType.BOX);
        this.srSettings.put("width", Float.valueOf(6.0f));
        this.srSettings.put("length", Float.valueOf(4.0f));
        this.srSettings.put("height", Float.valueOf(2.6f));
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
    }

    @Override
    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = app;
        this.phenotypeGenerator.setAssetManager(this.assetManager);
        this.settings = app.getContext().getSettings();
        this.showRoomFactory = new ShowRoomFactory(this.assetManager, this.settings, this.srSettings);
        ShowRoom showRoom = this.showRoomFactory.createShowRoom();
        this.camSettings = CameraSettings.getOrthographicSettings(showRoom, this.settings);
        this.showRoomState = new ShowRoomState((AppState)this, this.camSettings);
        this.algorithm.getContext().put("ValidationSpace", (Object)showRoom);
        this.algorithm.getContext().put("GenomeMinLength", (Object)1);
        this.algorithm.getContext().put("GenomeMaxLength", (Object)3);
        this.algorithm.init();
        stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().setAccuracy(0.005f);
        this.panelsNode = new Node("Panels");
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(Vector3f.UNIT_Y.negate());
        this.panelsNode.addLight((Light)dl);
        this.rootNode.addLight((Light)new AmbientLight());
        this.showRoomState.initialize(stateManager, app);
        this.showRoomState.setEnabled(false);
        this.rootNode.attachChild((Spatial)this.panelsNode);
        this.initCam();
        this.initTable();
        this.initPointer();
        this.inputManager.addMapping("drag", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.dragListener, new String[]{"drag"});
        this.inputManager.addMapping("switch view", new Trigger[]{new KeyTrigger(47)});
        this.inputManager.addListener((InputListener)new ViewSwitchListener(), new String[]{"switch view"});
    }

    @Override
    public void cleanup() {
        if (this.algorithm != null) {
            this.algorithm.exit();
        }
        if (this.showRoomState != null) {
            this.showRoomState.setEnabled(false);
            this.stateManager.detach(this.showRoomState);
        }
        try {
            this.stateManager.detach((AppState)this.bulletAppState);
        }
        catch (Exception e) {
            LOGGER.warning(e.toString());
        }
        super.cleanup();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.bulletAppState.setEnabled(enabled);
        this.dragListener.setEnabled(enabled);
        if (this.viewPort != null) {
            if (enabled) {
                if (!this.renderManager.getMainViews().contains(this.viewPort)) {
                    this.viewPort = this.renderManager.createMainView("Scene", this.cam);
                    this.viewPort.setClearFlags(true, true, true);
                    this.viewPort.attachScene((Spatial)this.rootNode);
                }
            } else {
                this.renderManager.removeMainView(this.viewPort);
            }
        }
    }

    @Override
    public void update(float tpf) {
        CollisionResults results;
        if (!this.isEnabled()) {
            return;
        }
        super.update(tpf);
        if (!this.mouseDown) {
            this.upperBox.setMouseOver(false);
            this.lowerBox.setMouseOver(false);
            if (this.timer.getTimeInSeconds() > 2.0f) {
                if (this.anchorNodes.size() < 5) {
                    this.fireNewIndividualRequested();
                }
                AnchorNode<T> anchorNode = this.anchorNodes.get(0);
                Vector3f trans = anchorNode.getLocalTranslation();
                trans.x += tpf * this.speed;
                anchorNode.setLocalTranslation(trans);
                for (int i = 1; i < this.anchorNodes.size(); ++i) {
                    anchorNode = this.anchorNodes.get(i);
                    trans = trans.add(-4.0f, 0.0f, 0.0f);
                    anchorNode.setLocalTranslation(trans);
                }
                anchorNode = this.anchorNodes.get(0);
                if (anchorNode.getLocalTranslation().x > 9.0f) {
                    this.removeAnchorNode(anchorNode);
                }
            }
        }
        if (this.mouseDown && (results = this.findPick(this.rootNode)).size() > 0) {
            Iterator it = results.iterator();
            boolean upperBoxFound = false;
            boolean lowerBoxFound = false;
            while (it.hasNext()) {
                CollisionResult r = (CollisionResult)it.next();
                if (r.getGeometry().getParent() == null || !(r.getGeometry().getParent() instanceof PanelNode)) continue;
                PanelNode n = (PanelNode)r.getGeometry().getParent();
                if (this.upperBox.isMouseOver() || this.lowerBox.isMouseOver()) {
                    n.setFadeToAlpha(0.6f);
                    break;
                }
                n.setFadeToAlpha(1.0f);
                break;
            }
            Vector3f origin = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.0f);
            LOGGER.info(String.valueOf(origin));
            if (origin.z <= -0.015f) {
                upperBoxFound = true;
            } else if (origin.z >= 0.015f) {
                lowerBoxFound = true;
            }
            if (upperBoxFound) {
                this.upperBox.setMouseOver(true);
            } else {
                this.upperBox.setMouseOver(false);
            }
            if (lowerBoxFound) {
                this.lowerBox.setMouseOver(true);
            } else {
                this.lowerBox.setMouseOver(false);
            }
            CollisionResult closest = results.getClosestCollision();
            Vector3f markPos = closest.getContactPoint().setY(3.0f);
            this.pointer.setLocalTranslation(markPos);
        }
        super.update(tpf);
    }

    private void initCam() {
        this.cam.setLocation(new Vector3f(0.0f, 10.0f, 0.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Z.negate());
        this.cam.setFrustumFar(50.0f);
    }

    private void initTable() {
        Geometry geo = new Geometry("upperbox", (Mesh)new Box(0.5f, 0.0f, 0.5f));
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", this.assetManager.loadTexture("ga/view/resource/plus.png"));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geo.setMaterial(mat);
        geo.setShadowMode(RenderQueue.ShadowMode.Off);
        geo.rotate(0.0f, 1.5707964f, 0.0f);
        geo.setLocalTranslation(0.0f, 0.4f, -3.0f);
        this.upperBox = new EvaluationNode("upperboxnode", geo);
        this.rootNode.attachChild((Spatial)this.upperBox);
        geo = new Geometry("lowerbox", (Mesh)new Box(0.5f, 0.0f, 0.5f));
        mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", this.assetManager.loadTexture("ga/view/resource/minus.png"));
        mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        geo.setMaterial(mat);
        geo.setShadowMode(RenderQueue.ShadowMode.Off);
        geo.rotate(0.0f, 1.5707964f, 0.0f);
        geo.setLocalTranslation(0.0f, 0.4f, 3.0f);
        this.lowerBox = new EvaluationNode("lowerboxnode", geo);
        this.rootNode.attachChild((Spatial)this.lowerBox);
    }

    private void initPointer() {
        Box b = new Box(0.1f, 0.0f, 0.1f);
        this.pointer = new Geometry("pointer", (Mesh)b);
        Material pointerMat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        pointerMat.setColor("Color", new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        pointerMat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        pointerMat.setTexture("ColorMap", this.assetManager.loadTexture("ga/view/resource/pointer.png"));
        pointerMat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        pointerMat.setTransparent(true);
        this.pointer.setMaterial(pointerMat);
        this.pointer.setShadowMode(RenderQueue.ShadowMode.Off);
        this.pointer.setName("Pointer Node");
        this.pointer.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.pointer.setCullHint(Spatial.CullHint.Always);
        this.pointerControl = new RigidBodyControl((CollisionShape)new BoxCollisionShape(new Vector3f(0.1f, 0.1f, 0.1f)), 5.0f);
        this.pointer.addControl((Control)this.pointerControl);
        this.pointerControl.setKinematic(true);
        this.pointerControl.setCollisionGroup(0);
        this.pointerControl.setCollideWithGroups(0);
    }

    private CollisionResults findPick(Node node) {
        Vector3f origin = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        node.collideWith((Collidable)ray, results);
        return results;
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void setAlgorithm(ISIGA<T> algorithm) {
        this.algorithm = algorithm;
    }

    public ISIGA<T> getAlgorithm() {
        return this.algorithm;
    }

    private void showInShowRoom(PanelNode<T> panelNode) {
        LOGGER.info("SHOW IN SHOWROOM");
        this.showRoomState.setPanelNode(panelNode);
        this.setEnabled(false);
        this.speed = 1.0f;
    }

    private void createPanel(T individual) {
        Spatial phenotype = this.phenotypeGenerator.createPhenotype(individual);
        float x = this.anchorNodes.size() == 0 ? -9.0f : this.anchorNodes.get((int)0).getLocalTranslation().x - 4.0f * (float)this.anchorNodes.size();
        ShowRoom showRoom = this.showRoomFactory.createShowRoom();
        showRoom.setPhenotype(phenotype);
        PanelNode<T> panelNode = new PanelNode<T>(this.assetManager, this.settings, showRoom, this.camSettings, individual);
        panelNode.setInfoStringType(PanelNode.InfoStringType.COSTS);
        this.viewPort.addProcessor((SceneProcessor)panelNode.getProcessor());
        panelNode.setPanelNodeListener(new PanelNodeListener<T>(){

            @Override
            public void panelReadyToDestroy(final PanelNode<T> panelNode) {
                StreamingEvaluationState.this.app.enqueue((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        StreamingEvaluationState.this.removeAnchorNode(panelNode.getAnchor());
                        return null;
                    }
                });
            }

            @Override
            public void panelInInspectPosition(PanelNode<T> panelNode) {
                StreamingEvaluationState.this.showInShowRoom(panelNode);
                panelNode.inspectDone();
            }
        });
        panelNode.setLocalTranslation(x, 0.0f, 0.0f);
        AnchorNode anchorNode = new AnchorNode(this.getPhysicsSpace());
        anchorNode.setLocalTranslation(x, 0.0f, 0.0f);
        this.rootNode.attachChild(anchorNode);
        this.getPhysicsSpace().add((Object)anchorNode.getControl());
        this.anchorNodes.add(anchorNode);
        this.panelsNode.attachChild(panelNode);
        this.getPhysicsSpace().add(panelNode);
        anchorNode.attachJoint(panelNode);
    }

    private void removeAnchorNode(AnchorNode<T> anchorNode) {
        PanelNode<T> panelNode = anchorNode.getAttachedNode();
        this.rootNode.detachChild(anchorNode);
        this.panelsNode.detachChild(panelNode);
        this.getPhysicsSpace().remove(anchorNode);
        this.getPhysicsSpace().remove(panelNode);
        anchorNode.detachJoint();
        this.viewPort.removeProcessor((SceneProcessor)panelNode.getProcessor());
        this.anchorNodes.remove(anchorNode);
    }

    private void removePanel(PanelNode<T> panelNode) {
        AnchorNode<T> anchorNode = panelNode.getAnchor();
        int index = this.anchorNodes.indexOf(anchorNode);
        if (this.anchorNodes.size() > 1 && index == 0) {
            this.anchorNodes.get(1).setLocalTranslation(anchorNode.getLocalTranslation());
        }
        this.rootNode.detachChild(anchorNode);
        this.getPhysicsSpace().remove(anchorNode);
        this.anchorNodes.remove(anchorNode);
        anchorNode.detachJoint();
        panelNode.getControl().setGravity(new Vector3f(0.0f, -90.0f, panelNode.getLocalTranslation().z * 20.0f));
        panelNode.setFadeToAlpha(0.0f);
    }

    public void fireNewIndividualRequested() {
        for (EvaluationListener<T> l : this.listeners) {
            l.newIndividualRequested();
        }
    }

    public void fireIndividualEvaluated(T individual) {
        for (EvaluationListener<T> l : this.listeners) {
            l.individualEvaluated(individual);
        }
    }

    public void addEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeEvaluationListener(EvaluationListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void evaluate(T individual) {
        this.createPanel(individual);
    }

    private class ViewSwitchListener
    implements ActionListener {
        private int i = 1;

        private ViewSwitchListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                int length = CameraSettings.Type.values().length;
                CameraSettings.Type type = CameraSettings.Type.values()[++this.i % length];
                StreamingEvaluationState.this.camSettings = CameraSettings.getSettings(type, StreamingEvaluationState.this.showRoomFactory.createShowRoom(), StreamingEvaluationState.this.settings);
                for (AnchorNode an : StreamingEvaluationState.this.anchorNodes) {
                    PanelNode pn = an.getAttachedNode();
                    if (pn == null) continue;
                    pn.setCameraSettings(StreamingEvaluationState.this.camSettings);
                }
                StreamingEvaluationState.this.showRoomState.setCamSettings(StreamingEvaluationState.this.camSettings);
                LOGGER.info("Camera is now " + (Object)((Object)type));
            }
        }
    }

    private class DragListener
    extends MouseListener {
        private Point2PointJoint mouseSliderJoint;
        private PanelNode<T> selectedPanelNode;

        private DragListener() {
        }

        @Override
        public void onAction(String name, boolean keyPressed, boolean isDoubleClick, float tpf) {
            LOGGER.info(name + " " + keyPressed + " " + isDoubleClick);
            if (keyPressed) {
                CollisionResults results = StreamingEvaluationState.this.findPick(StreamingEvaluationState.this.panelsNode);
                if (results.size() > 0) {
                    StreamingEvaluationState.this.mouseDown = true;
                    CollisionResult closest = results.getClosestCollision();
                    Node n = closest.getGeometry().getParent();
                    if (n != null && n instanceof PanelNode) {
                        this.selectedPanelNode = (PanelNode)n;
                        if (isDoubleClick) {
                            if (this.mouseSliderJoint != null) {
                                StreamingEvaluationState.this.getPhysicsSpace().remove((Object)this.mouseSliderJoint);
                                this.mouseSliderJoint.destroy();
                                this.mouseSliderJoint = null;
                            }
                            StreamingEvaluationState.this.dragListener.setEnabled(false);
                            this.selectedPanelNode.inspect();
                            StreamingEvaluationState.this.speed = 0.1f;
                        } else {
                            StreamingEvaluationState.this.getPhysicsSpace().add((Object)StreamingEvaluationState.this.pointerControl);
                            StreamingEvaluationState.this.rootNode.attachChild((Spatial)StreamingEvaluationState.this.pointer);
                            if (this.mouseSliderJoint == null) {
                                this.mouseSliderJoint = new Point2PointJoint((PhysicsRigidBody)StreamingEvaluationState.this.pointerControl, (PhysicsRigidBody)this.selectedPanelNode.getControl(), Vector3f.ZERO, Vector3f.ZERO);
                                this.mouseSliderJoint.setCollisionBetweenLinkedBodys(false);
                                this.mouseSliderJoint.setDamping(1.0f);
                                this.mouseSliderJoint.setImpulseClamp(150.0f);
                                this.mouseSliderJoint.setTau(3.0f);
                                StreamingEvaluationState.this.getPhysicsSpace().add((Object)this.mouseSliderJoint);
                            }
                        }
                    }
                }
            } else {
                StreamingEvaluationState.this.mouseDown = false;
                if (this.mouseSliderJoint != null) {
                    StreamingEvaluationState.this.getPhysicsSpace().remove((Object)this.mouseSliderJoint);
                    this.mouseSliderJoint.destroy();
                    this.mouseSliderJoint = null;
                }
                StreamingEvaluationState.this.getPhysicsSpace().remove((Object)StreamingEvaluationState.this.pointerControl);
                StreamingEvaluationState.this.rootNode.detachChild((Spatial)StreamingEvaluationState.this.pointer);
                try {
                    if (StreamingEvaluationState.this.findPick(StreamingEvaluationState.this.lowerBox).size() > 0) {
                        StreamingEvaluationState.this.removePanel(this.selectedPanelNode);
                        Object individual = this.selectedPanelNode.getIndividual();
                        if (individual != null) {
                            individual.setFitness(individual.getFitness() - 1.0);
                            StreamingEvaluationState.this.fireIndividualEvaluated(individual);
                        }
                    } else if (StreamingEvaluationState.this.findPick(StreamingEvaluationState.this.upperBox).size() > 0) {
                        StreamingEvaluationState.this.removePanel(this.selectedPanelNode);
                        Object individual = this.selectedPanelNode.getIndividual();
                        if (individual != null) {
                            individual.setFitness(individual.getFitness() + 1.0);
                            StreamingEvaluationState.this.fireIndividualEvaluated(individual);
                        }
                    } else if (this.selectedPanelNode != null) {
                        this.selectedPanelNode.setFadeToAlpha(1.0f);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "An error occured", e);
                }
                this.selectedPanelNode = null;
            }
        }
    }
}

