/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming.nodes;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.Point2PointJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.control.Control;
import ga.core.individual.IIndividual;
import ga.view.streaming.nodes.PanelNode;

public class AnchorNode<T extends IIndividual<T>>
extends Node {
    private final PhysicsSpace physicsSpace;
    private Point2PointJoint sliderJoint;
    private final RigidBodyControl control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(new Vector3f(0.5f, 0.4f, 0.5f)), 0.0f);
    private PanelNode<T> attachedNode;

    public AnchorNode(PhysicsSpace physicsSpace) {
        super("Anchor Node");
        this.addControl((Control)this.control);
        this.physicsSpace = physicsSpace;
        this.control.setKinematic(true);
        this.control.setCollisionGroup(0);
        this.control.setCollideWithGroups(0);
    }

    public void attachJoint(PanelNode<T> node) {
        this.attachedNode = node;
        this.attachedNode.setAnchor(this);
        this.sliderJoint = new Point2PointJoint((PhysicsRigidBody)node.getControl(), (PhysicsRigidBody)this.control, Vector3f.ZERO, new Vector3f(-0.5f, 0.0f, 0.0f));
        this.sliderJoint.setCollisionBetweenLinkedBodys(false);
        this.sliderJoint.setDamping(1.0f);
        this.sliderJoint.setImpulseClamp(5.0f);
        this.sliderJoint.setTau(0.1f);
        this.physicsSpace.add((Object)this.sliderJoint);
    }

    public RigidBodyControl getControl() {
        return this.control;
    }

    public void detachJoint() {
        if (this.sliderJoint != null) {
            this.physicsSpace.remove((Object)this.sliderJoint);
            this.sliderJoint.destroy();
            this.sliderJoint = null;
        }
    }

    protected void setParent(Node parent) {
        super.setParent(parent);
        this.control.setPhysicsLocation(this.getLocalTranslation());
    }

    public PanelNode<T> getAttachedNode() {
        return this.attachedNode;
    }
}

