/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming.nodes;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;

public class EvaluationNode
extends Node {
    private final Geometry geometry;
    private float scaleTo = 1.0f;
    private final float speed = 6.0f;
    private boolean mouseOver;
    private final float orgScaleX;

    public EvaluationNode(String name, Geometry geo) {
        super(name);
        this.geometry = geo;
        this.attachChild((Spatial)geo);
        this.scaleTo = this.orgScaleX = this.geometry.getLocalScale().x;
        this.setModelBound((BoundingVolume)new BoundingBox(Vector3f.ZERO, new Vector3f(1.0f, 1.0f, 1.0f)));
        this.updateModelBound();
        this.setQueueBucket(RenderQueue.Bucket.Transparent);
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.geometry.getLocalScale().x < this.scaleTo) {
            float scale = this.geometry.getLocalScale().x + 6.0f * tpf;
            if (scale > this.scaleTo) {
                scale = this.scaleTo;
            }
            this.geometry.setLocalScale(scale, scale, scale);
            this.geometry.updateGeometricState();
        } else if (this.geometry.getLocalScale().x > this.scaleTo) {
            float scale = this.geometry.getLocalScale().x - 6.0f * tpf;
            if (scale < this.scaleTo) {
                scale = this.scaleTo;
            }
            this.geometry.setLocalScale(scale, scale, scale);
            this.geometry.updateGeometricState();
        }
    }

    public void setMouseOver(boolean mouseOver) {
        this.mouseOver = mouseOver;
        this.scaleTo = mouseOver ? this.orgScaleX * 2.0f : this.orgScaleX;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }
}

