/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming.nodes;

import com.jme3.asset.AssetManager;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import ga.core.individual.ICostInfo;
import ga.core.individual.IDebugInfo;
import ga.core.individual.IIndividual;
import ga.view.processor.OffscreenProcessor;
import ga.view.streaming.nodes.AnchorNode;
import ga.view.streaming.nodes.PanelNodeListener;
import ga.view.streaming.showroom.CameraSettings;
import ga.view.streaming.showroom.ShowRoom;
import java.util.logging.Logger;

public class PanelNode<T extends IIndividual<T>>
extends Node {
    private static final Logger LOGGER = Logger.getLogger(PanelNode.class.getName());
    private static final Vector3f INSPECT_LOCATION = new Vector3f(0.0f, 7.3f, 0.0f);
    private AnchorNode<T> anchor;
    private final float x = 1.5f;
    private final float y = 0.0f;
    private final float z;
    private final Material mat;
    private float materialAlpha = -1.0f;
    private float fadeToAlpha = 1.0f;
    private final OffscreenProcessor processor;
    private final ShowRoom showRoom;
    private float fadeSpeed = 1.0f;
    private PanelNodeListener<T> listener;
    private boolean isInitFade;
    private Vector3f targetLocation;
    private Vector3f lastLocation;
    private Mode mode = Mode.NORMAL;
    private final T individual;
    private final RigidBodyControl control;
    private InfoStringType infoStringType = InfoStringType.NONE;

    public PanelNode(AssetManager assetManager, AppSettings settings, ShowRoom showRoom, CameraSettings camSettings, T individual) {
        super("Panel Node");
        this.showRoom = showRoom;
        float aspectRatio = (float)settings.getWidth() / (float)settings.getHeight();
        this.z = 1.5f / aspectRatio;
        this.individual = individual;
        Material offscreenMat = new Material(assetManager, "Common/MatDefs/Light/Lighting.j3md");
        offscreenMat.setFloat("Shininess", 0.0f);
        offscreenMat.setBoolean("UseMaterialColors", true);
        offscreenMat.setBoolean("UseAlpha", true);
        offscreenMat.setColor("Ambient", ColorRGBA.Black);
        offscreenMat.setColor("Diffuse", ColorRGBA.White);
        offscreenMat.setColor("Specular", ColorRGBA.Black);
        offscreenMat.setReceivesShadows(true);
        offscreenMat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.processor = new OffscreenProcessor(assetManager, settings, showRoom.clone(true), offscreenMat, "DiffuseMap");
        this.processor.setTextureSize(1024, 1024);
        this.updateDebugText();
        Camera cam = this.processor.getCamera();
        camSettings.configureCamera(cam);
        this.mat = this.processor.getMaterial();
        Box box = new Box(this.z, 0.0f, 1.5f);
        Geometry boxGeo = new Geometry("panel", (Mesh)box);
        boxGeo.setMaterial(this.mat);
        boxGeo.rotate(0.0f, -1.5707964f, 0.0f);
        this.attachChild((Spatial)boxGeo);
        this.control = new RigidBodyControl((CollisionShape)new BoxCollisionShape(new Vector3f(1.5f, 0.1f, this.z)));
        this.addControl((Control)this.control);
        this.setShadowMode(RenderQueue.ShadowMode.Off);
        this.control.setCollisionGroup(1);
        this.control.setMass(50.0f);
        this.control.setFriction(0.01f);
        this.control.setLinearDamping(0.2f);
        this.control.setAngularDamping(1.0f);
        this.control.setLinearSleepingThreshold(0.0f);
        this.setQueueBucket(RenderQueue.Bucket.Transparent);
    }

    public void setInfoStringType(InfoStringType infoStringType) {
        this.infoStringType = infoStringType;
        this.updateDebugText();
    }

    private void updateDebugText() {
        String debugText = String.valueOf(this.individual.getId());
        switch (this.infoStringType) {
            case COSTS: {
                if (!(this.individual instanceof ICostInfo)) break;
                debugText = ((ICostInfo)this.individual).getCostString();
                break;
            }
            case DEBUG: {
                if (!(this.individual instanceof IDebugInfo)) break;
                debugText = ((IDebugInfo)this.individual).getDebugString();
                break;
            }
            case ID: {
                if (!(this.individual instanceof IDebugInfo)) break;
                debugText = ((IDebugInfo)this.individual).getIdString();
                break;
            }
            case GENOTYPE: {
                if (!(this.individual instanceof IDebugInfo)) break;
                debugText = ((IDebugInfo)this.individual).getGenotypeString();
                break;
            }
            default: {
                debugText = "";
            }
        }
        this.processor.setText(debugText);
    }

    public void setCameraSettings(CameraSettings camSettings) {
        Camera cam = this.processor.getCamera();
        camSettings.configureCamera(cam);
    }

    public RigidBodyControl getControl() {
        return this.control;
    }

    public ShowRoom getShowRoom() {
        return this.showRoom;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.mode == Mode.MOVE_TO_INSPECT || this.mode == Mode.INSPECT_DONE) {
            boolean inPosition = true;
            Vector3f loc = this.getLocalTranslation();
            float distance = this.targetLocation.distance(loc);
            if (distance > 0.05f) {
                inPosition = false;
                float maxMoveStep = Math.min(distance, tpf * 4.0f);
                Vector3f dir = this.targetLocation.subtract(loc).normalize().mult(maxMoveStep);
                this.setLocalTranslation(loc.add(dir));
            }
            Quaternion rot = this.getLocalRotation();
            float d = 0.0f;
            float diff = 0.002f;
            float factor = 0.001f;
            float dirX = rot.getX();
            if (FastMath.abs((float)(dirX - d)) > 0.002f) {
                inPosition = false;
                dirX += d - (dirX + dirX * 0.001f);
                LOGGER.info("X: " + rot.getX());
            }
            d = 0.0f;
            float dirY = rot.getY();
            if (FastMath.abs((float)(dirY - d)) > 0.002f) {
                inPosition = false;
                dirY += d - (dirY + dirY * 0.001f);
                LOGGER.info("Y: " + rot.getY());
            }
            d = 0.0f;
            float dirZ = rot.getZ();
            if (FastMath.abs((float)(dirZ - d)) > 0.002f) {
                inPosition = false;
                dirZ += d - (dirZ + dirZ * 0.001f);
                LOGGER.info("Z: " + rot.getZ());
            }
            d = 1.0f;
            float dirW = rot.getW();
            if (FastMath.abs((float)(dirW - d)) > 0.002f) {
                inPosition = false;
                dirW += d - (dirW + dirW * 0.001f);
                LOGGER.info("W: " + rot.getW());
            }
            rot.set(dirX, dirY, dirZ, dirW);
            if (inPosition) {
                if (this.mode == Mode.MOVE_TO_INSPECT) {
                    this.mode = Mode.INSPECT;
                    if (this.listener != null) {
                        this.listener.panelInInspectPosition(this);
                    }
                } else if (this.mode == Mode.INSPECT_DONE) {
                    this.mode = Mode.NORMAL;
                    if (this.control != null) {
                        this.control.setEnabled(true);
                        this.control.setLinearDamping(0.2f);
                    }
                    if (this.getAnchor() != null) {
                        this.getAnchor().attachJoint(this);
                    }
                }
            }
        } else if (this.mode == Mode.INSPECT) {
            this.targetLocation = this.lastLocation;
        }
        if (Math.abs(this.materialAlpha - this.fadeToAlpha) > 1.0E-6f) {
            if (this.materialAlpha > this.fadeToAlpha) {
                this.materialAlpha -= tpf * this.fadeSpeed;
                if (this.materialAlpha < this.fadeToAlpha) {
                    this.materialAlpha = this.fadeToAlpha;
                }
            } else {
                this.materialAlpha += tpf * this.fadeSpeed;
                if (this.materialAlpha > this.fadeToAlpha) {
                    this.materialAlpha = this.fadeToAlpha;
                    this.isInitFade = false;
                }
            }
            this.mat.setColor("Diffuse", new ColorRGBA(1.0f, 1.0f, 1.0f, this.materialAlpha));
        }
        if (!this.isInitFade && Math.abs(this.materialAlpha) < 1.0E-6f && this.listener != null) {
            this.listener.panelReadyToDestroy(this);
            this.listener = null;
        }
    }

    public void inspect() {
        this.mode = Mode.MOVE_TO_INSPECT;
        if (this.getAnchor() != null) {
            this.getAnchor().detachJoint();
        }
        if (this.control != null) {
            this.control.setEnabled(false);
            this.control.setGravity(Vector3f.ZERO);
            this.control.setLinearDamping(2.0f);
        }
        this.targetLocation = INSPECT_LOCATION;
        this.lastLocation = this.getLocalTranslation();
    }

    public void inspectDone() {
        this.mode = Mode.INSPECT_DONE;
    }

    protected void setParent(Node parent) {
        super.setParent(parent);
        this.control.setPhysicsLocation(this.getLocalTranslation());
    }

    public T getIndividual() {
        return this.individual;
    }

    public void setPanelNodeListener(PanelNodeListener<T> listener) {
        this.listener = listener;
    }

    public void setAnchor(AnchorNode<T> anchor) {
        this.anchor = anchor;
    }

    public AnchorNode<T> getAnchor() {
        return this.anchor;
    }

    public OffscreenProcessor getProcessor() {
        return this.processor;
    }

    public void setFadeToAlpha(float alpha) {
        this.fadeToAlpha = alpha;
    }

    public void setFadeSpeed(float fadeSpeed) {
        this.fadeSpeed = fadeSpeed;
    }

    public static enum Mode {
        NORMAL,
        FADE,
        MOVE_TO_INSPECT,
        INSPECT,
        INSPECT_DONE;

    }

    public static enum InfoStringType {
        COSTS,
        ID,
        DEBUG,
        GENOTYPE,
        NONE;

    }
}

