/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming.showroom;

import com.jme3.asset.AssetManager;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.util.TangentBinormalGenerator;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomSettings;
import ga.view.streaming.showroom.Wall;
import math.geom2d.Point2D;
import math.geom2d.Shape2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Rectangle2D;

public final class BoxShowRoom
extends ShowRoom {
    private final Node walls;
    private final Geometry floor;
    private final Geometry roof;
    private final Rectangle2D bounds;

    public BoxShowRoom(AssetManager assetManager, AppSettings settings, ShowRoomSettings showRoomSettings) {
        super("Show Room", assetManager, settings, showRoomSettings);
        float roomWidth = showRoomSettings.getFloat("width", 5.0f).floatValue();
        float roomLength = showRoomSettings.getFloat("length", 5.0f).floatValue();
        float roomHeight = showRoomSettings.getFloat("height", 2.8f).floatValue();
        float wallThickness = 0.1f;
        float roomWidthHalf = roomWidth / 2.0f;
        float roomLengthHalf = roomLength / 2.0f;
        this.walls = new Node("walls");
        Wall m = new Wall(new Vector3f(roomWidthHalf, 0.0f, -roomLengthHalf), new Vector3f(roomWidthHalf + 0.1f, roomHeight, roomLengthHalf));
        Geometry geo = new Geometry("wall1", (Mesh)m);
        geo.getLocalRotation().fromAngles(0.0f, (float)Math.PI, 0.0f);
        geo.setMaterial(this.wallMaterial);
        this.walls.attachChild((Spatial)geo);
        m = new Wall(new Vector3f(roomLengthHalf, 0.0f, -roomWidthHalf), new Vector3f(roomLengthHalf + 0.1f, roomHeight, roomWidthHalf));
        geo = new Geometry("wall2", (Mesh)m);
        geo.setMaterial(this.wallMaterial);
        geo.getLocalRotation().fromAngles(0.0f, 4.712389f, 0.0f);
        this.walls.attachChild((Spatial)geo);
        m = new Wall(new Vector3f(roomWidthHalf, 0.0f, -roomLengthHalf), new Vector3f(roomWidthHalf + 0.1f, roomHeight, roomLengthHalf));
        geo = new Geometry("wall3", (Mesh)m);
        geo.setMaterial(this.wallMaterial);
        this.walls.attachChild((Spatial)geo);
        m = new Wall(new Vector3f(roomLengthHalf, 0.0f, -roomWidthHalf), new Vector3f(roomLengthHalf + 0.1f, roomHeight, roomWidthHalf));
        geo = new Geometry("wall4", (Mesh)m);
        geo.setMaterial(this.wallMaterial);
        geo.getLocalRotation().fromAngles(0.0f, 1.5707964f, 0.0f);
        this.walls.attachChild((Spatial)geo);
        this.walls.setCullHint(Spatial.CullHint.Dynamic);
        this.attachChild((Spatial)this.walls);
        this.floor = new Geometry("floor", (Mesh)new Box(new Vector3f(roomWidthHalf, 0.0f, roomLengthHalf), new Vector3f(-roomWidthHalf, 0.0f, -roomLengthHalf)));
        this.floor.setMaterial(this.floorMaterial);
        float floorScale = 2.0f;
        this.floor.getMesh().scaleTextureCoordinates(new Vector2f(roomLength / 2.0f, roomWidth / 2.0f));
        this.attachChild((Spatial)this.floor);
        m = new Wall(new Vector3f(0.0f, -roomWidthHalf, -roomLengthHalf), new Vector3f(0.1f, roomWidthHalf, roomLengthHalf));
        this.roof = new Geometry("ceiling", (Mesh)m);
        this.roof.setMaterial(this.ceilingMaterial);
        this.roof.getLocalRotation().fromAngles(0.0f, 0.0f, 1.5707964f);
        this.roof.setLocalTranslation(0.0f, roomHeight, 0.0f);
        this.attachChild((Spatial)this.roof);
        this.updateModelBound();
        this.setShadowMode(RenderQueue.ShadowMode.Receive);
        TangentBinormalGenerator.generate((Spatial)this);
        this.bounds = new Rectangle2D((double)(-roomWidthHalf), (double)(-roomLengthHalf), (double)roomWidth, (double)roomLength);
        this.createLights();
        this.updateGeometricState();
    }

    private void createLights() {
        float roomWidth = this.showRoomSettings.getFloat("width", 5.0f).floatValue();
        float roomLength = this.showRoomSettings.getFloat("length", 5.0f).floatValue();
        float roomHeight = this.showRoomSettings.getFloat("height", 2.8f).floatValue();
        float roomWidthHalf = roomWidth / 2.0f;
        float roomLengthHalf = roomLength / 2.0f;
        LightingType type = (LightingType)((Object)this.showRoomSettings.get("LightingType"));
        if (type == null) {
            type = LightingType.AMBIENT;
        }
        switch (type) {
            case OFFICE: {
                ColorRGBA lightC = new ColorRGBA(0.55f, 0.55f, 0.6f, 0.2f);
                float radius = (int)(Math.min(roomWidth, roomLength) * 1.2f);
                int lightCount = Math.min((int)(Math.max(roomWidth, roomLength) * 0.6f), 8);
                float lightDistance = 1.6f;
                for (int i = 1; i <= lightCount; ++i) {
                    float x = Math.min(roomWidthHalf, roomLengthHalf) * 0.9f;
                    float z = 1.6f * ((float)(lightCount + 1) * 0.5f - (float)i);
                    PointLight pl = new PointLight();
                    Vector3f pos = new Vector3f(roomLength < roomWidth ? z : x, roomHeight * 0.8f, roomLength < roomWidth ? x : z);
                    pl.setPosition(pos);
                    pl.setColor(lightC);
                    pl.setRadius(radius);
                    this.addLight((Light)pl);
                    this.createLightObj(pos);
                    x = -x;
                    pl = new PointLight();
                    pos = new Vector3f(roomLength < roomWidth ? z : x, roomHeight * 0.8f, roomLength < roomWidth ? x : z);
                    pl.setPosition(pos);
                    pl.setColor(lightC);
                    pl.setRadius(radius);
                    this.addLight((Light)pl);
                    this.createLightObj(pos);
                }
                this.addLight((Light)new AmbientLight());
                break;
            }
            case ATMOSPHERE: {
                ColorRGBA lightC = new ColorRGBA(0.8f, 0.8f, 0.6f, 0.8f);
                Vector3f pos = new Vector3f(roomWidthHalf * 0.8f, roomHeight * 0.8f, roomLengthHalf * 0.8f);
                PointLight pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(roomHeight * 2.0f);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                pos = new Vector3f(-roomWidthHalf * 0.8f, roomHeight * 0.8f, -roomLengthHalf * 0.8f);
                pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(roomHeight * 2.0f);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                pos = new Vector3f(roomWidthHalf * 0.8f, roomHeight * 0.8f, -roomLengthHalf * 0.8f);
                pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(roomHeight * 2.0f);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                pos = new Vector3f(-roomWidthHalf * 0.8f, roomHeight * 0.8f, roomLengthHalf * 0.8f);
                pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(roomHeight * 2.0f);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                this.addLight((Light)new AmbientLight());
                break;
            }
            default: {
                ColorRGBA lightC = new ColorRGBA(0.8f, 0.8f, 0.6f, 0.8f);
                float radius = Math.max(roomWidth, roomLength);
                float wallDist = 0.4f;
                Vector3f pos = new Vector3f(roomWidthHalf - 0.4f, roomHeight * 0.9f, 0.0f);
                PointLight pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(radius);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                pos = new Vector3f(-roomWidthHalf + 0.4f, roomHeight * 0.9f, 0.0f);
                pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(radius);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                pos = new Vector3f(0.0f, roomHeight * 0.9f, roomLengthHalf - 0.4f);
                pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(radius);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                pos = new Vector3f(0.0f, roomHeight * 0.9f, -roomLengthHalf + 0.4f);
                pl = new PointLight();
                pl.setPosition(pos);
                pl.setColor(lightC);
                pl.setRadius(radius);
                this.addLight((Light)pl);
                this.createLightObj(pos);
                this.addLight((Light)new AmbientLight());
            }
        }
    }

    private void createLightObj(Vector3f pos) {
    }

    @Deprecated
    public Material getMaterial() {
        return this.wallMaterial;
    }

    @Override
    public boolean contains(Polygon2D shape) {
        return this.bounds.getBoundingBox().containsBounds((Shape2D)shape);
    }

    @Override
    public float minDistanceToWall(Polygon2D shape, float angle) {
        float minDistance = Float.MAX_VALUE;
        for (LineSegment2D edge : this.bounds.getEdges()) {
            for (Point2D vert : shape.getVertices()) {
                boolean sameDir = false;
                if (Math.abs(angle) < 1.0E-4f) {
                    if (edge.getFirstPoint().getY() < vert.getY() && edge.getLastPoint().getY() < vert.getY()) {
                        sameDir = true;
                    }
                } else if (Math.abs(angle - 1.5707964f) < 1.0E-4f) {
                    if (edge.getFirstPoint().getX() < vert.getX() && edge.getLastPoint().getX() < vert.getX()) {
                        sameDir = true;
                    }
                } else if (Math.abs(angle - (float)Math.PI) < 1.0E-4f) {
                    if (edge.getFirstPoint().getY() > vert.getY() && edge.getLastPoint().getY() > vert.getY()) {
                        sameDir = true;
                    }
                } else if (Math.abs(angle - 4.712389f) < 1.0E-4f && edge.getFirstPoint().getX() > vert.getX() && edge.getLastPoint().getX() > vert.getX()) {
                    sameDir = true;
                }
                if (!sameDir) continue;
                minDistance = Math.min(minDistance, (float)edge.getDistance(vert));
            }
        }
        return minDistance;
    }

    @Override
    public Rectangle2D getOutterBounds() {
        return this.bounds;
    }

    public static enum LightingType {
        AMBIENT,
        ATMOSPHERE,
        OFFICE;

    }
}

