/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming.showroom;

import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.system.AppSettings;
import ga.view.streaming.showroom.ShowRoom;

public class CameraSettings {
    private final Vector3f initialLocation;
    private Vector3f lookAtPoint = Vector3f.ZERO;
    private final boolean isIsometric;
    private float minVRotation = 0.2f;
    private float maxVRotation = 0.3f;
    private float minDistance = 1.0f;
    private float maxDistance = 10.0f;
    private float frustumNear = 0.1f;
    private float frustumFar = 20.0f;
    private final float fov;
    private final float aspect;

    public CameraSettings(Vector3f initialLocation, Vector3f lookAtPoint, float minVRotation, float maxVRotation, float minDistance, float maxDistance, float aspect, float fov, float frustumNear, float frustumFar, boolean isIsometric) {
        this.initialLocation = initialLocation;
        this.lookAtPoint = lookAtPoint;
        this.isIsometric = isIsometric;
        this.minVRotation = minVRotation;
        this.maxVRotation = maxVRotation;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.aspect = aspect;
        this.fov = fov;
        this.frustumNear = frustumNear;
        this.frustumFar = frustumFar;
    }

    public void configureCamera(Camera cam) {
        cam.setParallelProjection(this.isIsometric);
        cam.setLocation(this.initialLocation);
        cam.lookAt(this.lookAtPoint, Vector3f.UNIT_Y);
        cam.setFrustumNear(this.frustumNear);
        cam.setFrustumFar(this.frustumFar);
        if (this.isIsometric) {
            cam.setFrustum(this.frustumNear, this.frustumFar, this.aspect * -4.0f, this.aspect * 4.0f, 4.0f, -4.0f);
        } else {
            cam.setFrustumPerspective(this.fov, this.aspect, this.frustumNear, this.frustumFar);
        }
    }

    public Vector3f getLookAtPoint() {
        return this.lookAtPoint;
    }

    public float getMaxVRotation() {
        return this.maxVRotation;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public float getMinVRotation() {
        return this.minVRotation;
    }

    public static CameraSettings getSettings(Type type, ShowRoom room, AppSettings settings) {
        switch (type) {
            case IN_ROOM: {
                return CameraSettings.getInRoomSettings(room, settings);
            }
            case ISOMETRIC: {
                return CameraSettings.getIsometricSettings(room, settings);
            }
            case ORTHOGRAPHIC: {
                return CameraSettings.getOrthographicSettings(room, settings);
            }
        }
        return null;
    }

    public static CameraSettings getInRoomSettings(ShowRoom room, AppSettings settings) {
        Vector3f location = new Vector3f(3.0f, 1.8f, 3.0f);
        Vector3f target = room.getLocalTranslation();
        float minDistance = location.distance(target);
        float maxDistance = minDistance * 1.5f;
        float frustumFar = maxDistance * 4.0f;
        return new CameraSettings(location, target, 0.2f, 0.3f, minDistance, maxDistance, (float)settings.getWidth() / (float)settings.getHeight(), 45.0f, 0.1f, frustumFar, false);
    }

    public static CameraSettings getIsometricSettings(ShowRoom room, AppSettings settings) {
        Vector3f location = new Vector3f(70.0f, 60.0f, 70.0f);
        Vector3f target = Vector3f.ZERO;
        float maxDistance = location.distance(target) * 1.05f;
        float frustumFar = maxDistance * 2.0f;
        return new CameraSettings(location, target, 0.2f, 0.9f, 1.0f, maxDistance, (float)settings.getWidth() / (float)settings.getHeight(), 45.0f, 0.1f, frustumFar, true);
    }

    public static CameraSettings getOrthographicSettings(ShowRoom room, AppSettings settings) {
        Vector3f location = new Vector3f(7.0f, 6.0f, 7.0f);
        Vector3f target = new Vector3f(0.0f, -0.5f, 0.0f);
        float minDistance = location.distance(target) * 0.5f;
        float maxDistance = location.distance(target) * 1.05f;
        float frustumFar = maxDistance * 2.0f;
        return new CameraSettings(location, target, 0.2f, 0.9f, minDistance, maxDistance, (float)settings.getWidth() / (float)settings.getHeight(), 45.0f, 0.1f, frustumFar, false);
    }

    public static enum Type {
        ISOMETRIC,
        ORTHOGRAPHIC,
        IN_ROOM;

    }
}

