/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming.showroom;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import ga.view.interfaces.IPhenotypeSpace;
import ga.view.streaming.showroom.ShowRoomSettings;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ShowRoom
extends Node
implements IPhenotypeSpace {
    public static final ColorRGBA DEFAULT_COLOR = new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f);
    private static final Logger LOGGER = Logger.getLogger(ShowRoom.class.getName());
    protected Material whiteMaterial;
    protected Material wallMaterial;
    protected Material floorMaterial;
    protected Material ceilingMaterial;
    protected final ShowRoomSettings showRoomSettings;
    private Spatial phenoType;

    public ShowRoom(String name, AssetManager assetManager, AppSettings settings, ShowRoomSettings showRoomSettings) {
        super(name);
        this.showRoomSettings = showRoomSettings;
        this.initMaterials(assetManager, settings);
    }

    public Material getWallMaterial() {
        return this.wallMaterial;
    }

    private void initMaterials(AssetManager assetManager, AppSettings settings) {
        this.whiteMaterial = new Material(assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (settings.getBoolean("UseHQMaterial")) {
            this.whiteMaterial.setFloat("Shininess", 1.0f);
            this.whiteMaterial.setBoolean("UseMaterialColors", true);
            this.whiteMaterial.setColor("Ambient", new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f));
            this.whiteMaterial.setColor("Diffuse", DEFAULT_COLOR);
            this.whiteMaterial.setColor("Specular", ColorRGBA.Black);
            this.whiteMaterial.setReceivesShadows(true);
            try {
                this.whiteMaterial.setTexture("ColorRamp", assetManager.loadTexture("ga/view/resource/cloudy.png"));
            }
            catch (AssetNotFoundException e) {
                LOGGER.log(Level.WARNING, "Texture not found", e);
            }
            try {
                this.whiteMaterial.setTexture("NormalMap", assetManager.loadTexture("furny/textures/Bump_Wallpaper.jpg"));
            }
            catch (AssetNotFoundException e) {
                LOGGER.log(Level.WARNING, "Texture not found", e);
            }
            this.whiteMaterial.setBoolean("Minnaert", false);
            this.whiteMaterial.setBoolean("WardIso", false);
            this.whiteMaterial.setBoolean("VTangent", true);
            this.whiteMaterial.setBoolean("VertexLighting", false);
            this.whiteMaterial.setBoolean("LowQuality", false);
            this.whiteMaterial.setBoolean("HighQuality", true);
        } else {
            this.whiteMaterial.setFloat("Shininess", 1.0f);
            this.whiteMaterial.setBoolean("UseMaterialColors", true);
            this.whiteMaterial.setColor("Ambient", DEFAULT_COLOR.mult(0.8f));
            this.whiteMaterial.setColor("Diffuse", DEFAULT_COLOR);
            this.whiteMaterial.setColor("Specular", ColorRGBA.Black);
            try {
                this.whiteMaterial.setTexture("NormalMap", assetManager.loadTexture("furny/textures/Bump_Wallpaper.jpg"));
            }
            catch (AssetNotFoundException e) {
                LOGGER.log(Level.WARNING, "Texture not found", e);
            }
            this.whiteMaterial.setReceivesShadows(true);
            this.whiteMaterial.setBoolean("Minnaert", false);
            this.whiteMaterial.setBoolean("WardIso", false);
            this.whiteMaterial.setBoolean("VTangent", false);
            this.whiteMaterial.setBoolean("VertexLighting", false);
            this.whiteMaterial.setBoolean("LowQuality", true);
            this.whiteMaterial.setBoolean("HighQuality", false);
        }
        Object o = this.showRoomSettings.get("ceilingMaterial");
        if (o != null) {
            if (o instanceof Material) {
                this.ceilingMaterial = (Material)o;
            } else if (o instanceof String) {
                try {
                    this.ceilingMaterial = assetManager.loadMaterial((String)o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.ceilingMaterial == null) {
            this.ceilingMaterial = this.whiteMaterial;
        }
        if ((o = this.showRoomSettings.get("wallMaterial")) != null) {
            if (o instanceof Material) {
                this.wallMaterial = (Material)o;
            } else if (o instanceof String) {
                try {
                    this.wallMaterial = assetManager.loadMaterial((String)o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.wallMaterial == null) {
            this.wallMaterial = this.whiteMaterial;
        }
        this.wallMaterial.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Back);
        o = this.showRoomSettings.get("floorMaterial");
        if (o != null) {
            if (o instanceof Material) {
                this.floorMaterial = (Material)o;
            } else if (o instanceof String) {
                try {
                    this.floorMaterial = assetManager.loadMaterial((String)o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.floorMaterial == null) {
            this.floorMaterial = this.whiteMaterial;
        }
    }

    public void setPhenotype(Spatial phenotype) {
        if (this.phenoType != null) {
            this.detachChild(this.phenoType);
        }
        this.phenoType = phenotype;
        this.attachChild(this.phenoType);
        this.phenoType.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.updateGeometricState();
    }

    public ShowRoomSettings getShowRoomSettings() {
        return this.showRoomSettings;
    }
}

