/*
 * Decompiled with CFR 0.152.
 */
package ga.view.streaming.showroom;

import com.jme3.asset.AssetManager;
import com.jme3.system.AppSettings;
import ga.view.streaming.showroom.BoxShowRoom;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomSettings;

public class ShowRoomFactory {
    private final AssetManager assetManager;
    private final AppSettings settings;
    private final ShowRoomSettings showRoomSettings;
    private ShowRoom template;

    public ShowRoomFactory(AssetManager assetManager, AppSettings settings, ShowRoomSettings showRoomSettings) {
        this.assetManager = assetManager;
        this.settings = settings;
        this.showRoomSettings = showRoomSettings;
        this.initShowRoom();
    }

    private void initShowRoom() {
        ShowRoomSettings.ShowRoomType type = this.showRoomSettings.getType();
        switch (type) {
            case BOX: {
                this.template = new BoxShowRoom(this.assetManager, this.settings, this.showRoomSettings);
            }
        }
    }

    public ShowRoom createShowRoom() {
        return this.createShowRoom(false);
    }

    public ShowRoom createShowRoom(boolean initNew) {
        if (initNew) {
            this.initShowRoom();
        }
        return (ShowRoom)this.template.clone();
    }
}

