/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;

public class Vector2D
implements GeometricObject2D,
Cloneable {
    protected double x;
    protected double y;

    public static Vector2D create(double x, double y) {
        return new Vector2D(x, y);
    }

    public static Vector2D create(Point2D point) {
        return new Vector2D(point.getX(), point.getY());
    }

    public static Vector2D createPolar(double rho, double theta) {
        return new Vector2D(rho * Math.cos(theta), rho * Math.sin(theta));
    }

    public static double dot(Vector2D v1, Vector2D v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public static double cross(Vector2D v1, Vector2D v2) {
        return v1.x * v2.y - v2.x * v1.y;
    }

    public static boolean isColinear(Vector2D v1, Vector2D v2) {
        v1 = v1.getNormalizedVector();
        v2 = v2.getNormalizedVector();
        return Math.abs(v1.x * v2.y - v1.y * v2.x) < 1.0E-12;
    }

    public static boolean isOrthogonal(Vector2D v1, Vector2D v2) {
        v1 = v1.getNormalizedVector();
        v2 = v2.getNormalizedVector();
        return Math.abs(v1.x * v2.x + v1.y * v2.y) < 1.0E-12;
    }

    public Vector2D() {
        this(1.0, 0.0);
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D(Point2D point) {
        this(point.getX(), point.getY());
    }

    public Vector2D(Point2D point1, Point2D point2) {
        this(point2.getX() - point1.getX(), point2.getY() - point1.getY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Vector2D getOpposite() {
        return new Vector2D(-this.x, -this.y);
    }

    public double getNorm() {
        return Math.hypot(this.x, this.y);
    }

    public double getAngle() {
        return Angle2D.getHorizontalAngle(this);
    }

    public void normalize() {
        double r = Math.hypot(this.x, this.y);
        this.x /= r;
        this.y /= r;
    }

    public Vector2D getNormalizedVector() {
        double r = Math.hypot(this.x, this.y);
        return new Vector2D(this.x / r, this.y / r);
    }

    public boolean isColinear(Vector2D v) {
        return Vector2D.isColinear(this, v);
    }

    public boolean isOrthogonal(Vector2D v) {
        return Vector2D.isOrthogonal(this, v);
    }

    public double dot(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public double cross(Vector2D v) {
        return this.x * v.y - v.x * this.y;
    }

    public Vector2D plus(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public Vector2D minus(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    public Vector2D times(double k) {
        return new Vector2D(this.x * k, this.y * k);
    }

    public Vector2D transform(AffineTransform2D trans) {
        double[] tab = trans.getCoefficients();
        return new Vector2D(this.x * tab[0] + this.y * tab[1], this.x * tab[3] + this.y * tab[4]);
    }

    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector2D)) {
            return false;
        }
        Vector2D v = (Vector2D)obj;
        if (Math.abs(this.x - v.x) > eps) {
            return false;
        }
        return !(Math.abs(this.y - v.y) > eps);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector2D)) {
            return false;
        }
        Vector2D v = (Vector2D)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(v.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(v.y);
    }

    public String toString() {
        return new String("x=" + this.x + " y=" + this.y);
    }

    public Vector2D clone() {
        return new Vector2D(this.x, this.y);
    }
}

