/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.Box2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearCurveSet2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CirculinearCurveArray2D<T extends CirculinearCurve2D>
extends CurveArray2D<T>
implements CirculinearCurveSet2D<T> {
    public static <T extends CirculinearCurve2D> CirculinearCurveArray2D<T> create(Collection<T> curves) {
        return new CirculinearCurveArray2D<T>(curves);
    }

    public static <T extends CirculinearCurve2D> CirculinearCurveArray2D<T> create(T ... curves) {
        return new CirculinearCurveArray2D(curves);
    }

    public CirculinearCurveArray2D() {
        this.curves = new ArrayList();
    }

    public CirculinearCurveArray2D(int n) {
        this.curves = new ArrayList(n);
    }

    public CirculinearCurveArray2D(T ... curves) {
        this.curves = new ArrayList(curves.length);
        T[] TArray = curves;
        int n = curves.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.addCurve(element);
            ++n2;
        }
    }

    public CirculinearCurveArray2D(Collection<? extends T> curves) {
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (CirculinearCurve2D curve : this.getCurves()) {
            sum += curve.getLength();
        }
        return sum;
    }

    @Override
    public double getLength(double pos) {
        return CirculinearCurve2DUtils.getLength(this, pos);
    }

    @Override
    public double getPosition(double length) {
        return CirculinearCurve2DUtils.getPosition(this, length);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CirculinearCurve2D getParallel(double d) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.createParallel(this, d);
    }

    @Override
    public CirculinearCurveArray2D<CirculinearCurve2D> transform(CircleInversion2D inv) {
        CirculinearCurveArray2D<CirculinearCurve2D> result = new CirculinearCurveArray2D<CirculinearCurve2D>(this.curves.size());
        for (CirculinearCurve2D curve : this.curves) {
            result.addCurve(curve.transform(inv));
        }
        return result;
    }

    @Override
    public Collection<? extends CirculinearContinuousCurve2D> getContinuousCurves() {
        ArrayList<? extends CirculinearContinuousCurve2D> result = new ArrayList<CirculinearContinuousCurve2D>();
        for (CirculinearCurve2D curve : this.curves) {
            result.addAll(curve.getContinuousCurves());
        }
        return result;
    }

    @Override
    public CirculinearCurveArray2D<? extends CirculinearCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        int n = set.getCurveNumber();
        CirculinearCurveArray2D<CirculinearCurve2D> result = new CirculinearCurveArray2D<CirculinearCurve2D>(n);
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CirculinearCurve2D)) continue;
            result.addCurve((CirculinearCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public CirculinearCurveArray2D<? extends CirculinearCurve2D> getSubCurve(double t0, double t1) {
        Curve2D subcurve = super.getSubCurve(t0, t1);
        CirculinearCurveArray2D<CirculinearCurve2D> result = new CirculinearCurveArray2D<CirculinearCurve2D>(subcurve.getCurveNumber());
        Iterator iterator = subcurve.iterator();
        while (iterator.hasNext()) {
            Curve2D curve = (Curve2D)iterator.next();
            if (curve instanceof CirculinearCurve2D) {
                result.addCurve((CirculinearCurve2D)curve);
                continue;
            }
            System.err.println("CirculinearCurveArray2D.getSubCurve: error in class cast");
        }
        return result;
    }

    @Override
    public CirculinearCurveArray2D<? extends CirculinearCurve2D> getReverseCurve() {
        int n = this.curves.size();
        CirculinearCurve2D[] curves2 = new CirculinearCurve2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = ((CirculinearCurve2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return new CirculinearCurveArray2D(curves2);
    }
}

