/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.circulinear.BoundaryPolyCirculinearCurve2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearCurveArray2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CirculinearDomain2DUtils {
    public static final CirculinearDomain2D computeBuffer(CirculinearDomain2D domain, double dist) {
        ArrayList<CirculinearContour2D> rings = new ArrayList<CirculinearContour2D>();
        for (CirculinearContour2D circulinearContour2D : domain.getBoundary().getContinuousCurves()) {
            for (CirculinearContinuousCurve2D simpleCurve : CirculinearCurve2DUtils.splitContinuousCurve(circulinearContour2D)) {
                BoundaryPolyCirculinearCurve2D<? extends CirculinearElement2D> boundary = new BoundaryPolyCirculinearCurve2D<CirculinearElement2D>(simpleCurve.getSmoothPieces());
                rings.addAll(CirculinearDomain2DUtils.computeBufferSimpleRing(boundary, dist));
            }
        }
        return new GenericCirculinearDomain2D(new CirculinearContourArray2D(rings));
    }

    public static final Collection<CirculinearContour2D> computeBufferSimpleRing(CirculinearContour2D curve, double d) {
        ArrayList<BoundaryPolyCirculinearCurve2D<? extends CirculinearElement2D>> rings = new ArrayList<BoundaryPolyCirculinearCurve2D<? extends CirculinearElement2D>>();
        CirculinearContour2D parallel1 = curve.getParallel(d);
        CirculinearCurveArray2D<CirculinearContinuousCurve2D> curves = new CirculinearCurveArray2D<CirculinearContinuousCurve2D>();
        for (CirculinearContinuousCurve2D split : CirculinearCurve2DUtils.splitContinuousCurve(parallel1)) {
            if (CirculinearCurve2DUtils.findIntersections(curve, split).size() != 0) continue;
            curves.addCurve(split);
        }
        for (CirculinearContinuousCurve2D split : curves) {
            rings.add(new BoundaryPolyCirculinearCurve2D<CirculinearElement2D>(split.getSmoothPieces(), split.isClosed()));
        }
        ArrayList<CirculinearContour2D> rings2 = new ArrayList<CirculinearContour2D>();
        for (CirculinearContour2D circulinearContour2D : rings) {
            for (CirculinearContinuousCurve2D split : CirculinearCurve2DUtils.splitContinuousCurve(circulinearContour2D)) {
                double dist = CirculinearCurve2DUtils.getDistanceCurvePoints(curve, split.getSingularPoints());
                if (dist - d < -1.0E-12) continue;
                rings2.add(new BoundaryPolyCirculinearCurve2D<CirculinearElement2D>(split.getSmoothPieces(), split.isClosed()));
            }
        }
        return rings2;
    }
}

