/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.conic.Ellipse2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.Ray2D;
import math.geom2d.line.StraightLine2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipseArc2D
extends AbstractSmoothCurve2D
implements SmoothOrientedCurve2D,
Cloneable {
    protected Ellipse2D ellipse;
    protected double startAngle = 0.0;
    protected double angleExtent = Math.PI;

    public static EllipseArc2D create(Ellipse2D ell, double start, double extent) {
        return new EllipseArc2D(ell.xc, ell.yc, ell.r1, ell.r2, ell.theta, start, extent);
    }

    public static EllipseArc2D create(Ellipse2D ell, double start, double end, boolean direct) {
        return new EllipseArc2D(ell.xc, ell.yc, ell.r1, ell.r2, ell.theta, start, end, direct);
    }

    public EllipseArc2D() {
        this(0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.5707963267948966);
    }

    public EllipseArc2D(Ellipse2D ell, double start, double extent) {
        this(ell.xc, ell.yc, ell.r1, ell.r2, ell.theta, start, extent);
    }

    public EllipseArc2D(Ellipse2D ell, double start, double end, boolean direct) {
        this(ell.xc, ell.yc, ell.r1, ell.r2, ell.theta, start, end, direct);
    }

    public EllipseArc2D(double xc, double yc, double a, double b, double theta, double start, double extent) {
        this.ellipse = new Ellipse2D(xc, yc, a, b, theta);
        this.startAngle = start;
        this.angleExtent = extent;
    }

    public EllipseArc2D(double xc, double yc, double a, double b, double theta, double start, double end, boolean direct) {
        this.ellipse = new Ellipse2D(xc, yc, a, b, theta);
        this.startAngle = start;
        this.angleExtent = Angle2D.formatAngle(end - start);
        if (!direct) {
            this.angleExtent -= Math.PI * 2;
        }
    }

    public Ellipse2D getSupportingEllipse() {
        return this.ellipse;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getAngleExtent() {
        return this.angleExtent;
    }

    public boolean isDirect() {
        return this.angleExtent > 0.0;
    }

    public boolean containsAngle(double angle) {
        return Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, angle, this.angleExtent > 0.0);
    }

    public double getAngle(double position) {
        if (position < 0.0) {
            position = 0.0;
        }
        if (position > Math.abs(this.angleExtent)) {
            position = Math.abs(this.angleExtent);
        }
        if (this.angleExtent < 0.0) {
            position = -position;
        }
        return Angle2D.formatAngle(this.startAngle + position);
    }

    @Override
    public double getWindingAngle(Point2D point) {
        Point2D p1 = this.getPoint(0.0);
        Point2D p2 = this.getPoint(Math.abs(this.angleExtent));
        double angle1 = Angle2D.getHorizontalAngle(point, p1);
        double angle2 = Angle2D.getHorizontalAngle(point, p2);
        boolean b1 = new StraightLine2D(p1, p2).isInside(point);
        boolean b2 = this.ellipse.isInside(point);
        if (this.angleExtent > 0.0) {
            if (b1 || b2) {
                if (angle2 > angle1) {
                    return angle2 - angle1;
                }
                return Math.PI * 2 - angle1 + angle2;
            }
            if (angle2 > angle1) {
                return angle2 - angle1 - Math.PI * 2;
            }
            return angle2 - angle1;
        }
        if (!b1 || b2) {
            if (angle1 > angle2) {
                return angle2 - angle1;
            }
            return angle2 - angle1 - Math.PI * 2;
        }
        if (angle1 > angle2) {
            return angle2 - angle1 + Math.PI * 2;
        }
        return angle2 - angle1;
    }

    @Override
    public boolean isInside(Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY()) < 0.0;
    }

    @Override
    public double getSignedDistance(Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        boolean direct = this.angleExtent > 0.0;
        double dist = this.getDistance(x, y);
        Point2D point = new Point2D(x, y);
        boolean inside = this.ellipse.isInside(point);
        if (inside) {
            return this.angleExtent > 0.0 ? -dist : dist;
        }
        Point2D p1 = this.getPoint(this.startAngle);
        Point2D p2 = this.getPoint(this.startAngle + this.angleExtent);
        boolean onLeft = new StraightLine2D(p1, p2).isInside(point);
        if (direct && !onLeft) {
            return dist;
        }
        if (!direct && onLeft) {
            return -dist;
        }
        boolean left1 = new Ray2D(p1, -Math.sin(this.startAngle), Math.cos(this.startAngle)).isInside(point);
        if (direct && !left1) {
            return dist;
        }
        if (!direct && left1) {
            return -dist;
        }
        boolean left2 = new Ray2D(p2, -Math.sin(this.startAngle + this.angleExtent), Math.cos(this.startAngle + this.angleExtent)).isInside(point);
        if (direct && !left2) {
            return dist;
        }
        if (!direct && left2) {
            return -dist;
        }
        if (direct) {
            return -dist;
        }
        return dist;
    }

    @Override
    public Vector2D getTangent(double t) {
        t = Math.min(Math.max(0.0, t), Math.abs(this.angleExtent));
        if (this.angleExtent < 0.0) {
            return this.ellipse.getTangent(this.startAngle - t).times(-1.0);
        }
        return this.ellipse.getTangent(this.startAngle + t);
    }

    @Override
    public double getCurvature(double t) {
        t = this.angleExtent < 0.0 ? this.startAngle - t : this.startAngle + t;
        double kappa = this.ellipse.getCurvature(t);
        return this.isDirect() ? kappa : -kappa;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return Math.abs(this.angleExtent);
    }

    @Override
    public Point2D getPoint(double t) {
        t = Math.max(t, 0.0);
        t = Math.min(t, Math.abs(this.angleExtent));
        t = this.angleExtent < 0.0 ? this.startAngle - t : this.startAngle + t;
        return this.ellipse.getPoint(t);
    }

    @Override
    public double getPosition(Point2D point) {
        double angle = Angle2D.getHorizontalAngle(this.ellipse.getCenter(), point);
        if (this.containsAngle(angle)) {
            if (this.angleExtent > 0.0) {
                return Angle2D.formatAngle(angle - this.startAngle);
            }
            return Angle2D.formatAngle(this.startAngle - angle);
        }
        return Double.NaN;
    }

    @Override
    public double project(Point2D point) {
        double d2;
        double angle = this.ellipse.project(point);
        if (this.containsAngle(angle)) {
            if (this.angleExtent > 0.0) {
                return Angle2D.formatAngle(angle - this.startAngle);
            }
            return Angle2D.formatAngle(this.startAngle - angle);
        }
        double d1 = this.getFirstPoint().getDistance(point);
        return d1 < (d2 = this.getLastPoint().getDistance(point)) ? 0.0 : Math.abs(this.angleExtent);
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        ArrayList<Point2D> array = new ArrayList<Point2D>();
        for (Point2D point : this.ellipse.getIntersections(line)) {
            if (!this.contains(point)) continue;
            array.add(point);
        }
        return array;
    }

    @Override
    public EllipseArc2D getReverseCurve() {
        return new EllipseArc2D(this.ellipse, Angle2D.formatAngle(this.startAngle + this.angleExtent), -this.angleExtent);
    }

    public Collection<? extends EllipseArc2D> getContinuousCurves() {
        return EllipseArc2D.wrapCurve(this);
    }

    @Override
    public EllipseArc2D getSubCurve(double t0, double t1) {
        t0 = Angle2D.formatAngle(this.startAngle + t0);
        t1 = Angle2D.formatAngle(this.startAngle + t1);
        if (!Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, t0, this.angleExtent > 0.0)) {
            t0 = this.startAngle;
        }
        if (!Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, t1, this.angleExtent > 0.0)) {
            t1 = this.angleExtent;
        }
        return new EllipseArc2D(this.ellipse, t0, t1, this.angleExtent > 0.0);
    }

    @Override
    public double getDistance(Point2D point) {
        return this.getDistance(point.getX(), point.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        Point2D p = this.getPoint(this.project(new Point2D(x, y)));
        return p.getDistance(x, y);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CurveSet2D<? extends EllipseArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curve2DUtils.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<EllipseArc2D> result = new CurveArray2D<EllipseArc2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof EllipseArc2D)) continue;
            result.addCurve((EllipseArc2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D getBoundingBox() {
        Point2D p0 = this.getFirstPoint();
        Point2D p1 = this.getLastPoint();
        double x0 = p0.getX();
        double y0 = p0.getY();
        double x1 = p1.getX();
        double y1 = p1.getY();
        double xmin = Math.min(x0, x1);
        double xmax = Math.max(x0, x1);
        double ymin = Math.min(y0, y1);
        double ymax = Math.max(y0, y1);
        Point2D center = this.ellipse.getCenter();
        double xc = center.getX();
        double yc = center.getY();
        if (Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, 1.5707963267948966 + this.ellipse.theta, this.angleExtent >= 0.0)) {
            ymax = Math.max(ymax, yc + this.ellipse.r1);
        }
        if (Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, 4.71238898038469 + this.ellipse.theta, this.angleExtent >= 0.0)) {
            ymin = Math.min(ymin, yc - this.ellipse.r1);
        }
        if (Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, this.ellipse.theta, this.angleExtent >= 0.0)) {
            xmax = Math.max(xmax, xc + this.ellipse.r2);
        }
        if (Angle2D.containsAngle(this.startAngle, this.startAngle + this.angleExtent, Math.PI + this.ellipse.theta, this.angleExtent >= 0.0)) {
            xmin = Math.min(xmin, xc - this.ellipse.r2);
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public EllipseArc2D transform(AffineTransform2D trans) {
        Ellipse2D ell = this.ellipse.transform(trans);
        if (!ell.isDirect()) {
            ell = ell.getReverseCurve();
        }
        double startPos = ell.project(this.getFirstPoint().transform(trans));
        double endPos = ell.project(this.getLastPoint().transform(trans));
        boolean direct = !(this.angleExtent > 0.0 ^ trans.isDirect());
        return new EllipseArc2D(ell, startPos, endPos, direct);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.getDistance(x, y) > 1.0E-12;
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        int nSeg = (int)Math.ceil(Math.abs(this.angleExtent) / 1.5707963267948966);
        nSeg = Math.min(nSeg, 4);
        double ext = this.angleExtent / (double)nSeg;
        double k = EllipseArc2D.btan(Math.abs(ext));
        int i = 0;
        while (i < nSeg) {
            double ti0 = Math.abs((double)i * ext);
            double ti1 = Math.abs((double)(i + 1) * ext);
            Point2D p1 = this.getPoint(ti0);
            Point2D p2 = this.getPoint(ti1);
            Vector2D v1 = this.getTangent(ti0).times(k);
            Vector2D v2 = this.getTangent(ti1).times(k);
            path.curveTo(p1.getX() + v1.getX(), p1.getY() + v1.getY(), p2.getX() - v2.getX(), p2.getY() - v2.getY(), p2.getX(), p2.getY());
            ++i;
        }
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        Point2D point = this.getFirstPoint();
        path.moveTo((float)point.getX(), (float)point.getY());
        path = this.appendPath(path);
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getGeneralPath());
    }

    private static double btan(double increment) {
        return 1.3333333333333333 * Math.sin(increment /= 2.0) / (1.0 + Math.cos(increment));
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EllipseArc2D)) {
            return false;
        }
        EllipseArc2D arc = (EllipseArc2D)obj;
        if (Math.abs(this.ellipse.xc - arc.ellipse.xc) > eps) {
            return false;
        }
        if (Math.abs(this.ellipse.yc - arc.ellipse.yc) > eps) {
            return false;
        }
        if (Math.abs(this.ellipse.r1 - arc.ellipse.r1) > eps) {
            return false;
        }
        if (Math.abs(this.ellipse.r2 - arc.ellipse.r2) > eps) {
            return false;
        }
        if (Math.abs(this.ellipse.theta - arc.ellipse.theta) > eps) {
            return false;
        }
        if (!Angle2D.equals(this.startAngle, arc.startAngle)) {
            return false;
        }
        return Angle2D.equals(this.angleExtent, arc.angleExtent);
    }

    public String toString() {
        Point2D center = this.ellipse.getCenter();
        return String.format(Locale.US, "EllipseArc2D(%7.2f,%7.2f,%7.2f,%7.2f,%7.5f,%7.5f,%7.5f)", center.getX(), center.getY(), this.ellipse.r1, this.ellipse.r2, this.ellipse.theta, this.startAngle, this.angleExtent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EllipseArc2D)) {
            return false;
        }
        EllipseArc2D arc = (EllipseArc2D)obj;
        if (Math.abs(this.ellipse.xc - arc.ellipse.xc) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ellipse.yc - arc.ellipse.yc) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ellipse.r1 - arc.ellipse.r1) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ellipse.r2 - arc.ellipse.r2) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.ellipse.theta - arc.ellipse.theta) > 1.0E-12) {
            return false;
        }
        if (!Angle2D.equals(this.startAngle, arc.startAngle)) {
            return false;
        }
        return Angle2D.equals(this.angleExtent, arc.angleExtent);
    }

    @Override
    public EllipseArc2D clone() {
        return new EllipseArc2D(this.ellipse, this.startAngle, this.angleExtent);
    }
}

