/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.awt.Graphics2D;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.Boundary2DUtils;
import math.geom2d.domain.Domain2D;

public class GenericDomain2D
implements Domain2D {
    protected Boundary2D boundary = null;

    public static GenericDomain2D create(Boundary2D boundary) {
        return new GenericDomain2D(boundary);
    }

    public GenericDomain2D(Boundary2D boundary) {
        this.boundary = boundary;
    }

    public Boundary2D getBoundary() {
        return this.boundary;
    }

    public Domain2D complement() {
        return new GenericDomain2D(this.boundary.getReverseCurve());
    }

    public double getDistance(Point2D p) {
        return Math.max(this.boundary.getSignedDistance(p.getX(), p.getY()), 0.0);
    }

    public double getDistance(double x, double y) {
        return Math.max(this.boundary.getSignedDistance(x, y), 0.0);
    }

    public boolean isBounded() {
        if (!this.boundary.isBounded()) {
            return false;
        }
        Box2D box = this.boundary.getBoundingBox();
        Point2D point = new Point2D(box.getMinX(), box.getMinY());
        return !this.boundary.isInside(point);
    }

    public boolean isEmpty() {
        return this.boundary.isEmpty() && !this.contains(0.0, 0.0);
    }

    public Domain2D clip(Box2D box) {
        return new GenericDomain2D(Boundary2DUtils.clipBoundary(this.getBoundary(), box));
    }

    public Box2D getBoundingBox() {
        if (this.isBounded()) {
            return this.boundary.getBoundingBox();
        }
        return Box2D.INFINITE_BOX;
    }

    public GenericDomain2D transform(AffineTransform2D trans) {
        Boundary2D transformed = this.boundary.transform(trans);
        if (!trans.isDirect()) {
            transformed = transformed.getReverseCurve();
        }
        return new GenericDomain2D(transformed);
    }

    public boolean contains(double x, double y) {
        return this.boundary.getSignedDistance(x, y) <= 0.0;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public void draw(Graphics2D g2) {
        this.boundary.draw(g2);
    }

    public void fill(Graphics2D g2) {
        this.boundary.fill(g2);
    }

    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericDomain2D)) {
            return false;
        }
        GenericDomain2D domain = (GenericDomain2D)obj;
        return this.boundary.almostEquals(domain.boundary, eps);
    }

    public String toString() {
        return "GenericDomain2D(boundary=" + this.boundary + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericDomain2D)) {
            return false;
        }
        GenericDomain2D domain = (GenericDomain2D)obj;
        return this.boundary.equals(domain.boundary);
    }
}

