/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.point;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import math.geom2d.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSet2DUtils {
    public static <T extends Point2D> boolean hasAdjacentMultipleVertices(List<T> points) {
        return PointSet2DUtils.hasAdjacentMultipleVertices(points, false);
    }

    public static <T extends Point2D> boolean hasAdjacentMultipleVertices(List<T> points, boolean closed) {
        Iterator<T> iter = points.iterator();
        Point2D previous = null;
        previous = closed ? (Point2D)points.get(points.size() - 1) : (Point2D)iter.next();
        while (iter.hasNext()) {
            Point2D current = (Point2D)iter.next();
            if (Point2D.getDistance(current, previous) < 1.0E-12) {
                return true;
            }
            previous = current;
        }
        return false;
    }

    public static <T extends Point2D> int countAdjacentMultipleVertices(List<T> points) {
        return PointSet2DUtils.countAdjacentMultipleVertices(points, false);
    }

    public static <T extends Point2D> int countAdjacentMultipleVertices(List<T> points, boolean closed) {
        int count = 0;
        Iterator<T> iter = points.iterator();
        Point2D previous = null;
        previous = closed ? (Point2D)points.get(points.size() - 1) : (Point2D)iter.next();
        while (iter.hasNext()) {
            Point2D current = (Point2D)iter.next();
            if (Point2D.getDistance(current, previous) < 1.0E-12) {
                ++count;
            }
            previous = current;
        }
        return count;
    }

    public static <T extends Point2D> List<T> filterAdjacentMultipleVertices(List<T> vertices) {
        return PointSet2DUtils.filterAdjacentMultipleVertices(vertices, false);
    }

    public static <T extends Point2D> List<T> filterAdjacentMultipleVertices(List<T> vertices, boolean closed) {
        int size = vertices.size();
        int nMulti = PointSet2DUtils.countAdjacentMultipleVertices(vertices, closed);
        ArrayList<Point2D> result = new ArrayList<Point2D>(size - nMulti);
        if (size == 0) {
            return result;
        }
        Iterator<T> iter = vertices.iterator();
        Point2D previous = null;
        if (closed) {
            previous = (Point2D)vertices.get(size - 1);
        } else {
            previous = (Point2D)iter.next();
            result.add(previous);
        }
        while (iter.hasNext()) {
            Point2D current = (Point2D)iter.next();
            if (Point2D.getDistance(current, previous) > 1.0E-12) {
                result.add(current);
            }
            previous = current;
        }
        return result;
    }
}

