/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import com.seisw.util.geom.Poly;
import com.seisw.util.geom.PolyDefault;
import com.seisw.util.geom.PolySimple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.domain.Boundary2DUtils;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.point.PointSet2DUtils;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.MultiPolygon2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.SimplePolygon2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Polygon2DUtils {
    public static final SimplePolygon2D createCenteredRectangle(Point2D center, double length, double width) {
        double xc = center.getX();
        double yc = center.getY();
        double len = length / 2.0;
        double wid = width / 2.0;
        double x1 = xc - len;
        double y1 = yc - wid;
        double x2 = xc + len;
        double y2 = yc + wid;
        return new SimplePolygon2D(new Point2D(x1, y1), new Point2D(x2, y1), new Point2D(x2, y2), new Point2D(x1, y2));
    }

    public static final SimplePolygon2D createOrientedRectangle(Point2D center, double length, double width, double theta) {
        double xc = center.getX();
        double yc = center.getY();
        double len = length / 2.0;
        double wid = width / 2.0;
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        return new SimplePolygon2D(new Point2D(-len * cot + wid * sit + xc, -len * sit - wid * cot + yc), new Point2D(len * cot + wid * sit + xc, len * sit - wid * cot + yc), new Point2D(len * cot - wid * sit + xc, len * sit + wid * cot + yc), new Point2D(-len * cot - wid * sit + xc, -len * sit + wid * cot + yc));
    }

    public static final Point2D computeCentroid(Polygon2D polygon) {
        if (polygon instanceof SimplePolygon2D) {
            LinearRing2D ring = ((SimplePolygon2D)polygon).getRing();
            return Polygon2DUtils.computeCentroid(ring);
        }
        double xc = 0.0;
        double yc = 0.0;
        double cumArea = 0.0;
        for (LinearRing2D linearRing2D : polygon.getRings()) {
            double area = Polygon2DUtils.computeSignedArea(linearRing2D);
            Point2D centroid = Polygon2DUtils.computeCentroid(linearRing2D);
            xc += centroid.getX() * area;
            yc += centroid.getY() * area;
            cumArea += area;
        }
        return new Point2D(xc /= cumArea, yc /= cumArea);
    }

    public static final Point2D computeCentroid(LinearRing2D ring) {
        double xc = 0.0;
        double yc = 0.0;
        double tmp = 0.0;
        int n = ring.getVertexNumber();
        Point2D prev = ring.getVertex(n - 1);
        double xp = prev.getX();
        double yp = prev.getY();
        for (Point2D point : ring.getVertices()) {
            double x = point.getX();
            double y = point.getY();
            tmp = xp * y - yp * x;
            xc += (x + xp) * tmp;
            yc += (y + yp) * tmp;
            prev = point;
            xp = x;
            yp = y;
        }
        double denom = Polygon2DUtils.computeSignedArea(ring) * 6.0;
        return new Point2D(xc / denom, yc / denom);
    }

    public static final double computeSignedArea(Polygon2D polygon) {
        if (polygon instanceof SimplePolygon2D) {
            LinearRing2D ring = ((SimplePolygon2D)polygon).getRing();
            return Polygon2DUtils.computeSignedArea(ring);
        }
        double area = 0.0;
        for (LinearRing2D linearRing2D : polygon.getRings()) {
            area += Polygon2DUtils.computeSignedArea(linearRing2D);
        }
        return area;
    }

    public static final double computeSignedArea(LinearRing2D ring) {
        double area = 0.0;
        int n = ring.getVertexNumber();
        Point2D prev = ring.getVertex(n - 1);
        for (Point2D point : ring.getVertices()) {
            area += prev.getX() * point.getY() - prev.getY() * point.getX();
            prev = point;
        }
        return area /= 2.0;
    }

    public static final int windingNumber(Collection<Point2D> vertices, Point2D point) {
        int wn = 0;
        Point2D previous = null;
        Iterator<Point2D> iterator = vertices.iterator();
        while (iterator.hasNext()) {
            Point2D vertex;
            previous = vertex = iterator.next();
        }
        double y1 = previous.getY();
        double y = point.getY();
        for (Point2D current : vertices) {
            double y2 = current.getY();
            if (y1 <= y) {
                if (y2 > y && Polygon2DUtils.isLeft(previous, current, point) > 0) {
                    ++wn;
                }
            } else if (y2 <= y && Polygon2DUtils.isLeft(previous, current, point) < 0) {
                --wn;
            }
            y1 = y2;
            previous = current;
        }
        return wn;
    }

    private static final int isLeft(Point2D p1, Point2D p2, Point2D pt) {
        double x = p1.getX();
        double y = p1.getY();
        return (int)Math.signum((p2.getX() - x) * (pt.getY() - y) - (pt.getX() - x) * (p2.getY() - y));
    }

    public static final CirculinearDomain2D createBuffer(Polygon2D polygon, double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(polygon.getBoundary(), dist);
    }

    public static final Polygon2D clipPolygon(Polygon2D polygon, Box2D box) {
        CirculinearContourArray2D<? extends LinearRing2D> boundary = polygon.getBoundary();
        ContourArray2D<Contour2D> contours = Boundary2DUtils.clipBoundary(boundary, box);
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>();
        for (Contour2D contour : contours) {
            rings.add(Polygon2DUtils.convertContourToLinearRing(contour));
        }
        if (rings.size() == 1) {
            return SimplePolygon2D.create(rings.get(0).getVertices());
        }
        return MultiPolygon2D.create(rings);
    }

    private static final LinearRing2D convertContourToLinearRing(Contour2D contour) {
        if (contour instanceof LinearRing2D) {
            return (LinearRing2D)contour;
        }
        List<Point2D> vertices = new ArrayList();
        for (Point2D v : contour.getSingularPoints()) {
            vertices.add(v);
        }
        vertices = PointSet2DUtils.filterAdjacentMultipleVertices(vertices, true);
        return LinearRing2D.create(vertices);
    }

    public static final Polygon2D union(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygon2DUtils.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygon2DUtils.convertToGpcjPolygon(polygon2);
        Poly result = poly1.union(poly2);
        return Polygon2DUtils.convertFromGpcjPolygon(result);
    }

    public static final Polygon2D intersection(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygon2DUtils.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygon2DUtils.convertToGpcjPolygon(polygon2);
        Poly result = poly1.intersection(poly2);
        return Polygon2DUtils.convertFromGpcjPolygon(result);
    }

    public static final Polygon2D exclusiveOr(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygon2DUtils.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygon2DUtils.convertToGpcjPolygon(polygon2);
        Poly result = poly1.xor(poly2);
        return Polygon2DUtils.convertFromGpcjPolygon(result);
    }

    public static final Polygon2D difference(Polygon2D polygon1, Polygon2D polygon2) {
        Poly poly1 = Polygon2DUtils.convertToGpcjPolygon(polygon1);
        Poly poly2 = Polygon2DUtils.convertToGpcjPolygon(polygon2);
        Poly result = poly1.difference(poly2);
        return Polygon2DUtils.convertFromGpcjPolygon(result);
    }

    private static final Poly convertToGpcjPolygon(Polygon2D polygon) {
        PolyDefault result = new PolyDefault();
        for (LinearRing2D linearRing2D : polygon.getRings()) {
            result.add((Poly)Polygon2DUtils.convertToGpcjSimplePolygon(linearRing2D));
        }
        return result;
    }

    private static final PolySimple convertToGpcjSimplePolygon(LinearRing2D ring) {
        PolySimple poly = new PolySimple();
        for (Point2D point : ring.getVertices()) {
            poly.add((java.awt.geom.Point2D)point.getAsDouble());
        }
        return poly;
    }

    private static final Polygon2D convertFromGpcjPolygon(Poly poly) {
        int n = poly.getNumInnerPoly();
        if (n == 1) {
            Point2D[] points = Polygon2DUtils.extractPolyVertices(poly.getInnerPoly(0));
            return SimplePolygon2D.create(points);
        }
        LinearRing2D[] rings = new LinearRing2D[n];
        int i = 0;
        while (i < n) {
            rings[i] = Polygon2DUtils.convertFromGpcjSimplePolygon(poly.getInnerPoly(i));
            ++i;
        }
        return MultiPolygon2D.create(rings);
    }

    private static final LinearRing2D convertFromGpcjSimplePolygon(Poly poly) {
        return LinearRing2D.create(Polygon2DUtils.extractPolyVertices(poly));
    }

    private static final Point2D[] extractPolyVertices(Poly poly) {
        int n = poly.getNumPoints();
        Point2D[] points = new Point2D[n];
        int i = 0;
        while (i < n) {
            points[i] = Point2D.create(poly.getX(i), poly.getY(i));
            ++i;
        }
        return points;
    }
}

