/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearDomain2DUtils;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.point.PointSet2DUtils;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polygon2DUtils;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePolygon2D
implements Polygon2D {
    protected ArrayList<Point2D> vertices;

    public static SimplePolygon2D create(Collection<? extends Point2D> points) {
        return new SimplePolygon2D(points);
    }

    public static SimplePolygon2D create(Point2D ... points) {
        return new SimplePolygon2D(points);
    }

    public SimplePolygon2D() {
        this.vertices = new ArrayList();
    }

    public SimplePolygon2D(Point2D ... vertices) {
        this.vertices = new ArrayList(vertices.length);
        Point2D[] point2DArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D vertex = point2DArray[n2];
            this.vertices.add(vertex);
            ++n2;
        }
    }

    public SimplePolygon2D(double[] xcoords, double[] ycoords) {
        this.vertices = new ArrayList(xcoords.length);
        int i = 0;
        while (i < xcoords.length) {
            this.vertices.add(new Point2D(xcoords[i], ycoords[i]));
            ++i;
        }
    }

    public SimplePolygon2D(Collection<? extends Point2D> points) {
        this.vertices = new ArrayList(points.size());
        this.vertices.addAll(points);
    }

    public SimplePolygon2D(LinearRing2D ring) {
        this.vertices = new ArrayList(ring.getVertexNumber());
        this.vertices.addAll(ring.getVertices());
    }

    public int getWindingNumber(double x, double y) {
        return Polygon2DUtils.windingNumber(this.vertices, new Point2D(x, y));
    }

    @Deprecated
    public LinearRing2D getLinearRing() {
        return new LinearRing2D(this.vertices);
    }

    public LinearRing2D getRing() {
        return new LinearRing2D(this.vertices);
    }

    public boolean addVertex(Point2D point) {
        return this.vertices.add(point);
    }

    public void insertVertex(int index, Point2D point) {
        this.vertices.add(index, point);
    }

    public boolean removeVertex(Point2D point) {
        return this.vertices.remove(point);
    }

    public void removeVertex(int index) {
        this.vertices.remove(index);
    }

    public void clearVertices() {
        this.vertices.clear();
    }

    public void setVertex(int index, Point2D position) {
        this.vertices.set(index, position);
    }

    @Override
    public double getArea() {
        return Math.abs(this.getSignedArea());
    }

    @Override
    public double getSignedArea() {
        return Polygon2DUtils.computeSignedArea(this);
    }

    @Override
    public Point2D getCentroid() {
        return Polygon2DUtils.computeCentroid(this);
    }

    @Override
    public Collection<Point2D> getVertices() {
        return this.vertices;
    }

    @Override
    public Point2D getVertex(int i) {
        return this.vertices.get(i);
    }

    @Override
    public int getVertexNumber() {
        return this.vertices.size();
    }

    public Collection<LineSegment2D> getEdges() {
        int nPoints = this.vertices.size();
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(nPoints);
        if (nPoints == 0) {
            return edges;
        }
        int i = 0;
        while (i < nPoints - 1) {
            edges.add(new LineSegment2D(this.vertices.get(i), this.vertices.get(i + 1)));
            ++i;
        }
        edges.add(new LineSegment2D(this.vertices.get(nPoints - 1), this.vertices.get(0)));
        return edges;
    }

    @Override
    public int getEdgeNumber() {
        return this.vertices.size();
    }

    public Collection<LinearRing2D> getRings() {
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>(1);
        rings.add(new LinearRing2D(this.vertices));
        return rings;
    }

    @Override
    public CirculinearDomain2D transform(CircleInversion2D inv) {
        Curve2D boundary = ((CirculinearContourArray2D)((CirculinearContourArray2D)this.getBoundary()).transform(inv)).getReverseCurve();
        return new GenericCirculinearDomain2D((CirculinearBoundary2D)boundary);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        if (PointSet2DUtils.hasAdjacentMultipleVertices(this.vertices, true)) {
            List<Point2D> pts2 = PointSet2DUtils.filterAdjacentMultipleVertices(this.vertices, true);
            SimplePolygon2D poly2 = new SimplePolygon2D(pts2);
            return CirculinearDomain2DUtils.computeBuffer(poly2, dist);
        }
        return CirculinearDomain2DUtils.computeBuffer(this, dist);
    }

    @Override
    public CirculinearContourArray2D<LinearRing2D> getBoundary() {
        Point2D[] array = new Point2D[this.vertices.size()];
        int i = 0;
        while (i < this.vertices.size()) {
            array[i] = this.vertices.get(i);
            ++i;
        }
        return new CirculinearContourArray2D<LinearRing2D>(new LinearRing2D(array));
    }

    @Override
    public SimplePolygon2D complement() {
        int nPoints = this.vertices.size();
        Point2D[] res = new Point2D[nPoints];
        if (nPoints > 0) {
            res[0] = this.vertices.get(0);
        }
        int i = 1;
        while (i < nPoints) {
            res[i] = this.vertices.get(nPoints - i);
            ++i;
        }
        return new SimplePolygon2D(res);
    }

    @Override
    public double getDistance(Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        if (this.contains(x, y)) {
            return 0.0;
        }
        return ((CurveArray2D)((Object)this.getBoundary())).getDistance(x, y);
    }

    public double getSignedDistance(Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    public double getSignedDistance(double x, double y) {
        double dist = ((CurveArray2D)((Object)this.getBoundary())).getDistance(x, y);
        if (this.contains(x, y)) {
            return -dist;
        }
        return dist;
    }

    @Override
    public Polygon2D clip(Box2D box) {
        return Polygon2DUtils.clipPolygon(this, box);
    }

    @Override
    public Box2D getBoundingBox() {
        return ((CurveArray2D)((Object)this.getBoundary())).getBoundingBox();
    }

    @Override
    public boolean isBounded() {
        return this.getSignedArea() > 0.0;
    }

    @Override
    public boolean isEmpty() {
        return this.vertices.size() == 0;
    }

    @Override
    public SimplePolygon2D transform(AffineTransform2D trans) {
        int nPoints = this.vertices.size();
        Point2D[] array = new Point2D[nPoints];
        Point2D[] res = new Point2D[nPoints];
        int i = 0;
        while (i < nPoints) {
            array[i] = this.vertices.get(i);
            res[i] = new Point2D();
            ++i;
        }
        trans.transform(array, res);
        SimplePolygon2D poly = new SimplePolygon2D(res);
        if (!trans.isDirect()) {
            poly = poly.complement();
        }
        return poly;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        if (((CurveArray2D)((Object)this.getBoundary())).contains(x, y)) {
            return true;
        }
        double area = this.getSignedArea();
        int winding = this.getWindingNumber(x, y);
        if (area > 0.0) {
            return winding == 1;
        }
        return winding == 0;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.vertices.size() < 2) {
            return path;
        }
        Point2D point = this.vertices.get(0);
        path.moveTo((float)point.getX(), (float)point.getY());
        int i = 0;
        while (i < this.vertices.size()) {
            point = this.vertices.get(i);
            path.lineTo((float)point.getX(), (float)point.getY());
            ++i;
        }
        point = this.vertices.get(0);
        path.lineTo((float)point.getX(), (float)point.getY());
        path.closePath();
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getGeneralPath());
    }

    @Override
    public void fill(Graphics2D g) {
        g.fill(this.getGeneralPath());
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimplePolygon2D)) {
            return false;
        }
        SimplePolygon2D polygon = (SimplePolygon2D)obj;
        int nv = this.getVertexNumber();
        if (polygon.getVertexNumber() != nv) {
            return false;
        }
        int i = 0;
        while (i < nv) {
            if (!this.getVertex(i).almostEquals(polygon.getVertex(i), eps)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimplePolygon2D)) {
            return false;
        }
        SimplePolygon2D polygon = (SimplePolygon2D)obj;
        int nv = this.getVertexNumber();
        if (polygon.getVertexNumber() != nv) {
            return false;
        }
        int i = 0;
        while (i < nv) {
            if (!this.getVertex(i).equals(polygon.getVertex(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public SimplePolygon2D clone() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(this.vertices.size());
        for (Point2D point : this.vertices) {
            array.add(point.clone());
        }
        return new SimplePolygon2D(array);
    }
}

