/*
 * Decompiled with CFR 0.152.
 */
package math.utils;

public class Matrix {
    private int nRows;
    private int nCols;
    private double[][] el;

    public Matrix() {
        this(1, 1);
    }

    public Matrix(int nbRows, int nbCols) {
        this.nRows = nbRows;
        this.nCols = nbCols;
        this.el = new double[this.nRows][this.nCols];
        this.setToIdentity();
    }

    public Matrix(double[][] coef) {
        if (coef == null) {
            this.nRows = 1;
            this.nCols = 1;
            this.el = new double[this.nRows][this.nCols];
            this.setToIdentity();
            return;
        }
        this.nRows = coef.length;
        this.nCols = coef[0].length;
        this.el = new double[this.nRows][this.nCols];
        int r = 0;
        while (r < this.nRows) {
            int c = 0;
            while (c < this.nCols) {
                this.el[r][c] = coef[r][c];
                ++c;
            }
            ++r;
        }
    }

    public double getCoef(int row, int col) {
        return this.el[row - 1][col - 1];
    }

    public int getRows() {
        return this.nRows;
    }

    public int getColumns() {
        return this.nCols;
    }

    public boolean isSquare() {
        return this.nCols == this.nRows;
    }

    public void setCoef(int row, int col, double coef) {
        this.el[row - 1][col - 1] = coef;
    }

    public Matrix multiplyWith(Matrix matrix) {
        if (this.nCols != matrix.nRows) {
            System.out.println("Matrices size don't match !");
            return null;
        }
        Matrix m = new Matrix(this.nRows, matrix.nCols);
        int r = 0;
        while (r < m.nRows) {
            int c = 0;
            while (c < m.nCols) {
                double sum = 0.0;
                int i = 0;
                while (i < this.nCols) {
                    sum += this.el[r][i] * matrix.el[i][c];
                    ++i;
                }
                m.el[r][c] = sum;
                ++c;
            }
            ++r;
        }
        return m;
    }

    public double[] multiplyWith(double[] coefs) {
        if (coefs == null) {
            System.out.println("no data to compute");
            return null;
        }
        if (coefs.length != this.nCols) {
            System.out.println("Matrices size don't match !");
            return null;
        }
        double[] res = new double[this.nRows];
        int r = 0;
        while (r < this.nRows) {
            double sum = 0.0;
            int c = 0;
            while (c < this.nCols) {
                sum += this.el[r][c] * coefs[c];
                ++c;
            }
            res[r] = sum;
            ++r;
        }
        return res;
    }

    public double[] multiplyWith(double[] src, double[] res) {
        if (src == null) {
            System.out.println("no data to compute");
            return null;
        }
        if (src.length != this.nCols) {
            System.out.println("Matrices size don't match !");
            return null;
        }
        if (src.length != res.length) {
            res = new double[this.nRows];
        }
        int r = 0;
        while (r < this.nRows) {
            double sum = 0.0;
            int c = 0;
            while (c < this.nCols) {
                sum += this.el[r][c] * src[c];
                ++c;
            }
            res[r] = sum;
            ++r;
        }
        return res;
    }

    public void transpose() {
        int tmp = this.nCols;
        this.nCols = this.nRows;
        this.nRows = tmp;
        double[][] oldData = this.el;
        this.el = new double[this.nRows][this.nCols];
        int r = 0;
        while (r < this.nRows) {
            int c = 0;
            while (c < this.nCols) {
                this.el[r][c] = oldData[c][r];
                ++c;
            }
            ++r;
        }
    }

    public Matrix getTranspose() {
        Matrix mat = new Matrix(this.nCols, this.nRows);
        int r = 0;
        while (r < this.nRows) {
            int c = 0;
            while (c < this.nCols) {
                mat.el[c][r] = this.el[r][c];
                ++c;
            }
            ++r;
        }
        return mat;
    }

    public double[] solve(double[] vector) {
        if (vector == null) {
            throw new NullPointerException();
        }
        if (vector.length != this.nRows) {
            System.out.println("matrix and vector dimensions do not match!");
            return null;
        }
        if (this.nCols != this.nRows) {
            System.out.println("Try to invert non square Matrix.");
            return null;
        }
        double[] res = new double[vector.length];
        int i = 0;
        while (i < this.nRows) {
            res[i] = vector[i];
            ++i;
        }
        Matrix mat = new Matrix(this.el);
        int r = 0;
        while (r < this.nRows) {
            double tmp;
            int p = r;
            while (Math.abs(mat.el[p][r]) < 1.0E-15 && p <= this.nRows) {
                ++p;
            }
            if (p == this.nRows) {
                System.out.println("Degenerated linear system :");
                return null;
            }
            int c = 0;
            while (c < this.nRows) {
                tmp = mat.el[r][c];
                mat.el[r][c] = mat.el[p][c];
                mat.el[p][c] = tmp;
                ++c;
            }
            tmp = res[r];
            res[r] = res[p];
            res[p] = tmp;
            double pivot = mat.el[r][r];
            c = r + 1;
            while (c < this.nRows) {
                double[] dArray = mat.el[r];
                int n = c++;
                dArray[n] = dArray[n] / pivot;
            }
            int n = r;
            res[n] = res[n] / pivot;
            mat.el[r][r] = 1.0;
            int r2 = 0;
            while (r2 < r) {
                pivot = mat.el[r2][r];
                c = r + 1;
                while (c < this.nRows) {
                    double[] dArray = mat.el[r2];
                    int n2 = c;
                    dArray[n2] = dArray[n2] - pivot * mat.el[r][c];
                    ++c;
                }
                int n3 = r2;
                res[n3] = res[n3] - pivot * res[r];
                mat.el[r2][r] = 0.0;
                ++r2;
            }
            r2 = r + 1;
            while (r2 < this.nRows) {
                pivot = mat.el[r2][r];
                c = r + 1;
                while (c < this.nRows) {
                    double[] dArray = mat.el[r2];
                    int n4 = c;
                    dArray[n4] = dArray[n4] - pivot * mat.el[r][c];
                    ++c;
                }
                int n5 = r2;
                res[n5] = res[n5] - pivot * res[r];
                mat.el[r2][r] = 0.0;
                ++r2;
            }
            ++r;
        }
        return res;
    }

    public void setToIdentity() {
        int r = 0;
        while (r < this.nRows) {
            int c = 0;
            while (c < this.nCols) {
                this.el[r][c] = 0.0;
                ++c;
            }
            ++r;
        }
        int i = Math.min(this.nRows, this.nCols) - 1;
        while (i >= 0) {
            this.el[i][i] = 1.0;
            --i;
        }
    }

    public String toString() {
        String res = new String("");
        res = res.concat("Matrix size : " + Integer.toString(this.nRows) + " rows and " + Integer.toString(this.nCols) + " columns.\n");
        int r = 0;
        while (r < this.nRows) {
            int c = 0;
            while (c < this.nCols) {
                res = res.concat(Double.toString(this.el[r][c])).concat(" ");
                ++c;
            }
            res = res.concat(new String("\n"));
            ++r;
        }
        return res;
    }
}

