/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.bulletphysics.dynamics.constraintsolver.ConeTwistConstraint;
import com.bulletphysics.linearmath.Transform;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.Converter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;

public class ConeJoint
extends PhysicsJoint {
    protected Matrix3f rotA;
    protected Matrix3f rotB;
    protected float swingSpan1 = 1.0E30f;
    protected float swingSpan2 = 1.0E30f;
    protected float twistSpan = 1.0E30f;
    protected boolean angularOnly = false;

    public ConeJoint() {
    }

    public ConeJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public ConeJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Matrix3f rotA, Matrix3f rotB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = rotA;
        this.rotB = rotB;
        this.createJoint();
    }

    public void setLimit(float swingSpan1, float swingSpan2, float twistSpan) {
        this.swingSpan1 = swingSpan1;
        this.swingSpan2 = swingSpan2;
        this.twistSpan = twistSpan;
        ((ConeTwistConstraint)this.constraint).setLimit(swingSpan1, swingSpan2, twistSpan);
    }

    public void setAngularOnly(boolean value) {
        this.angularOnly = value;
        ((ConeTwistConstraint)this.constraint).setAngularOnly(value);
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.rotA, "rotA", (Savable)new Matrix3f());
        capsule.write((Savable)this.rotB, "rotB", (Savable)new Matrix3f());
        capsule.write(this.angularOnly, "angularOnly", false);
        capsule.write(this.swingSpan1, "swingSpan1", 1.0E30f);
        capsule.write(this.swingSpan2, "swingSpan2", 1.0E30f);
        capsule.write(this.twistSpan, "twistSpan", 1.0E30f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.rotA = (Matrix3f)capsule.readSavable("rotA", (Savable)new Matrix3f());
        this.rotB = (Matrix3f)capsule.readSavable("rotB", (Savable)new Matrix3f());
        this.angularOnly = capsule.readBoolean("angularOnly", false);
        this.swingSpan1 = capsule.readFloat("swingSpan1", 1.0E30f);
        this.swingSpan2 = capsule.readFloat("swingSpan2", 1.0E30f);
        this.twistSpan = capsule.readFloat("twistSpan", 1.0E30f);
        this.createJoint();
    }

    protected void createJoint() {
        Transform transA = new Transform(Converter.convert(this.rotA));
        Converter.convert(this.pivotA, transA.origin);
        Converter.convert(this.rotA, transA.basis);
        Transform transB = new Transform(Converter.convert(this.rotB));
        Converter.convert(this.pivotB, transB.origin);
        Converter.convert(this.rotB, transB.basis);
        this.constraint = new ConeTwistConstraint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), transA, transB);
        ((ConeTwistConstraint)this.constraint).setLimit(this.swingSpan1, this.swingSpan2, this.twistSpan);
        ((ConeTwistConstraint)this.constraint).setAngularOnly(this.angularOnly);
    }
}

