/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.util;

import com.jme3.bounding.BoundingBox;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.CompoundCollisionShape;
import com.jme3.bullet.collision.shapes.HeightfieldCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.infos.ChildCollisionShape;
import com.jme3.math.Matrix3f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.terrain.geomipmap.TerrainPatch;
import com.jme3.terrain.geomipmap.TerrainQuad;
import java.util.LinkedList;

public class CollisionShapeFactory {
    private static Transform getTransform(Spatial spat, Spatial parent) {
        Transform shapeTransform = new Transform();
        Spatial parentNode = spat.getParent() != null ? spat.getParent() : spat;
        Spatial currentSpatial = spat;
        while (parentNode != null) {
            if (parent == currentSpatial) {
                Transform trans = new Transform();
                trans.setScale(currentSpatial.getLocalScale());
                shapeTransform.combineWithParent(trans);
                parentNode = null;
                continue;
            }
            shapeTransform.combineWithParent(currentSpatial.getLocalTransform());
            currentSpatial = parentNode = currentSpatial.getParent();
        }
        return shapeTransform;
    }

    private static CompoundCollisionShape createCompoundShape(Node realRootNode, Node rootNode, CompoundCollisionShape shape, boolean meshAccurate, boolean dynamic) {
        for (Spatial spatial : rootNode.getChildren()) {
            Transform trans;
            TerrainQuad terrain;
            Boolean bool;
            if (spatial instanceof TerrainQuad) {
                bool = (Boolean)spatial.getUserData("JmePhysicsIgnore");
                if (bool != null && bool.booleanValue()) continue;
                terrain = (TerrainQuad)spatial;
                trans = CollisionShapeFactory.getTransform(spatial, (Spatial)realRootNode);
                shape.addChildShape(new HeightfieldCollisionShape(terrain.getHeightMap(), trans.getScale()), trans.getTranslation(), trans.getRotation().toRotationMatrix());
                continue;
            }
            if (spatial instanceof Node) {
                CollisionShapeFactory.createCompoundShape(realRootNode, (Node)spatial, shape, meshAccurate, dynamic);
                continue;
            }
            if (spatial instanceof TerrainPatch) {
                bool = (Boolean)spatial.getUserData("JmePhysicsIgnore");
                if (bool != null && bool.booleanValue()) continue;
                terrain = (TerrainPatch)spatial;
                trans = CollisionShapeFactory.getTransform(spatial, (Spatial)realRootNode);
                shape.addChildShape(new HeightfieldCollisionShape(terrain.getHeightMap(), terrain.getLocalScale()), trans.getTranslation(), trans.getRotation().toRotationMatrix());
                continue;
            }
            if (!(spatial instanceof Geometry) || (bool = (Boolean)spatial.getUserData("JmePhysicsIgnore")) != null && bool.booleanValue()) continue;
            if (meshAccurate) {
                CollisionShape childShape = dynamic ? CollisionShapeFactory.createSingleDynamicMeshShape((Geometry)spatial, (Spatial)realRootNode) : CollisionShapeFactory.createSingleMeshShape((Geometry)spatial, (Spatial)realRootNode);
                if (childShape == null) continue;
                trans = CollisionShapeFactory.getTransform(spatial, (Spatial)realRootNode);
                shape.addChildShape(childShape, trans.getTranslation(), trans.getRotation().toRotationMatrix());
                continue;
            }
            Transform trans2 = CollisionShapeFactory.getTransform(spatial, (Spatial)realRootNode);
            shape.addChildShape(CollisionShapeFactory.createSingleBoxShape(spatial, (Spatial)realRootNode), trans2.getTranslation(), trans2.getRotation().toRotationMatrix());
        }
        return shape;
    }

    private static CompoundCollisionShape createCompoundShape(Node rootNode, CompoundCollisionShape shape, boolean meshAccurate) {
        return CollisionShapeFactory.createCompoundShape(rootNode, rootNode, shape, meshAccurate, false);
    }

    private static CompoundCollisionShape createMeshCompoundShape(Node rootNode) {
        return CollisionShapeFactory.createCompoundShape(rootNode, new CompoundCollisionShape(), true);
    }

    private static CompoundCollisionShape createBoxCompoundShape(Node rootNode) {
        return CollisionShapeFactory.createCompoundShape(rootNode, new CompoundCollisionShape(), false);
    }

    public static CollisionShape createMeshShape(Spatial spatial) {
        if (spatial instanceof TerrainQuad) {
            TerrainQuad terrain = (TerrainQuad)spatial;
            return new HeightfieldCollisionShape(terrain.getHeightMap(), terrain.getLocalScale());
        }
        if (spatial instanceof TerrainPatch) {
            TerrainPatch terrain = (TerrainPatch)spatial;
            return new HeightfieldCollisionShape(terrain.getHeightMap(), terrain.getLocalScale());
        }
        if (spatial instanceof Geometry) {
            return CollisionShapeFactory.createSingleMeshShape((Geometry)spatial, spatial);
        }
        if (spatial instanceof Node) {
            return CollisionShapeFactory.createMeshCompoundShape((Node)spatial);
        }
        throw new IllegalArgumentException("Supplied spatial must either be Node or Geometry!");
    }

    public static CollisionShape createDynamicMeshShape(Spatial spatial) {
        if (spatial instanceof Geometry) {
            return CollisionShapeFactory.createSingleDynamicMeshShape((Geometry)spatial, spatial);
        }
        if (spatial instanceof Node) {
            return CollisionShapeFactory.createCompoundShape((Node)spatial, (Node)spatial, new CompoundCollisionShape(), true, true);
        }
        throw new IllegalArgumentException("Supplied spatial must either be Node or Geometry!");
    }

    public static CollisionShape createBoxShape(Spatial spatial) {
        if (spatial instanceof Geometry) {
            return CollisionShapeFactory.createSingleBoxShape((Spatial)((Geometry)spatial), spatial);
        }
        if (spatial instanceof Node) {
            return CollisionShapeFactory.createBoxCompoundShape((Node)spatial);
        }
        throw new IllegalArgumentException("Supplied spatial must either be Node or Geometry!");
    }

    private static MeshCollisionShape createSingleMeshShape(Geometry geom, Spatial parent) {
        Mesh mesh = geom.getMesh();
        Transform trans = CollisionShapeFactory.getTransform((Spatial)geom, parent);
        if (mesh != null) {
            MeshCollisionShape mColl = new MeshCollisionShape(mesh);
            mColl.setScale(trans.getScale());
            return mColl;
        }
        return null;
    }

    private static BoxCollisionShape createSingleBoxShape(Spatial spatial, Spatial parent) {
        BoxCollisionShape shape = new BoxCollisionShape(((BoundingBox)spatial.getWorldBound()).getExtent(new Vector3f()));
        return shape;
    }

    private static HullCollisionShape createSingleDynamicMeshShape(Geometry geom, Spatial parent) {
        Mesh mesh = geom.getMesh();
        Transform trans = CollisionShapeFactory.getTransform((Spatial)geom, parent);
        if (mesh != null) {
            HullCollisionShape dynamicShape = new HullCollisionShape(mesh);
            dynamicShape.setScale(trans.getScale());
            return dynamicShape;
        }
        return null;
    }

    public static void shiftCompoundShapeContents(CompoundCollisionShape compoundShape, Vector3f vector) {
        for (ChildCollisionShape childCollisionShape : new LinkedList<ChildCollisionShape>(compoundShape.getChildren())) {
            CollisionShape child = childCollisionShape.shape;
            Vector3f location = childCollisionShape.location;
            Matrix3f rotation = childCollisionShape.rotation;
            compoundShape.removeChildShape(child);
            compoundShape.addChildShape(child, location.add(vector), rotation);
        }
    }
}

