/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.ElementBuilder;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.button.builder.ButtonBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;

public class MessageBox
extends AbstractController {
    private String[] buttonCaptions;
    private MessageType messageType = MessageType.INFO;
    private NiftyImage icon;
    private String message;
    private String buttonWidth = "100px";
    private String buttonHeight = "25px";
    private Nifty nifty;
    private Element messageboxPopup;
    private MessageBox msgBox;

    public MessageBox() {
    }

    public MessageBox(Nifty nifty, MessageType messageType, String message, String buttonCaption, String icon) {
        this.nifty = nifty;
        this.messageboxPopup = nifty.createPopup("niftyPopupMessageBox");
        this.msgBox = (MessageBox)this.messageboxPopup.findNiftyControl("#messagebox", MessageBox.class);
        this.msgBox.setMessageType(messageType);
        this.msgBox.setMessage(message);
        this.msgBox.setButtonCaption(buttonCaption);
        this.msgBox.setIcon(icon);
        this.msgBox.setupMessageBox();
    }

    public MessageBox(Nifty nifty, MessageType messageType, String message, String buttonCaption) {
        this(nifty, messageType, message, buttonCaption, null);
    }

    public MessageBox(Nifty nifty, MessageType messageType, String message, String[] buttonCaptions, String icon) {
        this.nifty = nifty;
        this.messageboxPopup = nifty.createPopup("niftyPopupMessageBox");
        this.msgBox = (MessageBox)this.messageboxPopup.findNiftyControl("#messagebox", MessageBox.class);
        this.msgBox.setMessageType(messageType);
        this.msgBox.setMessage(message);
        this.msgBox.setButtonCaptions(buttonCaptions);
        this.msgBox.setIcon(icon);
        this.msgBox.setupMessageBox();
    }

    public MessageBox(Nifty nifty, MessageType messageType, String message, String[] buttonCaptions) {
        this(nifty, messageType, message, buttonCaptions, null);
    }

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        System.out.println("binding MessageBox");
        this.messageboxPopup = element;
        this.nifty = nifty;
        if (controlDefinitionAttributes.isSet("buttonCaptions")) {
            this.setButtonCaptions(controlDefinitionAttributes.get("buttonCaptions").split(","));
        } else if (controlDefinitionAttributes.isSet("buttonCaption")) {
            this.setButtonCaption(controlDefinitionAttributes.get("buttonCaption"));
        }
        if (this.messageType != MessageType.CUSTOM) {
            this.setIcon("messagebox/" + this.messageType.name() + ".png");
        }
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    public void show() {
        this.nifty.showPopup(this.nifty.getCurrentScreen(), this.messageboxPopup.getId(), null);
    }

    public void close(String command) {
        this.closeMessageBox(command);
        this.nifty.closePopup(this.messageboxPopup.getParent().getId());
    }

    public void setIcon(String icon) {
        if (icon != null) {
            this.icon = this.nifty.createImage(icon, false);
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setButtonCaption(String buttonCaption) {
        this.buttonCaptions = new String[]{buttonCaption};
    }

    public void setButtonCaptions(String[] buttonCaptions) {
        this.buttonCaptions = buttonCaptions;
    }

    public void setButtonCaptions(String buttonCaptions) {
        this.buttonCaptions = buttonCaptions.split(",");
    }

    public void setMessageType(String messageType) {
        this.messageType = MessageType.valueOf(messageType);
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    private void setupMessageBox() {
        Element imgIcon = this.messageboxPopup.findElementByName("#messagebox").findElementByName("#message-icon");
        ImageRenderer iconRenderer = (ImageRenderer)imgIcon.getRenderer(ImageRenderer.class);
        iconRenderer.setImage(this.icon);
        Element text = this.messageboxPopup.findElementByName("#messagebox").findElementByName("#message-text");
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        textRenderer.setText(this.message);
        int i = 0;
        for (String buttonCaption : this.buttonCaptions) {
            this.createButton(buttonCaption, buttonCaption, "button_" + ++i);
        }
        this.messageboxPopup.findElementByName("#messagebox").layoutElements();
        this.nifty.getCurrentScreen().layoutLayers();
    }

    private void closeMessageBox(String command) {
        this.clearButtons();
        this.nifty.getCurrentScreen().layoutLayers();
    }

    private void createButton(final String buttonCaption, final String command, String buttonId) {
        Element buttonPanel = this.messageboxPopup.findElementByName("#messagebox").findElementByName("#buttons");
        if (buttonPanel.findElementByName("#" + buttonId) == null) {
            new ButtonBuilder("#" + buttonId){
                {
                    super(x0);
                    this.style("nifty-button");
                    this.childLayout(ElementBuilder.ChildLayoutType.Horizontal);
                    this.interactOnClick("close(" + command + ")");
                    if (MessageBox.this.buttonWidth != null) {
                        this.width(MessageBox.this.buttonWidth);
                    }
                    if (MessageBox.this.buttonHeight != null) {
                        this.height(MessageBox.this.buttonHeight);
                    } else {
                        this.height("25px");
                    }
                    this.label(buttonCaption);
                }
            }.build(this.nifty, this.nifty.getCurrentScreen(), buttonPanel);
        }
    }

    private void clearButtons() {
        List buttons = this.messageboxPopup.findElementByName("#messagebox").findElementByName("#buttons").getElements();
        for (Element button : buttons) {
            button.markForRemoval();
        }
    }

    protected Element getMessageBoxPopup() {
        return this.messageboxPopup;
    }

    public static enum MessageType {
        CUSTOM,
        INFO,
        WARNING,
        ERROR;

    }
}

