/*
 * Decompiled with CFR 0.152.
 */
package furny;

import com.jme3.system.AppSettings;
import furny.furndb.FurnCache;
import furny.furndb.FurnDBManager;
import furny.ga.logger.StatisticsDBManager;
import furny.swing.admin.FurnDBAdminTool;
import furny.swing.admin.genotype.GenotypeTool;
import furny.swing.admin.statistics.StatisticsTool;
import furny.util.LoggerUtil;
import ga.view.MTIEvaluator;
import ga.view.config.SettingsDialog2;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Furny {
    private static final Logger LOGGER = LoggerFactory.getLogger(Furny.class);

    private Furny() {
    }

    public static void main(String[] args) {
        LoggerUtil.installLogger();
        java.util.logging.Logger.getLogger("org.hibernate").setLevel(Level.WARNING);
        String quality = null;
        String gaSettingsFileName = "furny/settings/FurnyGA.xml";
        String customFurnDBFileName = null;
        String customStatisticsDBFileName = null;
        String customSettingsFileName = null;
        boolean showDialog = false;
        boolean doVerbose = false;
        boolean startAdmin = false;
        boolean startStatistics = false;
        boolean startGenotypeTool = false;
        for (String arg : args) {
            if (arg.equals("-h") || arg.equals("--help")) {
                Furny.showHelp();
                return;
            }
            if (arg.equals("-d") || arg.equals("--dialog")) {
                showDialog = true;
                continue;
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                doVerbose = true;
                continue;
            }
            if (arg.equals("-a") || arg.equals("--admin")) {
                startAdmin = true;
                continue;
            }
            if (arg.equals("-s") || arg.equals("--statistics")) {
                startStatistics = true;
                continue;
            }
            if (arg.equals("-g") || arg.equals("--genotype")) {
                startGenotypeTool = true;
                continue;
            }
            if (arg.startsWith("-q=") || arg.startsWith("--quality=")) {
                quality = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.startsWith("-vs=") || arg.startsWith("--viewsettings=")) {
                customSettingsFileName = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.startsWith("-f=") || arg.startsWith("--file=")) {
                gaSettingsFileName = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.startsWith("-db=") || arg.startsWith("--database=")) {
                customFurnDBFileName = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            if (arg.startsWith("-sdb=") || arg.startsWith("--statisticsdatabase=")) {
                customStatisticsDBFileName = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            LOGGER.warn("Unknown parameter: " + arg);
            Furny.showHelp();
            return;
        }
        if (doVerbose) {
            java.util.logging.Logger.getLogger("").setLevel(Level.INFO);
            java.util.logging.Logger.getLogger("org.hibernate").setLevel(Level.INFO);
            LOGGER.info("Using verbose output");
        } else {
            LoggerUtil.muteRootLogger();
        }
        if (customFurnDBFileName != null) {
            FurnDBManager.getInstance().setCustomFilename(customFurnDBFileName);
        }
        if (customStatisticsDBFileName != null) {
            StatisticsDBManager.getInstance().setCustomFilename(customStatisticsDBFileName);
        }
        if (startAdmin) {
            FurnDBAdminTool.start();
        } else if (startStatistics) {
            StatisticsTool.start();
        } else if (startGenotypeTool) {
            GenotypeTool.start();
        } else {
            int qualitylevel;
            if (quality == null) {
                qualitylevel = 0;
            } else {
                try {
                    qualitylevel = Integer.valueOf(quality);
                    LOGGER.info("Using quality level " + qualitylevel);
                }
                catch (Exception e) {
                    qualitylevel = 0;
                    LOGGER.warn("Unparseable quality level: " + quality);
                    LOGGER.warn("Set quality with \"-q n\" or \"--quality=n\"");
                }
            }
            String settingsFileName = customSettingsFileName != null ? customSettingsFileName : "furny/view/settings" + qualitylevel + ".properties";
            URL url = Furny.class.getClassLoader().getResource(settingsFileName);
            File settingsFile = null;
            try {
                settingsFile = new File(url.toURI());
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                settingsFile = new File(settingsFileName);
            }
            if (settingsFile != null && settingsFile.exists()) {
                if (!settingsFile.isFile()) {
                    LOGGER.warn("Settings file is no file: " + settingsFileName + ", check your parameters!");
                    LOGGER.warn("Using default settings");
                }
            } else {
                LOGGER.warn("Settings file not found: " + settingsFileName + ", check your parameters!");
                LOGGER.warn("Using default settings");
            }
            url = Furny.class.getClassLoader().getResource(gaSettingsFileName);
            File gaSettings = null;
            try {
                gaSettings = new File(url.toURI());
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            catch (Exception e1) {
                gaSettings = new File(gaSettingsFileName);
            }
            if (gaSettings != null && gaSettings.exists()) {
                if (!gaSettings.isFile()) {
                    LOGGER.warn("GA Settings file is no file: " + gaSettingsFileName + ", check your parameters!");
                    Furny.showHelp();
                    return;
                }
            } else {
                LOGGER.warn("GA Settings file not found: " + gaSettingsFileName + ", check your parameters!");
                Furny.showHelp();
                return;
            }
            FurnCache.getInstance();
            final MTIEvaluator app = new MTIEvaluator(gaSettings);
            final AppSettings settings = new AppSettings(true);
            settings.setResolution(1280, 1024);
            try {
                FileInputStream is = new FileInputStream(settingsFile);
                settings.load((InputStream)is);
                ((InputStream)is).close();
            }
            catch (Exception e) {
                settings.setResolution(1024, 768);
                settings.put((Object)"ShowCursor", (Object)Boolean.TRUE);
            }
            if (showDialog) {
                final String fCustomSettingsFileName = customSettingsFileName;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final SettingsDialog2 sd = new SettingsDialog2(settings, (URL)null, false);
                        sd.setFileToSave(fCustomSettingsFileName);
                        SettingsDialog2.SelectionListener sl = new SettingsDialog2.SelectionListener(){

                            @Override
                            public void onSelection(int selection) {
                                sd.dispose();
                                if (selection == 1) {
                                    app.setSettings(settings);
                                    app.setShowSettings(false);
                                    LOGGER.debug("Starting evaluator");
                                    app.start();
                                }
                            }
                        };
                        sd.setSelectionListener(sl);
                        sd.showDialog();
                    }
                });
            } else {
                app.setSettings(settings);
                app.setShowSettings(false);
                LOGGER.debug("Starting evaluator");
                app.start();
            }
        }
    }

    private static void showHelp() {
        System.err.println();
        System.out.println("Furny main class for interactive genetic algorithms.");
        System.out.println();
        System.out.println("Parameters");
        System.out.println();
        System.out.println("-h");
        System.out.println("--help");
        System.out.println("    Show this help page.");
        System.out.println();
        System.out.println("-v");
        System.out.println("--verbose");
        System.out.println("    Print verbose output to console.");
        System.out.println();
        System.out.println("-d");
        System.out.println("--dialog");
        System.out.println("    Show the settings dialog before starting the application.");
        System.out.println("    The dialog allows to set resolution, display frequency");
        System.out.println("    and fullscreen mode.");
        System.out.println();
        System.out.println("-a");
        System.out.println("--admin");
        System.out.println("    Just start the FurnDB admin tool.");
        System.out.println();
        System.out.println("-s");
        System.out.println("--statistics");
        System.out.println("    Just start the statistics viewer tool.");
        System.out.println();
        System.out.println("-g");
        System.out.println("--genotype");
        System.out.println("    Just start the genotype editor tool.");
        System.out.println();
        System.out.println("-q=QUALITY");
        System.out.println("--quality=QUALITY");
        System.out.println("    This parameter allows to set the quality level. 0 is the");
        System.out.println("    lowest and applicable for slow graphic cards. The higher");
        System.out.println("    this setting is, the better the rendering quality will be.");
        System.out.println();
        System.out.println("-vs=VIEW_SETTINGS_FILE");
        System.out.println("--viewsettings=VIEW_SETTINGS_FILE");
        System.out.println("    This parameter is the view settings properties file. If none is given,");
        System.out.println("    a default view settings file will be used. VIEW_SETTINGS_FILE can be");
        System.out.println("    quoted. Example: -vs=\"c:\\viewsettings.properties\"");
        System.out.println();
        System.out.println("-f=SETTINGS_FILE");
        System.out.println("--file=SETTINGS_FILE");
        System.out.println("    This parameter is the GA settings XML file. If none is given,");
        System.out.println("    a default settings file will be used. SETTINGS_FILE can be");
        System.out.println("    quoted. Example: -f=\"c:\\mysettings.xml\"");
        System.out.println();
        System.out.println("-db=DATABASE_FILE");
        System.out.println("--database=DATABASE_FILE");
        System.out.println("    This parameter allows to define a custom database file");
        System.out.println("    for the FurnDB. DATABASE_FILE can be quoted.");
        System.out.println("    Example: -db=\"c:\\furndb\"");
        System.out.println();
        System.out.println("-sdb=STATISTICS_DATABASE_FILE");
        System.out.println("--statisticsdatabase=STATISTICS_DATABASE_FILE");
        System.out.println("    This parameter allows to define a custom database file");
        System.out.println("    for the statistics DB. This will only matter if the");
        System.out.println("    GADatabaseLogger is used. STATISTICS_DATABASE_FILE can");
        System.out.println("    be quoted. Example: -sdb=\"c:\\statisticsdb\"");
    }
}

