/*
 * Decompiled with CFR 0.152.
 */
package furny.states;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import furny.ga.FurnLayoutIndividual;
import furny.states.InitializerUIState;
import ga.core.algorithm.interactive.ISIGA;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.view.appstate.SceneState;
import ga.view.appstate.menu.MenuListener;
import ga.view.factory.EffectsFactory;
import ga.view.input.CamDragListener;
import ga.view.interfaces.IPhenotypeGenerator;
import ga.view.interfaces.IPreEvaluationState;
import ga.view.streaming.showroom.BoxShowRoom;
import ga.view.streaming.showroom.CameraSettings;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomFactory;
import ga.view.streaming.showroom.ShowRoomSettings;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class InitializerPreState
extends SceneState
implements IPreEvaluationState {
    private static final Logger LOGGER = Logger.getLogger(InitializerPreState.class.getName());
    private final IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator;
    private final ISIGA<FurnLayoutIndividual> algorithm;
    private ShowRoomFactory showRoomFactory;
    private ShowRoom showRoom;
    private final ShowRoomSettings srSettings = new ShowRoomSettings();
    private CameraSettings camSettings;
    private final IPhenotypeGenerator<FurnLayoutIndividual, Node> phenotypeGenerator;
    private CamDragListener dragListener;
    private MenuListener menuListener;
    private AppSettings settings;
    private InitializerUIState uiState;
    private FurnLayoutIndividual ind;

    public InitializerPreState(IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator, ISIGA<FurnLayoutIndividual> algorithm, IPhenotypeGenerator<FurnLayoutIndividual, Node> phenotypeGenerator) {
        this.evaluator = evaluator;
        this.algorithm = algorithm;
        this.phenotypeGenerator = phenotypeGenerator;
    }

    @Override
    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.settings = app.getContext().getSettings();
        this.srSettings.put("type", (Object)ShowRoomSettings.ShowRoomType.BOX);
        this.srSettings.put("width", Float.valueOf(5.0f));
        this.srSettings.put("length", Float.valueOf(5.0f));
        this.srSettings.put("height", Float.valueOf(2.6f));
        this.showRoomFactory = new ShowRoomFactory(this.assetManager, this.settings, this.srSettings);
        this.updateShowRoom();
        this.camSettings = CameraSettings.getOrthographicSettings(this.showRoom, this.settings);
        this.camSettings.configureCamera(this.cam);
        this.dragListener = new CamDragListener(this.cam, this.inputManager, this.camSettings);
        this.inputManager.addMapping("switch view", new Trigger[]{new KeyTrigger(47)});
        this.inputManager.addListener((InputListener)new ViewSwitchListener(), new String[]{"switch view"});
        EffectsFactory.addLightScatteringProcessor(this.assetManager, this.inputManager, this.settings, this.viewPort, new Vector3f(3.0f, 1.9f, 3.0f));
        EffectsFactory.addSSAOProcessor(this.assetManager, this.inputManager, this.settings, this.viewPort);
        this.uiState = new InitializerUIState(this.evaluator, this, this.menuListener);
        stateManager.attach((AppState)this.uiState);
    }

    public void setFloorTexture(String name) {
        this.srSettings.put("floorMaterial", this.assetManager.loadMaterial(name));
        this.updateShowRoom();
    }

    public void setWallColor(final ColorRGBA color) {
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                InitializerPreState.this.uiState.updateView();
                Material mat = InitializerPreState.this.showRoom.getWallMaterial().clone();
                mat.setColor("Diffuse", color);
                mat.setColor("Ambient", color.mult(0.8f));
                InitializerPreState.this.srSettings.put("wallMaterial", mat);
                InitializerPreState.this.updateShowRoom();
                return null;
            }
        });
    }

    public void saveSettings() {
        this.algorithm.getContext().put("ValidationSpace", (Object)this.showRoom);
        if (this.ind != null) {
            this.algorithm.getContext().put("InitIndividual", (Object)this.ind);
        }
    }

    public void setPopPercentage(final int percentage) {
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                InitializerPreState.this.algorithm.getContext().put("InitIndividualPercentage", (Object)percentage);
                InitializerPreState.this.uiState.updateView();
                return null;
            }
        });
    }

    public String getPopPercentageString() {
        return this.getPopPercentage() + "% of Population";
    }

    public int getPopPercentage() {
        return this.algorithm.getContext().getInt("InitIndividualPercentage", 5);
    }

    public String getRoomSizeString() {
        return this.getRoomWidth() + "cm * " + this.getRoomLength() + "cm * " + this.getRoomHeight() + "cm";
    }

    public int getRoomWidth() {
        return (int)(this.srSettings.getFloat("width", 5.0f).floatValue() * 100.0f);
    }

    public int getRoomLength() {
        return (int)(this.srSettings.getFloat("length", 5.0f).floatValue() * 100.0f);
    }

    public int getRoomHeight() {
        return (int)(this.srSettings.getFloat("height", 2.6f).floatValue() * 100.0f);
    }

    public void setRoomSize(final int width, final int length, final int height) {
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                InitializerPreState.this.srSettings.put("width", Float.valueOf((float)width / 100.0f));
                InitializerPreState.this.srSettings.put("length", Float.valueOf((float)length / 100.0f));
                InitializerPreState.this.srSettings.put("height", Float.valueOf((float)height / 100.0f));
                InitializerPreState.this.uiState.updateView();
                InitializerPreState.this.updateShowRoom();
                return null;
            }
        });
    }

    public void setIndividual(final FurnLayoutIndividual ind) {
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                InitializerPreState.this.ind = ind;
                InitializerPreState.this.uiState.updateView();
                InitializerPreState.this.updateShowRoom();
                return null;
            }
        });
    }

    public FurnLayoutIndividual getIndividual() {
        return this.ind;
    }

    public void setLightingType(final BoxShowRoom.LightingType lightingType) {
        this.app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                InitializerPreState.this.srSettings.put("LightingType", (Object)lightingType);
                InitializerPreState.this.updateShowRoom();
                return null;
            }
        });
    }

    public void updateShowRoom() {
        this.rootNode.detachAllChildren();
        this.showRoom = this.showRoomFactory.createShowRoom(true);
        if (this.ind != null) {
            try {
                this.showRoom.setPhenotype((Spatial)this.phenotypeGenerator.createPhenotype(this.ind));
            }
            catch (Exception e) {
                LOGGER.warning("Error creating phenotype");
            }
        }
        this.rootNode.attachChild((Spatial)this.showRoom);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dragListener != null) {
            this.dragListener.setEnabled(enabled);
        }
        if (this.uiState != null) {
            this.uiState.setEnabled(enabled);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.stateManager.detach((AppState)this.uiState);
    }

    private class ViewSwitchListener
    implements ActionListener {
        private int i = 1;

        private ViewSwitchListener() {
        }

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (!keyPressed) {
                int length = CameraSettings.Type.values().length;
                CameraSettings.Type type = CameraSettings.Type.values()[++this.i % length];
                InitializerPreState.this.camSettings = CameraSettings.getSettings(type, InitializerPreState.this.showRoomFactory.createShowRoom(), InitializerPreState.this.settings);
                InitializerPreState.this.camSettings.configureCamera(InitializerPreState.this.cam);
                InitializerPreState.this.dragListener.init(InitializerPreState.this.camSettings);
                LOGGER.info("Camera is now " + (Object)((Object)type));
            }
        }
    }
}

