/*
 * Decompiled with CFR 0.152.
 */
package furny.states;

import com.jme3.math.ColorRGBA;
import de.lessvoid.nifty.screen.DefaultScreenController;
import de.lessvoid.nifty.tools.Color;
import furny.ga.FurnLayoutIndividual;
import furny.ga.util.FurnLayoutIOUtil;
import furny.states.InitializerPreState;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.view.appstate.menu.IMenuListenerParent;
import ga.view.appstate.menu.MenuListener;
import ga.view.streaming.showroom.BoxShowRoom;
import ga.view.streaming.showroom.ShowRoom;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class InitializerUIController
extends DefaultScreenController
implements IMenuListenerParent {
    private final IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator;
    private final InitializerPreState state;
    private final List<String> floorTextures;
    private MenuListener menuListener;
    private ColorRGBA wallColor = ShowRoom.DEFAULT_COLOR;

    public InitializerUIController(IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator, InitializerPreState state) {
        this.evaluator = evaluator;
        this.state = state;
        this.floorTextures = new ArrayList<String>();
        this.addTexture("Wood_Floor_Dark_1.j3m");
        this.addTexture("Wood_Floor_Light_1.j3m");
        this.addTexture("Wood_Floor_Parquet_1.j3m");
        this.addTexture("Wood_Lumber_ButtJoined_1.j3m");
        this.addTexture("Tiles_Checker.j3m");
        this.addTexture("Tiles_White.j3m");
        this.addTexture("Carpet_Berber_Pattern_Gray_1.j3m");
        this.addTexture("Carpet_Loop_Pattern_1.j3m");
        this.addTexture("Carpet_Plush_Charcoal_1.j3m");
    }

    private void addTexture(String file) {
        this.floorTextures.add("furny/textures/" + file);
    }

    public void setWallColor(ColorRGBA wallColor) {
        this.wallColor = wallColor;
    }

    public void onTerminate() {
        this.state.saveSettings();
        if (this.menuListener != null) {
            this.menuListener.nextState();
        }
    }

    @Override
    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    public void onFloorTextureChange(String num) {
        int i = Integer.parseInt(num);
        this.state.setFloorTexture(this.floorTextures.get(i));
    }

    public String getRoomSizeString() {
        return this.state.getRoomSizeString();
    }

    public void onPopPercentageChange() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int newPerc;
                JPanel panel = new JPanel(new GridBagLayout());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.insets = new Insets(5, 5, 5, 5);
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.fill = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                int oldPerc = InitializerUIController.this.state.getPopPercentage();
                panel.add((Component)new JLabel("Initialize % of the Population with this Individual"), constraints);
                ++constraints.gridx;
                SpinnerNumberModel model = new SpinnerNumberModel(oldPerc, 1, 100, 1);
                JSpinner percentageSpinner = new JSpinner(model);
                panel.add((Component)percentageSpinner, constraints);
                int n = JOptionPane.showConfirmDialog(null, panel, "Select Percentage of this Individual", 2, -1);
                if (n == 0 && (newPerc = ((Integer)percentageSpinner.getValue()).intValue()) != oldPerc) {
                    InitializerUIController.this.state.setPopPercentage(newPerc);
                }
            }
        });
    }

    public void onRoomSizeChange() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.insets = new Insets(5, 5, 5, 5);
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.fill = 1;
                constraints.gridwidth = 1;
                constraints.gridheight = 1;
                constraints.weightx = 0.0;
                constraints.weighty = 0.0;
                int oldWidth = InitializerUIController.this.state.getRoomWidth();
                int oldLength = InitializerUIController.this.state.getRoomLength();
                int oldHeight = InitializerUIController.this.state.getRoomHeight();
                panel.add((Component)new JLabel("Room Width (cm)"), constraints);
                ++constraints.gridx;
                SpinnerNumberModel model = new SpinnerNumberModel(oldWidth, 50, 5000, 5);
                JSpinner widthSpinner = new JSpinner(model);
                panel.add((Component)widthSpinner, constraints);
                ++constraints.gridx;
                panel.add((Component)new JLabel("Room Length (cm)"), constraints);
                ++constraints.gridx;
                model = new SpinnerNumberModel(oldLength, 50, 5000, 5);
                JSpinner lengthSpinner = new JSpinner(model);
                panel.add((Component)lengthSpinner, constraints);
                ++constraints.gridx;
                panel.add((Component)new JLabel("Room Height (cm)"), constraints);
                ++constraints.gridx;
                model = new SpinnerNumberModel(oldHeight, 180, 350, 5);
                JSpinner heightSpinner = new JSpinner(model);
                panel.add((Component)heightSpinner, constraints);
                int n = JOptionPane.showConfirmDialog(null, panel, "Select Room Size", 2, -1);
                if (n == 0) {
                    int newWidth = (Integer)widthSpinner.getValue();
                    int newLength = (Integer)lengthSpinner.getValue();
                    int newHeight = (Integer)heightSpinner.getValue();
                    if (newWidth != oldWidth || newLength != oldLength || newHeight != oldHeight) {
                        InitializerUIController.this.state.setRoomSize(newWidth, newLength, newHeight);
                    }
                }
            }
        });
    }

    public String getPopPercentageString() {
        return this.state.getPopPercentageString();
    }

    public void onWallColorChange(String colorString) {
        Color niftyC = new Color(colorString);
        this.state.setWallColor(new ColorRGBA(niftyC.getRed(), niftyC.getGreen(), niftyC.getBlue(), niftyC.getAlpha()));
    }

    public void onLoadIndividual() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FurnLayoutIndividual ind = FurnLayoutIOUtil.loadGenotype(null, new FurnLayoutIndividual(InitializerUIController.this.evaluator.getAlgorithm().getContext()));
                if (ind != null) {
                    InitializerUIController.this.state.setIndividual(ind);
                }
            }
        });
    }

    public FurnLayoutIndividual getIndividual() {
        return this.state.getIndividual();
    }

    public void onResetIndividual() {
        this.state.setIndividual(null);
    }

    public void onLightingChange(String lightingType) {
        try {
            BoxShowRoom.LightingType type = BoxShowRoom.LightingType.valueOf(lightingType);
            this.state.setLightingType(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onWallColorSelect() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                java.awt.Color oldAwtC = new java.awt.Color(InitializerUIController.this.wallColor.getRed(), InitializerUIController.this.wallColor.getGreen(), InitializerUIController.this.wallColor.getBlue());
                java.awt.Color awtC = JColorChooser.showDialog(null, "Select Wall Color", oldAwtC);
                if (awtC != null && !oldAwtC.equals(awtC)) {
                    InitializerUIController.this.wallColor = new ColorRGBA((float)awtC.getRed() / 255.0f, (float)awtC.getGreen() / 255.0f, (float)awtC.getBlue() / 255.0f, (float)awtC.getAlpha() / 255.0f);
                    InitializerUIController.this.state.setWallColor(InitializerUIController.this.wallColor);
                }
            }
        });
    }

    public String getColorString() {
        return this.getColor().getColorString();
    }

    public Color getColor() {
        return new Color(this.wallColor.getRed(), this.wallColor.getGreen(), this.wallColor.getBlue(), this.wallColor.getAlpha());
    }

    public String getImageFile(int i) {
        return this.floorTextures.get(i).replace(".j3m", ".jpg");
    }
}

