/*
 * Decompiled with CFR 0.152.
 */
package furny.states;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.audio.AudioRenderer;
import com.jme3.niftygui.NiftyJmeDisplay;
import com.jme3.post.SceneProcessor;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.PanelRenderer;
import de.lessvoid.nifty.screen.ScreenController;
import furny.ga.FurnLayoutIndividual;
import furny.states.InitializerPreState;
import furny.states.InitializerUIController;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.view.appstate.GUIState;
import ga.view.appstate.menu.MenuListener;

public class InitializerUIState
extends GUIState {
    private final InitializerUIController controller;
    private NiftyJmeDisplay niftyDisplay;
    private Nifty nifty;
    private AudioRenderer audioRenderer;
    private final IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator;
    private final InitializerPreState state;
    private MenuListener menuListener;

    public InitializerUIState(IInteractiveFitnessEvaluator<FurnLayoutIndividual> evaluator, InitializerPreState state, MenuListener menuListener) {
        this.evaluator = evaluator;
        this.state = state;
        this.controller = new InitializerUIController(evaluator, state);
        this.controller.setMenuListener(menuListener);
    }

    public InitializerUIController getController() {
        return this.controller;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.audioRenderer = app.getAudioRenderer();
        this.setEnabled(true);
        for (int i = 0; i < 9; ++i) {
            Element niftyElement = this.nifty.getCurrentScreen().findElementByName("img_" + i);
            ((ImageRenderer)niftyElement.getRenderer(ImageRenderer.class)).setImage(this.nifty.createImage(this.controller.getImageFile(i), false));
        }
    }

    public void updateView() {
        ((PanelRenderer)this.nifty.getCurrentScreen().findElementByName("Panel_Color").getRenderer(PanelRenderer.class)).setBackgroundColor(this.controller.getColor());
        ((Button)this.nifty.getCurrentScreen().findElementByName("roomSizeButton").getNiftyControl(Button.class)).setText(this.controller.getRoomSizeString());
        Button b = (Button)this.nifty.getCurrentScreen().findElementByName("PopPercentageButton").getNiftyControl(Button.class);
        b.setText(this.controller.getPopPercentageString());
        boolean enabled = this.controller.getIndividual() != null;
        b.setEnabled(enabled);
        b = (Button)this.nifty.getCurrentScreen().findElementByName("ResetButton").getNiftyControl(Button.class);
        b.setEnabled(enabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.niftyDisplay = new NiftyJmeDisplay(this.assetManager, this.inputManager, this.audioRenderer, this.viewPort);
            this.nifty = this.niftyDisplay.getNifty();
            this.nifty.fromXml("furny/ui/initializerUI.xml", "start", new ScreenController[]{this.controller});
            this.viewPort.addProcessor((SceneProcessor)this.niftyDisplay);
            this.updateView();
        } else {
            try {
                if (this.nifty != null) {
                    this.viewPort.removeProcessor((SceneProcessor)this.niftyDisplay);
                    this.nifty.exit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        try {
            if (this.nifty != null) {
                this.viewPort.removeProcessor((SceneProcessor)this.niftyDisplay);
                this.nifty.exit();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanup();
    }
}

