/*
 * Decompiled with CFR 0.152.
 */
package furny.states;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import furny.ga.FurnLayoutIndividual;
import furny.ga.util.FurnLayoutIOUtil;
import furny.states.SummaryUIState;
import ga.core.algorithm.interactive.ISIGA;
import ga.core.evaluation.IInteractiveFitnessEvaluator;
import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.view.appstate.SceneState;
import ga.view.appstate.menu.MenuListener;
import ga.view.interfaces.IPhenotypeGenerator;
import ga.view.interfaces.IPostEvaluationState;
import ga.view.interfaces.MouseListener;
import ga.view.processor.OffscreenProcessor;
import ga.view.streaming.nodes.PanelNode;
import ga.view.streaming.showroom.CameraSettings;
import ga.view.streaming.showroom.ShowRoom;
import ga.view.streaming.showroom.ShowRoomFactory;
import ga.view.streaming.showroom.ShowRoomSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SummaryPostState<T extends IIndividual<T>>
extends SceneState
implements IPostEvaluationState {
    private static final int INDIVIDUAL_COUNT = 6;
    private SummaryMouseListener summaryMouseListener;
    private final List<PanelNode<T>> menuNodes = new ArrayList<PanelNode<T>>();
    private final IPhenotypeGenerator<T, Node> phenotypeGenerator;
    private final IInteractiveFitnessEvaluator<T> evaluator;
    private final ISIGA<T> algorithm;
    private MenuListener menuListener;
    private SummaryUIState<T> uiState;

    public SummaryPostState(IInteractiveFitnessEvaluator<T> evaluator, ISIGA<T> algorithm, IPhenotypeGenerator<T, Node> phenotypeGenerator) {
        this.evaluator = evaluator;
        this.algorithm = algorithm;
        this.phenotypeGenerator = phenotypeGenerator;
    }

    @Override
    public void initialize(AppStateManager stateManager, Application app) {
        ShowRoomSettings srSettings;
        super.initialize(stateManager, app);
        this.cam.setLocation(new Vector3f(0.0f, 4.5f, 0.0f));
        this.cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Z.negate());
        this.cam.setFrustumFar(50.0f);
        this.inputManager.addMapping("choosePostInd", new Trigger[]{new MouseButtonTrigger(0)});
        this.summaryMouseListener = new SummaryMouseListener();
        this.inputManager.addListener((InputListener)this.summaryMouseListener, new String[]{"choosePostInd"});
        Object o = this.algorithm.getContext().get("ValidationSpace");
        if (o != null && o instanceof ShowRoom) {
            srSettings = ((ShowRoom)o).getShowRoomSettings();
        } else {
            srSettings = new ShowRoomSettings();
            srSettings.put("type", (Object)ShowRoomSettings.ShowRoomType.BOX);
            srSettings.put("width", Float.valueOf(6.0f));
            srSettings.put("length", Float.valueOf(4.0f));
            srSettings.put("height", Float.valueOf(2.6f));
        }
        AppSettings settings = app.getContext().getSettings();
        ShowRoomFactory showRoomFactory = new ShowRoomFactory(this.assetManager, settings, srSettings);
        IndividualList<T> popIndividuals = new IndividualList<T>(this.algorithm.getPopulation().getIndividuals());
        IndividualList bestIndividuals = new IndividualList();
        popIndividuals.sort(true);
        for (IIndividual ind : popIndividuals) {
            if (bestIndividuals.contains(ind)) continue;
            bestIndividuals.add(ind);
            if (bestIndividuals.size() < 6) continue;
            break;
        }
        float x = -2.0f;
        float z = -1.0f;
        for (IIndividual ind : bestIndividuals) {
            ShowRoom showRoom = showRoomFactory.createShowRoom();
            CameraSettings camSettings = CameraSettings.getOrthographicSettings(showRoom, settings);
            Node phenotype = this.phenotypeGenerator.createPhenotype(ind);
            showRoom.setPhenotype((Spatial)phenotype);
            PanelNode<IIndividual> node = new PanelNode<IIndividual>(this.assetManager, settings, showRoom, camSettings, ind);
            node.setInfoStringType(PanelNode.InfoStringType.COSTS);
            node.setLocalTranslation(new Vector3f(x, 0.0f, z));
            node.scale(0.65f);
            node.setFadeSpeed(5.0f);
            OffscreenProcessor processor = node.getProcessor();
            this.viewPort.addProcessor((SceneProcessor)processor);
            this.menuNodes.add(node);
            this.rootNode.attachChild(node);
            if (!((x += 2.0f) > 2.0f)) continue;
            x = -2.0f;
            z = 1.0f;
        }
        this.rootNode.addLight((Light)new AmbientLight());
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(Vector3f.UNIT_Y.negate());
        this.rootNode.addLight((Light)dl);
        this.uiState = new SummaryUIState<T>(this.evaluator, this.menuListener);
        stateManager.attach(this.uiState);
    }

    @Override
    public void setMenuListener(MenuListener menuListener) {
        this.menuListener = menuListener;
    }

    private CollisionResults findPick(Node node) {
        Vector3f origin = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.0f);
        Vector3f direction = this.cam.getWorldCoordinates(this.inputManager.getCursorPosition(), 0.3f);
        direction.subtractLocal(origin).normalizeLocal();
        Ray ray = new Ray(origin, direction);
        CollisionResults results = new CollisionResults();
        node.collideWith((Collidable)ray, results);
        return results;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.summaryMouseListener != null) {
            this.summaryMouseListener.setEnabled(enabled);
        }
        if (this.uiState != null) {
            this.uiState.setEnabled(enabled);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.stateManager.detach(this.uiState);
    }

    private class SummaryMouseListener
    extends MouseListener {
        private SummaryMouseListener() {
        }

        @Override
        public void onAction(String name, boolean keyPressed, boolean isDoubleClick, float tpf) {
            if (!keyPressed) {
                CollisionResults results = SummaryPostState.this.findPick(SummaryPostState.this.rootNode);
                PanelNode selectedNode = null;
                CollisionResult r = results.getClosestCollision();
                if (r != null && r.getGeometry() != null && r.getGeometry().getParent() != null && r.getGeometry().getParent() instanceof PanelNode) {
                    selectedNode = (PanelNode)r.getGeometry().getParent();
                }
                if (selectedNode != null) {
                    this.setEnabled(false);
                    final PanelNode fSelectedNode = selectedNode;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final FurnLayoutIndividual ind = (FurnLayoutIndividual)FurnLayoutIndividual.class.cast(fSelectedNode.getIndividual());
                            final JPanel panel = new JPanel(new GridBagLayout());
                            GridBagConstraints constraints = new GridBagConstraints();
                            constraints.insets = new Insets(5, 5, 5, 5);
                            constraints.fill = 1;
                            constraints.weightx = 1.0;
                            constraints.gridx = 0;
                            constraints.gridy = 0;
                            panel.add((Component)new JLabel("Genotype:"), constraints);
                            ++constraints.gridx;
                            panel.add((Component)new JLabel(ind.getGenotypeString()), constraints);
                            ++constraints.gridx;
                            panel.add((Component)new JButton(new AbstractAction("Copy to Clipboard"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    StringSelection stringSelection = new StringSelection(ind.getGenotypeString());
                                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                    clipboard.setContents(stringSelection, null);
                                }
                            }), constraints);
                            ++constraints.gridx;
                            panel.add((Component)new JButton(new AbstractAction("Save"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    FurnLayoutIOUtil.saveGenotype(panel, ind);
                                }
                            }), constraints);
                            constraints.gridx = 0;
                            ++constraints.gridy;
                            panel.add((Component)new JLabel("Fitness:"), constraints);
                            ++constraints.gridx;
                            panel.add((Component)new JLabel(String.format(Locale.ENGLISH, "%.2f", ind.getFitness())), constraints);
                            constraints.gridx = 0;
                            ++constraints.gridy;
                            panel.add((Component)new JLabel("Costs:"), constraints);
                            ++constraints.gridx;
                            panel.add((Component)new JLabel(ind.getCostString()), constraints);
                            JOptionPane.showMessageDialog(null, panel, "Individual details", -1);
                            SummaryPostState.this.app.enqueue((Callable)new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    for (PanelNode node : SummaryPostState.this.menuNodes) {
                                        if (node == fSelectedNode) continue;
                                        node.setFadeToAlpha(1.0f);
                                    }
                                    SummaryMouseListener.this.setEnabled(true);
                                    return null;
                                }
                            });
                        }
                    });
                    for (PanelNode node : SummaryPostState.this.menuNodes) {
                        if (node == fSelectedNode) continue;
                        node.setFadeSpeed(10.0f);
                        node.setFadeToAlpha(0.2f);
                    }
                }
            }
        }
    }
}

